/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.getyarn;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.IdentifiedAudioReference;
import com.dunctebot.sourcemanagers.getyarn.GetyarnAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetyarnAudioSourceManager
extends AbstractDuncteBotHttpSource {
    private static final Pattern GETYARN_REGEX = Pattern.compile("(?:http://|https://(?:www\\.)?)?getyarn\\.io/yarn-clip/(.*)");

    public String getSourceName() {
        return "getyarn.io";
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        Matcher m = GETYARN_REGEX.matcher(reference.identifier);
        if (!m.matches()) {
            return null;
        }
        String videoId = m.group(m.groupCount());
        IdentifiedAudioReference ref = new IdentifiedAudioReference(videoId, reference.identifier, videoId);
        return new GetyarnAudioTrack(AudioTrackInfoBuilder.create((AudioReference)ref, null).build(), this);
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new GetyarnAudioTrack(trackInfo, this);
    }
}

