/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.mixcloud;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.Utils;
import com.dunctebot.sourcemanagers.mixcloud.MixcloudAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class MixcloudAudioSourceManager
extends AbstractDuncteBotHttpSource {
    private static final String REQUEST_STRUCTURE = "audioLength\n    name\n    owner {\n      username\n    }\n    streamInfo {\n      dashUrl\n      hlsUrl\n      url\n    }";
    private static final Pattern URL_REGEX = Pattern.compile("https?://(?:(?:www|beta|m)\\.)?mixcloud\\.com/([^/]+)/(?!stream|uploads|favorites|listens|playlists)([^/]+)/?");

    public String getSourceName() {
        return "mixcloud";
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        Matcher matcher = URL_REGEX.matcher(reference.identifier);
        if (!matcher.matches()) {
            return null;
        }
        while (true) {
            try {
                return this.loadItemOnce(reference, matcher);
            }
            catch (Exception e) {
                if (HttpClientTools.isRetriableNetworkException((Throwable)e)) continue;
                throw ExceptionTools.wrapUnfriendlyExceptions((String)"Loading information for a MixCloud track failed.", (FriendlyException.Severity)FriendlyException.Severity.FAULT, (Throwable)e);
            }
            break;
        }
    }

    private AudioItem loadItemOnce(AudioReference reference, Matcher matcher) throws IOException {
        String slug;
        String username = Utils.urlDecode(matcher.group(1));
        JsonBrowser trackInfo = this.extractTrackInfoGraphQl(username, slug = Utils.urlDecode(matcher.group(2)));
        if (trackInfo == null) {
            return AudioReference.NO_TRACK;
        }
        String title = trackInfo.get("name").text();
        long duration = (Long)trackInfo.get("audioLength").as(Long.class) * 1000L;
        String uploader = trackInfo.get("owner").get("username").text();
        return new MixcloudAudioTrack(new AudioTrackInfo(title, uploader, duration, slug, false, reference.identifier), this);
    }

    protected JsonBrowser extractTrackInfoGraphQl(String username, String slug) throws IOException {
        String slugFormatted = slug == null ? "" : String.format(", slug: \"%s\"", slug);
        String query = String.format("{\n  cloudcastLookup(lookup: {username: \"%s\"%s}) {\n    %s\n  }\n}", username, slugFormatted, REQUEST_STRUCTURE);
        String encodedQuery = Utils.urlEncode(query);
        HttpGet httpGet = new HttpGet("https://www.mixcloud.com/graphql?query=" + encodedQuery);
        try (CloseableHttpResponse res = this.getHttpInterface().execute((HttpUriRequest)httpGet);){
            int statusCode = res.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                if (statusCode == 404) {
                    JsonBrowser jsonBrowser = null;
                    return jsonBrowser;
                }
                throw new IOException("Invalid status code for Mixcloud track page response: " + statusCode);
            }
            String content = IOUtils.toString(res.getEntity().getContent(), StandardCharsets.UTF_8);
            JsonBrowser json = JsonBrowser.parse((String)content).get("data").get("cloudcastLookup");
            if (json.get("streamInfo").isNull()) {
                JsonBrowser jsonBrowser = null;
                return jsonBrowser;
            }
            JsonBrowser jsonBrowser = json;
            return jsonBrowser;
        }
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new MixcloudAudioTrack(trackInfo, this);
    }
}

