/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.reddit;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.AudioTrackInfoWithImage;
import com.dunctebot.sourcemanagers.Utils;
import com.dunctebot.sourcemanagers.reddit.RedditAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class RedditAudioSourceManager
extends AbstractDuncteBotHttpSource {
    private static final Pattern FULL_LINK_REGEX = Pattern.compile("https:\\/\\/(?:www|old)\\.reddit\\.com\\/r\\/(?:[^\\/]+)\\/(?:[^\\/]+)\\/([^\\/]+)(?:\\/?(?:[^\\/]+)?\\/?)?");
    private static final Pattern VIDEO_LINK_REGEX = Pattern.compile("https:\\/\\/v\\.redd\\.it\\/([^\\/]+)(?:.*)?");

    public RedditAudioSourceManager() {
        this.configureBuilder(builder -> builder.setUserAgent("Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/114.0"));
    }

    public String getSourceName() {
        return "reddit";
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String identifier = reference.identifier;
        Matcher fullLink = FULL_LINK_REGEX.matcher(identifier);
        if (fullLink.matches()) {
            String group = fullLink.group(fullLink.groupCount());
            JsonBrowser data = this.fetchJson(group);
            return this.buildTrack(data, identifier);
        }
        Matcher videoLink = VIDEO_LINK_REGEX.matcher(identifier);
        if (videoLink.matches()) {
            String actualRedditUrl = this.fetchRedirectUrl(identifier);
            String id = this.getPostId(actualRedditUrl);
            JsonBrowser data = this.fetchJson(id);
            return this.buildTrack(data, actualRedditUrl);
        }
        return null;
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new RedditAudioTrack(trackInfo, this);
    }

    private String getPostId(String url) {
        Matcher matcher = FULL_LINK_REGEX.matcher(url);
        if (matcher.matches()) {
            return matcher.group(matcher.groupCount());
        }
        return url;
    }

    private String fetchRedirectUrl(String vRedditUrl) {
        String string;
        block8: {
            HttpGet httpGet = new HttpGet(vRedditUrl);
            HttpInterface httpInterface = this.getHttpInterface();
            CloseableHttpResponse ignored = httpInterface.execute((HttpUriRequest)httpGet);
            try {
                string = httpInterface.getFinalLocation().toString();
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ExceptionTools.wrapUnfriendlyExceptions((String)"Could not load data from reddit", (FriendlyException.Severity)FriendlyException.Severity.COMMON, (Throwable)e);
                }
            }
            ignored.close();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private JsonBrowser fetchJson(String pageURl) {
        HttpGet httpGet = new HttpGet("https://api.reddit.com/api/info/?id=t3_" + pageURl);
        try (CloseableHttpResponse response = this.getHttpInterface().execute((HttpUriRequest)httpGet);){
            String content = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
            JsonBrowser child = JsonBrowser.parse((String)content).get("data").get("children").index(0);
            if (child.equals(JsonBrowser.NULL_BROWSER)) {
                JsonBrowser jsonBrowser2 = null;
                return jsonBrowser2;
            }
            JsonBrowser jsonBrowser = child.get("data");
            return jsonBrowser;
        }
        catch (IOException e) {
            throw ExceptionTools.wrapUnfriendlyExceptions((String)"Could not load data from reddit", (FriendlyException.Severity)FriendlyException.Severity.COMMON, (Throwable)e);
        }
    }

    private boolean canPlayAudio(String id) {
        boolean bl;
        block8: {
            HttpGet httpGet = new HttpGet(RedditAudioTrack.getPlaybackUrl(id));
            CloseableHttpResponse response = this.getHttpInterface().execute((HttpUriRequest)httpGet);
            try {
                boolean bl2 = bl = response.getStatusLine().getStatusCode() == 200;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    private AudioItem buildTrack(@Nullable JsonBrowser data, String pageURl) {
        if (data == null) {
            return AudioReference.NO_TRACK;
        }
        String postHint = data.get("post_hint").safeText();
        if (!"hosted:video".equals(postHint)) {
            throw new FriendlyException("This video is not hosted on the reddit website, only videos hosted on the reddit website can be played", FriendlyException.Severity.COMMON, null);
        }
        JsonBrowser media = data.get("media").get("reddit_video");
        String url = data.get("url").safeText();
        if (media.get("is_gif").asBoolean(false)) {
            throw new FriendlyException("Cannot play gifs", FriendlyException.Severity.COMMON, null);
        }
        Matcher videoLink = VIDEO_LINK_REGEX.matcher(url);
        if (!videoLink.matches()) {
            return AudioReference.NO_TRACK;
        }
        String videoId = videoLink.group(videoLink.groupCount());
        if (!this.canPlayAudio(videoId)) {
            throw new FriendlyException("This video does not have audio", FriendlyException.Severity.COMMON, null);
        }
        String thumbnail = data.get("thumbnail").safeText();
        if (!Utils.isURL(thumbnail)) {
            thumbnail = null;
        }
        return new RedditAudioTrack(new AudioTrackInfoWithImage(data.get("title").safeText(), "u/" + data.get("author").safeText(), media.get("duration").asLong(1L) * 1000L, videoId, false, pageURl, thumbnail), this);
    }
}

