/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.soundgasm;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.soundgasm.SoundGasmAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class SoundGasmAudioSourceManager
extends AbstractDuncteBotHttpSource {
    private static final Pattern URL_PATTERN = Pattern.compile("https?:\\/\\/soundgasm\\.net\\/u\\/(?<path>(?<author>[^\\/]+)\\/[^\\/]+)");
    private static final Pattern SOUND_PATTERN = Pattern.compile("m4a:(?:\\s+)?[\"']https:\\/\\/media\\.soundgasm\\.net\\/sounds\\/([^.]+)\\.m4a[\"']");
    private static final Pattern TITLE_PATTERN = Pattern.compile("<div class=\"jp-title\" aria-label=\"title\">([^<]+)<\\/div>");

    public String getSourceName() {
        return "soundgasm";
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String url = reference.identifier;
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (!urlMatcher.matches()) {
            return null;
        }
        String fetchUrl = "https://soundgasm.net/u/" + urlMatcher.group("path");
        while (true) {
            try {
                return this.loadItemOnce(fetchUrl, urlMatcher);
            }
            catch (Exception e) {
                if (HttpClientTools.isRetriableNetworkException((Throwable)e)) continue;
                throw ExceptionTools.wrapUnfriendlyExceptions((String)"Loading of soundgasm track went wrong", (FriendlyException.Severity)FriendlyException.Severity.FAULT, (Throwable)e);
            }
            break;
        }
    }

    private AudioItem loadItemOnce(String fetchUrl, Matcher urlMatcher) throws IOException {
        HttpGet httpGet = new HttpGet(fetchUrl);
        try (CloseableHttpResponse res = this.getHttpInterface().execute((HttpUriRequest)httpGet);){
            int statusCode = res.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                if (statusCode == 404) {
                    AudioReference audioReference = AudioReference.NO_TRACK;
                    return audioReference;
                }
                throw new IOException("Invalid status code for soundgasm track page response: " + statusCode);
            }
            String content = IOUtils.toString(res.getEntity().getContent(), StandardCharsets.UTF_8);
            Matcher soundPatternMatcher = SOUND_PATTERN.matcher(content);
            if (!soundPatternMatcher.find()) {
                throw new FriendlyException("Failed to extract audio file", FriendlyException.Severity.FAULT, null);
            }
            Matcher titleMatcher = TITLE_PATTERN.matcher(content);
            String title = titleMatcher.find() ? titleMatcher.group(titleMatcher.groupCount()) : "Unknown title";
            String identifier = soundPatternMatcher.group(soundPatternMatcher.groupCount());
            SoundGasmAudioTrack soundGasmAudioTrack = new SoundGasmAudioTrack(new AudioTrackInfo(title, urlMatcher.group("author"), Long.MAX_VALUE, identifier, false, fetchUrl), this);
            return soundGasmAudioTrack;
        }
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new SoundGasmAudioTrack(trackInfo, this);
    }
}

