/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.tiktok;

import com.dunctebot.sourcemanagers.Utils;
import com.sedmelluq.discord.lavaplayer.tools.http.HttpContextFilter;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import java.util.stream.Collectors;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;

public class TikTokAudioTrackHttpManager
implements AutoCloseable {
    protected final HttpInterfaceManager httpInterfaceManager;
    private final CookieStore cookieStore = new BasicCookieStore();

    public TikTokAudioTrackHttpManager() {
        this.httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
        this.httpInterfaceManager.configureBuilder(builder -> builder.setDefaultCookieStore(this.cookieStore));
        this.httpInterfaceManager.setHttpContextFilter((HttpContextFilter)new TikTokFilter());
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void close() throws Exception {
        this.httpInterfaceManager.close();
    }

    private class TikTokFilter
    implements HttpContextFilter {
        private TikTokFilter() {
        }

        public void onContextOpen(HttpClientContext context) {
            context.setCookieStore(TikTokAudioTrackHttpManager.this.cookieStore);
        }

        public void onContextClose(HttpClientContext context) {
        }

        public void onRequest(HttpClientContext context, HttpUriRequest request, boolean isRepetition) {
            boolean isVideo = request.getURI().getPath().contains("video");
            Utils.fakeChrome((HttpRequest)request, isVideo);
            String testCookie = context.getCookieStore().getCookies().stream().map(c -> c.getName() + "=" + c.getValue()).collect(Collectors.joining("; "));
            request.setHeader("Cookie", testCookie);
            request.setHeader("Referer", "https://www.tiktok.com/");
        }

        public boolean onRequestResponse(HttpClientContext context, HttpUriRequest request, HttpResponse response) {
            return false;
        }

        public boolean onRequestException(HttpClientContext context, HttpUriRequest request, Throwable error) {
            return false;
        }
    }
}

