/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.tiktok;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.AudioTrackInfoWithImage;
import com.dunctebot.sourcemanagers.Utils;
import com.dunctebot.sourcemanagers.tiktok.TikTokAudioTrack;
import com.dunctebot.sourcemanagers.tiktok.TikTokAudioTrackHttpManager;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class TikTokAudioSourceManager
extends AbstractDuncteBotHttpSource {
    private final TikTokAudioTrackHttpManager httpManager = new TikTokAudioTrackHttpManager();
    private static final String BASE = "https:\\/\\/(?:www\\.|m\\.)?tiktok\\.com";
    private static final String USER = "@(?<user>[^/]+)";
    private static final String VIDEO = "(?<video>[0-9]+)";
    protected static final Pattern VIDEO_REGEX = Pattern.compile("^https:\\/\\/(?:www\\.|m\\.)?tiktok\\.com\\/@(?<user>[^/]+)\\/video\\/(?<video>[0-9]+)(?:.*)$");
    private static final Pattern JS_REGEX = Pattern.compile("<script id=\"SIGI_STATE\" type=\"application/json\">([^<]+)<\\/script>");
    private static final Pattern SIGI_REGEX = Pattern.compile("<script id=\"sigi-persisted-data\">(?:\n)?window\\[(?:'SIGI_STATE'|\"SIGI_STATE\")\\](?:\\s+)?=(?:\\s+)?(.*);(?:\\s+)?(?:.*)?<\\/script>");

    public TikTokAudioSourceManager() {
        super(false);
    }

    public String getSourceName() {
        return "tiktok";
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        Matcher matcher = VIDEO_REGEX.matcher(reference.identifier);
        if (!matcher.matches()) {
            return null;
        }
        String user = matcher.group("user");
        String video = matcher.group("video");
        try {
            MetaData metaData = this.extractData(user, video);
            return new TikTokAudioTrack(metaData.toTrackInfo(), this);
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions((String)"Something went wrong", (FriendlyException.Severity)FriendlyException.Severity.SUSPICIOUS, (Throwable)e);
        }
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new TikTokAudioTrack(trackInfo, this);
    }

    MetaData extractData(String userId, String videoId) throws Exception {
        System.out.println("userId: " + userId + ", videoId: " + videoId);
        return this.extractData("https://www.tiktok.com/@" + userId + "/video/" + videoId);
    }

    @Override
    public HttpInterface getHttpInterface() {
        return this.httpManager.getHttpInterface();
    }

    protected MetaData extractData(String url) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        Utils.fakeChrome((HttpRequest)httpGet);
        try (CloseableHttpResponse response = this.getHttpInterface().execute((HttpUriRequest)httpGet);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                if (statusCode == 302) {
                    MetaData metaData = null;
                    return metaData;
                }
                throw new IOException("Unexpected status code for video page response: " + statusCode);
            }
            String html = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
            Matcher matcher = JS_REGEX.matcher(html);
            if (matcher.find()) {
                JsonBrowser json = JsonBrowser.parse((String)matcher.group(1).trim());
                String videoId = json.get("ItemList").get("video").get("list").index(0).text();
                JsonBrowser base = json.get("ItemModule").get(videoId);
                MetaData metaData = TikTokAudioSourceManager.getMetaData(url, base);
                return metaData;
            }
            Matcher sigiMatcher = SIGI_REGEX.matcher(html);
            if (sigiMatcher.find()) {
                JsonBrowser json = JsonBrowser.parse((String)sigiMatcher.group(1).trim());
                String videoId = json.get("ItemList").get("video").get("keyword").text();
                JsonBrowser video = json.get("ItemModule").get(videoId);
                MetaData metaData = TikTokAudioSourceManager.getMetaData(url, video);
                return metaData;
            }
            System.out.println(html);
            throw new FriendlyException("Failed to find data for tiktok video", FriendlyException.Severity.SUSPICIOUS, null);
        }
    }

    protected static MetaData getMetaData(String url, JsonBrowser base) {
        MetaData metaData = new MetaData();
        JsonBrowser videoJson = base.get("video");
        metaData.pageUrl = url;
        metaData.videoId = base.get("id").safeText();
        metaData.videoUrl = videoJson.get("downloadAddr").text();
        metaData.cover = videoJson.get("cover").safeText();
        metaData.title = base.get("desc").safeText();
        metaData.uri = videoJson.get("playAddr").safeText();
        metaData.duration = Integer.parseInt(videoJson.get("duration").safeText());
        metaData.musicUrl = base.get("music").get("playUrl").text();
        metaData.uniqueId = base.get("author").safeText();
        return metaData;
    }

    protected static class MetaData {
        String cover;
        String pageUrl;
        String videoId;
        String videoUrl;
        String uri;
        int duration;
        String title;
        String musicUrl;
        String uniqueId;

        protected MetaData() {
        }

        AudioTrackInfoWithImage toTrackInfo() {
            return new AudioTrackInfoWithImage(this.title, this.uniqueId, (long)this.duration * 1000L, this.videoId, false, this.pageUrl, this.cover);
        }

        public String toString() {
            return "MetaData{cover='" + this.cover + "', pageUrl='" + this.pageUrl + "', videoId='" + this.videoId + "', videoUrl='" + this.videoUrl + "', uri='" + this.uri + "', duration=" + this.duration + ", title='" + this.title + "', uniqueId='" + this.uniqueId + "'}";
        }
    }
}

