/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.tiktok;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.MpegTrack;
import com.dunctebot.sourcemanagers.Pair;
import com.dunctebot.sourcemanagers.tiktok.TikTokAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;

public class TikTokAudioTrack
extends MpegTrack {
    private Pair<String, String> urlCache = null;
    private boolean failedOnce = false;

    public TikTokAudioTrack(AudioTrackInfo trackInfo, AbstractDuncteBotHttpSource manager) {
        super(trackInfo, manager);
    }

    public Pair<String, String> getUrlCache() {
        return this.urlCache;
    }

    @Override
    public String getPlaybackUrl() {
        try {
            if (this.urlCache == null) {
                this.urlCache = this.loadPlaybackUrl();
            }
            if (this.failedOnce) {
                return this.urlCache.getRight();
            }
            return this.urlCache.getLeft();
        }
        catch (Exception e) {
            throw new FriendlyException("Could not load TikTok video", FriendlyException.Severity.SUSPICIOUS, (Throwable)e);
        }
    }

    @Override
    public void process(LocalAudioTrackExecutor executor) throws Exception {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            this.loadStream(executor, httpInterface);
        }
    }

    @Override
    protected void loadStream(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface) throws Exception {
        try {
            super.loadStream(localExecutor, httpInterface);
        }
        catch (Exception e) {
            if (this.failedOnce) {
                throw e;
            }
            this.failedOnce = true;
            super.loadStream(localExecutor, httpInterface);
        }
    }

    protected Pair<String, String> loadPlaybackUrl() throws Exception {
        TikTokAudioSourceManager.MetaData metdata = this.getSourceManager().extractData(this.trackInfo.author, this.trackInfo.identifier);
        return new Pair<String, String>(metdata.videoUrl, metdata.musicUrl);
    }

    @Override
    protected InternalAudioTrack createAudioTrack(AudioTrackInfo trackInfo, SeekableInputStream stream) {
        if (this.failedOnce && this.urlCache.getRight().contains(".mp3")) {
            return new Mp3AudioTrack(trackInfo, stream);
        }
        return super.createAudioTrack(trackInfo, stream);
    }

    @Override
    protected long getTrackDuration() {
        return Long.MAX_VALUE;
    }

    @Override
    protected HttpInterface getHttpInterface() {
        return this.getSourceManager().getHttpInterface();
    }

    @Override
    public TikTokAudioSourceManager getSourceManager() {
        return (TikTokAudioSourceManager)super.getSourceManager();
    }

    protected AudioTrack makeShallowClone() {
        return new TikTokAudioTrack(this.trackInfo, this.getSourceManager());
    }
}

