/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.clypit;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.IdentifiedAudioReference;
import com.dunctebot.sourcemanagers.clypit.ClypitAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class ClypitAudioSourceManager
extends AbstractDuncteBotHttpSource {
    private static final Pattern CLYPIT_REGEX = Pattern.compile("(http://|https://(www\\.)?)?clyp\\.it/(.*)");

    public String getSourceName() {
        return "clypit";
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        Matcher m = CLYPIT_REGEX.matcher(reference.identifier);
        if (!m.matches()) {
            return null;
        }
        try {
            String clypitId = m.group(m.groupCount());
            JsonBrowser json = this.fetchJson(clypitId);
            if (json == null) {
                return AudioReference.NO_TRACK;
            }
            IdentifiedAudioReference ref = new IdentifiedAudioReference(json.get("Mp3Url").safeText(), reference.identifier, json.get("Title").safeText());
            return new ClypitAudioTrack(AudioTrackInfoBuilder.create((AudioReference)ref, null).build(), this);
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions((String)"Something went wrong", (FriendlyException.Severity)FriendlyException.Severity.SUSPICIOUS, (Throwable)e);
        }
    }

    private JsonBrowser fetchJson(String itemId) throws IOException {
        HttpGet httpGet = new HttpGet("https://api.clyp.it/" + itemId);
        try (CloseableHttpResponse response = this.getHttpInterface().execute((HttpUriRequest)httpGet);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                if (statusCode == 404) {
                    JsonBrowser jsonBrowser = null;
                    return jsonBrowser;
                }
                throw new IOException("Unexpected status code for video page response: " + statusCode);
            }
            String json = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
            JsonBrowser jsonBrowser = JsonBrowser.parse((String)json);
            return jsonBrowser;
        }
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new ClypitAudioTrack(trackInfo, this);
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }
}

