/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.mixcloud;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.MpegTrack;
import com.dunctebot.sourcemanagers.Utils;
import com.dunctebot.sourcemanagers.mixcloud.MixcloudAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import java.util.Base64;

public class MixcloudAudioTrack
extends MpegTrack {
    private static final String DECRYPTION_KEY = "IFYOUWANTTHEARTISTSTOGETPAIDDONOTDOWNLOADFROMMIXCLOUD";

    public MixcloudAudioTrack(AudioTrackInfo trackInfo, AbstractDuncteBotHttpSource manager) {
        super(trackInfo, manager);
    }

    @Override
    protected long getTrackDuration() {
        return Long.MAX_VALUE;
    }

    @Override
    public String getPlaybackUrl() {
        try {
            JsonBrowser trackInfo = this.getSourceManager().extractTrackInfoGraphQl(this.trackInfo.author, Utils.urlDecode(this.trackInfo.identifier));
            String encryptedUrl = trackInfo.get("streamInfo").get("url").text();
            String xorUrl = new String(Base64.getDecoder().decode(encryptedUrl));
            return Utils.decryptXor(xorUrl, DECRYPTION_KEY);
        }
        catch (IOException e) {
            throw ExceptionTools.wrapUnfriendlyExceptions((String)"Playback of mixcloud track failed", (FriendlyException.Severity)FriendlyException.Severity.SUSPICIOUS, (Throwable)e);
        }
    }

    protected AudioTrack makeShallowClone() {
        return new MixcloudAudioTrack(this.trackInfo, this.getSourceManager());
    }

    @Override
    public MixcloudAudioSourceManager getSourceManager() {
        return (MixcloudAudioSourceManager)super.getSourceManager();
    }
}

