/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mp3Track
extends DelegatedAudioTrack {
    protected static final Logger log = LoggerFactory.getLogger(Mp3Track.class);
    private final AbstractDuncteBotHttpSource manager;

    public Mp3Track(AudioTrackInfo trackInfo, AbstractDuncteBotHttpSource manager) {
        super(trackInfo);
        this.manager = manager;
    }

    protected HttpInterface getHttpInterface() {
        return this.manager.getHttpInterface();
    }

    public void process(LocalAudioTrackExecutor executor) throws Exception {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            this.loadStream(executor, httpInterface);
        }
    }

    protected void loadStream(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface) throws Exception {
        String trackUrl = this.getPlaybackUrl();
        log.debug("Starting {} track from URL: {}", (Object)this.manager.getSourceName(), (Object)trackUrl);
        try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(trackUrl), Long.valueOf(this.getTrackDuration()));){
            this.processDelegate(this.createAudioTrack(this.trackInfo, (SeekableInputStream)stream), localExecutor);
        }
    }

    protected InternalAudioTrack createAudioTrack(AudioTrackInfo trackInfo, SeekableInputStream stream) {
        return new Mp3AudioTrack(trackInfo, stream);
    }

    protected long getTrackDuration() {
        return this.trackInfo.length;
    }

    public String getPlaybackUrl() {
        return this.trackInfo.identifier;
    }

    public AbstractDuncteBotHttpSource getSourceManager() {
        return this.manager;
    }
}

