/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.mixcloud;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.Utils;
import com.dunctebot.sourcemanagers.mixcloud.MixcloudAudioTrack;
import com.dunctebot.sourcemanagers.mixcloud.MixcloudLookup;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class MixcloudAudioSourceManager
extends AbstractDuncteBotHttpSource {
    private static final String THUMBNAILER_BASE = "https://thumbnailer.mixcloud.com/unsafe/390x390/";
    private static final String GRAPHQL_AUDIO_REQUEST = "query PlayerHeroQuery(\n    $lookup: CloudcastLookup!\n) {\n    cloudcast: cloudcastLookup(lookup: $lookup) {\n        id\n        name\n        picture {\n            isLight\n            primaryColor\n            darkPrimaryColor: primaryColor(darken: 60)\n            ...UGCImage_picture\n        }\n        owner {\n            ...AudioPageAvatar_user\n            id\n        }\n        restrictedReason\n        seekRestriction\n        ...PlayButton_cloudcast\n    }\n}\n\nfragment AudioPageAvatar_user on User {\n    displayName\n    username\n}\n\nfragment PlayButton_cloudcast on Cloudcast {\n    restrictedReason\n    owner {\n        displayName\n        country\n        username\n        isSubscribedTo\n        isViewer\n        id\n    }\n    slug\n    id\n    isDraft\n    isPlayable\n    streamInfo {\n        hlsUrl\n        dashUrl\n        url\n        uuid\n    }\n    audioLength\n    seekRestriction\n}\n\nfragment UGCImage_picture on Picture {\n    urlRoot\n    primaryColor\n}\n";
    private static final Pattern URL_REGEX = Pattern.compile("https?://(?:(?:www|beta|m)\\.)?mixcloud\\.com/([^/]+)/(?!stream|uploads|favorites|listens|playlists)([^/]+)/?");

    public String getSourceName() {
        return "mixcloud";
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        Matcher matcher = URL_REGEX.matcher(reference.identifier);
        if (!matcher.matches()) {
            return null;
        }
        while (true) {
            try {
                return this.loadItemOnce(reference, matcher);
            }
            catch (Exception e) {
                if (HttpClientTools.isRetriableNetworkException((Throwable)e)) continue;
                throw ExceptionTools.wrapUnfriendlyExceptions((String)"Loading information for a MixCloud track failed.", (FriendlyException.Severity)FriendlyException.Severity.FAULT, (Throwable)e);
            }
            break;
        }
    }

    private AudioItem loadItemOnce(AudioReference reference, Matcher matcher) throws IOException {
        String slug;
        String username = Utils.urlDecode(matcher.group(1));
        JsonBrowser trackInfo = this.extractTrackInfoGraphQl(username, slug = Utils.urlDecode(matcher.group(2)));
        if (trackInfo == null) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser restrictedReason = trackInfo.get("restrictedReason");
        if (!restrictedReason.isNull()) {
            throw new FriendlyException("Playback of this track is restricted.", FriendlyException.Severity.COMMON, (Throwable)new Exception(restrictedReason.text()));
        }
        String picturePath = trackInfo.get("picture").get("urlRoot").text();
        String title = trackInfo.get("name").text();
        long duration = (Long)trackInfo.get("audioLength").as(Long.class) * 1000L;
        String uploader = trackInfo.get("owner").get("username").text();
        return new MixcloudAudioTrack(new AudioTrackInfo(title, uploader, duration, slug, false, reference.identifier, THUMBNAILER_BASE + picturePath, null), this);
    }

    protected JsonBrowser extractTrackInfoGraphQl(String username, String slug) throws IOException {
        JsonBrowser body = JsonBrowser.newMap();
        body.put("query", (Object)GRAPHQL_AUDIO_REQUEST);
        JsonBrowser variables = JsonBrowser.newMap();
        variables.put("lookup", (Object)new MixcloudLookup(slug, username));
        body.put("variables", (Object)variables);
        HttpPost httpPost = new HttpPost("https://app.mixcloud.com/graphql");
        httpPost.setEntity((HttpEntity)new StringEntity(body.text(), ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse res = this.getHttpInterface().execute((HttpUriRequest)httpPost);){
            int statusCode = res.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                if (statusCode == 404) {
                    JsonBrowser jsonBrowser = null;
                    return jsonBrowser;
                }
                throw new IOException("Invalid status code for Mixcloud track page response: " + statusCode);
            }
            String content = IOUtils.toString(res.getEntity().getContent(), StandardCharsets.UTF_8);
            JsonBrowser json = JsonBrowser.parse((String)content).get("data").get("cloudcast");
            if (json.get("streamInfo").isNull()) {
                JsonBrowser jsonBrowser = null;
                return jsonBrowser;
            }
            JsonBrowser jsonBrowser = json;
            return jsonBrowser;
        }
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new MixcloudAudioTrack(trackInfo, this);
    }
}

