/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.ocremix;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.ocremix.OCRemixAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class OCRemixAudioSourceManager
extends AbstractDuncteBotHttpSource {
    private static final Pattern REMIX_PATTERN = Pattern.compile("(?:https?://(?:www\\.)?ocremix\\.org/remix/)?(?<id>OCR[\\d]+)(?:.*)?");

    public String getSourceName() {
        return "ocremix";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String identifier = reference.identifier;
        Matcher matcher = REMIX_PATTERN.matcher(identifier);
        if (!matcher.matches()) {
            return null;
        }
        String id = matcher.group("id");
        HttpGet httpGet = new HttpGet("https://ocremix.org/remix/" + id + "?view=xml");
        try (CloseableHttpResponse response = this.getHttpInterface().execute((HttpUriRequest)httpGet);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Unexpected status code for OCR page response: " + statusCode);
            }
            String xml = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
            Document jsoup = Jsoup.parse(xml);
            OCRTrackMeta meta = this.extractTrackData(jsoup);
            if (meta == null) {
                AudioItem audioItem = null;
                return audioItem;
            }
            AudioTrackInfo info = new AudioTrackInfo(meta.name, meta.remixers, meta.trackLength, meta.fileName, false, "https://ocremix.org/remix/" + meta.id);
            OCRemixAudioTrack oCRemixAudioTrack = new OCRemixAudioTrack(info, this);
            return oCRemixAudioTrack;
        }
        catch (IOException e) {
            throw ExceptionTools.wrapUnfriendlyExceptions((String)"Something went wrong", (FriendlyException.Severity)FriendlyException.Severity.SUSPICIOUS, (Throwable)e);
        }
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new OCRemixAudioTrack(trackInfo, this);
    }

    @Nullable
    private OCRTrackMeta extractTrackData(Element elem) {
        Element remix = elem.selectFirst("remix");
        if (remix == null) {
            return null;
        }
        String remixers = elem.selectFirst("remixers").children().stream().map(remixer -> remixer.attr("name")).collect(Collectors.joining(", "));
        return new OCRTrackMeta(remix.attr("id"), remix.attr("name"), remix.attr("file_name"), Long.parseLong(remix.attr("track_length")) * 1000L, remixers);
    }

    static final class OCRTrackMeta {
        public final String id;
        public final String name;
        public final String fileName;
        public final long trackLength;
        public final String remixers;

        OCRTrackMeta(String id, String name, String fileName, long trackLength, String remixers) {
            this.id = id;
            this.name = name;
            this.fileName = fileName;
            this.trackLength = trackLength;
            this.remixers = remixers;
        }
    }
}

