/*
 * Decompiled with CFR 0.152.
 */
package com.dunctebot.sourcemanagers.speech;

import com.dunctebot.sourcemanagers.AbstractDuncteBotHttpSource;
import com.dunctebot.sourcemanagers.speech.SpeechAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class SpeechAudioSourceManager
extends AbstractDuncteBotHttpSource {
    private static final String PREFIX = "speak:";
    private static final String GOOGLE_TRANSLATE_URL = "https://translate.google.com/translate_tts?tl=%language%&q=%query%&ie=UTF-8&total=1&idx=0&textlen=%length%&client=tw-ob";
    private final String templateURL;

    public SpeechAudioSourceManager(String language) {
        this.templateURL = GOOGLE_TRANSLATE_URL.replace("%language%", language);
    }

    public String getSourceName() {
        return "speak";
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        if (!reference.identifier.startsWith(PREFIX) || reference.identifier.length() <= PREFIX.length()) {
            return null;
        }
        String data = reference.identifier.substring(PREFIX.length());
        data = data.trim().replaceAll("^\\s+", "");
        String encoded = URLEncoder.encode(data, StandardCharsets.UTF_8);
        String mp3URL = this.templateURL.replace("%length%", Integer.toString(data.length())).replace("%query%", encoded);
        return new SpeechAudioTrack(new AudioTrackInfo("Speaking " + data, "TTS B0t", Long.MAX_VALUE, reference.identifier, false, mp3URL), this);
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new SpeechAudioTrack(trackInfo, this);
    }
}

