/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavalyrics.plugin;

import com.github.topi314.lavalyrics.LyricsManager;
import com.github.topi314.lavalyrics.api.LyricsPluginInfoModifier;
import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.github.topi314.lavalyrics.plugin.UtilKt;
import com.github.topi314.lavalyrics.protocol.Lyrics;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageInput;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.arbjerg.lavalink.api.IPlayer;
import dev.arbjerg.lavalink.api.ISocketContext;
import dev.arbjerg.lavalink.api.ISocketServer;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J4\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u000f2\b\b\u0001\u0010\u0014\u001a\u00020\u000f2\b\b\u0003\u0010\u001c\u001a\u00020\u001dH\u0007J*\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001f\u001a\u00020\u000f2\b\b\u0003\u0010\u001c\u001a\u00020\u001dH\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/topi314/lavalyrics/plugin/AudioLyricsRestHandler;", "", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "socketServer", "Ldev/arbjerg/lavalink/api/ISocketServer;", "lyricsManager", "Lcom/github/topi314/lavalyrics/LyricsManager;", "pluginInfoModifiers", "", "Lcom/github/topi314/lavalyrics/api/LyricsPluginInfoModifier;", "(Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Ldev/arbjerg/lavalink/api/ISocketServer;Lcom/github/topi314/lavalyrics/LyricsManager;Ljava/util/List;)V", "decodeTrack", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "message", "", "existingPlayer", "Ldev/arbjerg/lavalink/api/IPlayer;", "socketContext", "Ldev/arbjerg/lavalink/api/ISocketContext;", "guildId", "", "loadCurrentTrackLyrics", "Lorg/springframework/http/ResponseEntity;", "Lcom/github/topi314/lavalyrics/protocol/Lyrics;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "sessionId", "skipTrackSource", "", "loadLyrics", "track", "Companion", "lavalyrics-plugin"})
public final class AudioLyricsRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final ISocketServer socketServer;
    @NotNull
    private final LyricsManager lyricsManager;
    @NotNull
    private final List<LyricsPluginInfoModifier> pluginInfoModifiers;
    private static final Logger log = LoggerFactory.getLogger(AudioLyricsRestHandler.class);

    public AudioLyricsRestHandler(@NotNull AudioPlayerManager audioPlayerManager, @NotNull ISocketServer socketServer, @NotNull LyricsManager lyricsManager, @NotNull List<? extends LyricsPluginInfoModifier> pluginInfoModifiers) {
        Intrinsics.checkNotNullParameter(audioPlayerManager, "audioPlayerManager");
        Intrinsics.checkNotNullParameter(socketServer, "socketServer");
        Intrinsics.checkNotNullParameter(lyricsManager, "lyricsManager");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, "pluginInfoModifiers");
        this.audioPlayerManager = audioPlayerManager;
        this.socketServer = socketServer;
        this.lyricsManager = lyricsManager;
        this.pluginInfoModifiers = pluginInfoModifiers;
    }

    private final ISocketContext socketContext(ISocketServer socketServer, String sessionId) {
        ISocketContext iSocketContext = (ISocketContext)socketServer.getSessions().get(sessionId);
        if (iSocketContext == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Session not found");
        }
        return iSocketContext;
    }

    private final IPlayer existingPlayer(ISocketContext socketContext, long guildId) {
        IPlayer iPlayer = (IPlayer)socketContext.getPlayers().get(guildId);
        if (iPlayer == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Player not found");
        }
        return iPlayer;
    }

    private final AudioTrack decodeTrack(AudioPlayerManager audioPlayerManager, String message) {
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(message));
        AudioTrack audioTrack = audioPlayerManager.decodeTrack((MessageInput)new MessageInput((InputStream)((InputStream)bais))).decodedTrack;
        if (audioTrack == null) {
            throw new IllegalStateException("Failed to decode track due to a mismatching version or missing source manager");
        }
        return audioTrack;
    }

    @GetMapping(value={"/v4/sessions/{sessionId}/players/{guildId}/track/lyrics"})
    @NotNull
    public final ResponseEntity<Lyrics> loadCurrentTrackLyrics(@NotNull HttpServletRequest request, @PathVariable @NotNull String sessionId, @PathVariable @NotNull String guildId, @RequestParam boolean skipTrackSource) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(sessionId, "sessionId");
        Intrinsics.checkNotNullParameter(guildId, "guildId");
        Object[] objectArray = new Object[]{sessionId, guildId, skipTrackSource};
        log.debug("getCurrentTrackLyrics called with sessionId: {}, guildId: {}, skipTrackSource: {}", objectArray);
        ISocketContext socketContext = this.socketContext(this.socketServer, sessionId);
        IPlayer player = this.existingPlayer(socketContext, Long.parseLong(guildId));
        if (player.getTrack() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "No track playing");
        }
        AudioLyrics lyrics = this.lyricsManager.loadLyrics(player.getTrack(), skipTrackSource);
        if (lyrics != null) {
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)UtilKt.toLyrics(lyrics, this.pluginInfoModifiers));
            Intrinsics.checkNotNull(responseEntity2);
            responseEntity = responseEntity2;
        } else {
            ResponseEntity responseEntity3 = ResponseEntity.noContent().build();
            responseEntity = responseEntity3;
            Intrinsics.checkNotNullExpressionValue(responseEntity3, "build(...)");
        }
        return responseEntity;
    }

    public static /* synthetic */ ResponseEntity loadCurrentTrackLyrics$default(AudioLyricsRestHandler audioLyricsRestHandler, HttpServletRequest httpServletRequest, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return audioLyricsRestHandler.loadCurrentTrackLyrics(httpServletRequest, string, string2, bl);
    }

    @GetMapping(value={"/v4/lyrics"})
    @NotNull
    public final ResponseEntity<Lyrics> loadLyrics(@NotNull HttpServletRequest request, @RequestParam @NotNull String track, @RequestParam boolean skipTrackSource) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(track, "track");
        log.debug("loadLyrics called with track: {}, skipTrackSource: {}", (Object)track, (Object)skipTrackSource);
        AudioTrack decodedTrack = this.decodeTrack(this.audioPlayerManager, track);
        AudioLyrics lyrics = this.lyricsManager.loadLyrics(decodedTrack, skipTrackSource);
        if (lyrics != null) {
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)UtilKt.toLyrics(lyrics, this.pluginInfoModifiers));
            Intrinsics.checkNotNull(responseEntity2);
            responseEntity = responseEntity2;
        } else {
            ResponseEntity responseEntity3 = ResponseEntity.noContent().build();
            responseEntity = responseEntity3;
            Intrinsics.checkNotNullExpressionValue(responseEntity3, "build(...)");
        }
        return responseEntity;
    }

    public static /* synthetic */ ResponseEntity loadLyrics$default(AudioLyricsRestHandler audioLyricsRestHandler, HttpServletRequest httpServletRequest, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return audioLyricsRestHandler.loadLyrics(httpServletRequest, string, bl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/topi314/lavalyrics/plugin/AudioLyricsRestHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "lavalyrics-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

