/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavalyrics.plugin;

import com.github.topi314.lavalyrics.LyricsManager;
import com.github.topi314.lavalyrics.api.LyricsManagerConfiguration;
import com.github.topi314.lavalyrics.plugin.LavaLyricsConfig;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/github/topi314/lavalyrics/plugin/LyricsConfiguration;", "", "config", "Lcom/github/topi314/lavalyrics/plugin/LavaLyricsConfig;", "(Lcom/github/topi314/lavalyrics/plugin/LavaLyricsConfig;)V", "getConfig", "()Lcom/github/topi314/lavalyrics/plugin/LavaLyricsConfig;", "audioLyricsManagerSupplier", "Lcom/github/topi314/lavalyrics/LyricsManager;", "lyricsManagerConfigurations", "", "Lcom/github/topi314/lavalyrics/api/LyricsManagerConfiguration;", "lavalyrics-plugin"})
public class LyricsConfiguration {
    @NotNull
    private final LavaLyricsConfig config;

    public LyricsConfiguration(@NotNull LavaLyricsConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this.config = config;
    }

    @NotNull
    public final LavaLyricsConfig getConfig() {
        return this.config;
    }

    @Bean
    @NotNull
    public LyricsManager audioLyricsManagerSupplier(@NotNull Collection<? extends LyricsManagerConfiguration> lyricsManagerConfigurations) {
        Intrinsics.checkNotNullParameter(lyricsManagerConfigurations, "lyricsManagerConfigurations");
        LyricsManager manager = new LyricsManager();
        for (LyricsManagerConfiguration lyricsManagerConfiguration : lyricsManagerConfigurations) {
            manager = lyricsManagerConfiguration.configure(manager);
        }
        manager.sortLyricsManagers(this.config.getSources());
        return manager;
    }
}

