/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavalyrics;

import com.github.topi314.lavalyrics.AudioLyricsManager;
import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LyricsManager {
    private static final Logger log = LoggerFactory.getLogger(LyricsManager.class);
    private final List<AudioLyricsManager> lyricsManagers = new ArrayList<AudioLyricsManager>();

    public void registerLyricsManager(AudioLyricsManager lyricsManager) {
        this.lyricsManagers.add(lyricsManager);
    }

    public void sortLyricsManagers(List<String> lyricsManagers) {
        log.info("Sorting lyrics managers");
        this.lyricsManagers.sort(Comparator.comparing(audioLyricsManager -> lyricsManagers.contains(audioLyricsManager.getSourceName())));
        log.info("Sorted lyrics managers");
    }

    @Nullable
    public <T extends AudioLyricsManager> T lyrics(Class<T> klass) {
        for (AudioLyricsManager lyricsManager : this.lyricsManagers) {
            if (!klass.isAssignableFrom(lyricsManager.getClass())) continue;
            return (T)((AudioLyricsManager)klass.cast(lyricsManager));
        }
        return null;
    }

    public List<AudioLyricsManager> getLyricsManagers() {
        return Collections.unmodifiableList(this.lyricsManagers);
    }

    public void shutdown() {
        for (AudioLyricsManager lyricsManager : this.lyricsManagers) {
            lyricsManager.shutdown();
        }
    }

    @Nullable
    public AudioLyrics loadLyrics(AudioTrack track) {
        return this.loadLyrics(track, false);
    }

    @Nullable
    public AudioLyrics loadLyrics(AudioTrack track, boolean skipTrackSource) {
        AudioLyrics lyrics;
        if (this.lyricsManagers.isEmpty()) {
            throw new IllegalStateException("No lyrics managers registered");
        }
        if (!skipTrackSource) {
            String trackLyricsManagerName = track.getSourceManager().getSourceName();
            Optional<AudioLyricsManager> trackLyricsManager = this.lyricsManagers.stream().filter(audioLyricsManager -> audioLyricsManager.getSourceName().equals(trackLyricsManagerName)).findFirst();
            if (trackLyricsManager.isPresent() && (lyrics = trackLyricsManager.get().loadLyrics(track)) != null) {
                return lyrics;
            }
        }
        for (AudioLyricsManager lyricsManager : this.lyricsManagers) {
            lyrics = lyricsManager.loadLyrics(track);
            if (lyrics == null) continue;
            return lyrics;
        }
        return null;
    }
}

