/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavalyrics.plugin;

import com.github.topi314.lavalyrics.LyricsManager;
import com.github.topi314.lavalyrics.api.LyricsPluginInfoModifier;
import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.github.topi314.lavalyrics.plugin.LavaLyricsPluginEventHandler;
import com.github.topi314.lavalyrics.plugin.LineHandler;
import com.github.topi314.lavalyrics.plugin.UtilKt;
import com.github.topi314.lavalyrics.protocol.Lyrics;
import com.github.topi314.lavalyrics.protocol.LyricsFoundEvent;
import com.github.topi314.lavalyrics.protocol.LyricsNotFoundEvent;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageInput;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import dev.arbjerg.lavalink.api.IPlayer;
import dev.arbjerg.lavalink.api.ISocketContext;
import dev.arbjerg.lavalink.api.ISocketServer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00122\b\b\u0003\u0010\u0014\u001a\u00020\u0015H\u0007J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0017\u001a\u00020\u00122\b\b\u0003\u0010\u0014\u001a\u00020\u0015H\u0007J,\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00122\b\b\u0003\u0010\u0014\u001a\u00020\u0015H\u0007J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/topi314/lavalyrics/plugin/LavaLyricsPlugin;", "", "lavaLyricsPluginEventHandler", "Lcom/github/topi314/lavalyrics/plugin/LavaLyricsPluginEventHandler;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "socketServer", "Ldev/arbjerg/lavalink/api/ISocketServer;", "lyricsManager", "Lcom/github/topi314/lavalyrics/LyricsManager;", "pluginInfoModifiers", "", "Lcom/github/topi314/lavalyrics/api/LyricsPluginInfoModifier;", "(Lcom/github/topi314/lavalyrics/plugin/LavaLyricsPluginEventHandler;Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Ldev/arbjerg/lavalink/api/ISocketServer;Lcom/github/topi314/lavalyrics/LyricsManager;Ljava/util/List;)V", "loadCurrentTrackLyrics", "Lorg/springframework/http/ResponseEntity;", "Lcom/github/topi314/lavalyrics/protocol/Lyrics;", "sessionId", "", "guildId", "skipTrackSource", "", "loadLyrics", "track", "subscribeToLyrics", "Ljava/lang/Void;", "unsubscribeFromLyrics", "Companion", "lavalyrics-plugin"})
public final class LavaLyricsPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LavaLyricsPluginEventHandler lavaLyricsPluginEventHandler;
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final ISocketServer socketServer;
    @NotNull
    private final LyricsManager lyricsManager;
    @NotNull
    private final List<LyricsPluginInfoModifier> pluginInfoModifiers;
    @NotNull
    private static final Logger log;

    public LavaLyricsPlugin(@NotNull LavaLyricsPluginEventHandler lavaLyricsPluginEventHandler, @NotNull AudioPlayerManager audioPlayerManager, @NotNull ISocketServer socketServer, @NotNull LyricsManager lyricsManager, @NotNull List<? extends LyricsPluginInfoModifier> pluginInfoModifiers) {
        Intrinsics.checkNotNullParameter((Object)lavaLyricsPluginEventHandler, "lavaLyricsPluginEventHandler");
        Intrinsics.checkNotNullParameter(audioPlayerManager, "audioPlayerManager");
        Intrinsics.checkNotNullParameter(socketServer, "socketServer");
        Intrinsics.checkNotNullParameter(lyricsManager, "lyricsManager");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, "pluginInfoModifiers");
        this.lavaLyricsPluginEventHandler = lavaLyricsPluginEventHandler;
        this.audioPlayerManager = audioPlayerManager;
        this.socketServer = socketServer;
        this.lyricsManager = lyricsManager;
        this.pluginInfoModifiers = pluginInfoModifiers;
        log.info("Loading LavaLyrics plugin...");
    }

    @PostMapping(value={"/v4/sessions/{sessionId}/players/{guildId}/lyrics/subscribe"})
    @NotNull
    public final ResponseEntity<Void> subscribeToLyrics(@PathVariable @NotNull String sessionId, @PathVariable @NotNull String guildId, @RequestParam boolean skipTrackSource) {
        AudioLyrics lyrics;
        IPlayer player;
        ISocketContext socketContext;
        block9: {
            block8: {
                Unit unit;
                Intrinsics.checkNotNullParameter(sessionId, "sessionId");
                Intrinsics.checkNotNullParameter(guildId, "guildId");
                Object[] objectArray = new Object[]{sessionId, guildId, skipTrackSource};
                log.debug("session {} guild {} subscribed to lyrics (skipTrackSource: {})", objectArray);
                LavaLyricsPluginEventHandler.LyricsSubscriptionConfig config = new LavaLyricsPluginEventHandler.LyricsSubscriptionConfig(skipTrackSource);
                Map<Long, LavaLyricsPluginEventHandler.LyricsSubscriptionConfig> map = this.lavaLyricsPluginEventHandler.getSubscribedPlayers().get(sessionId);
                if (map != null) {
                    map.put(Long.parseLong(guildId), config);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    ResponseEntity responseEntity = ResponseEntity.noContent().build();
                    Intrinsics.checkNotNullExpressionValue(responseEntity, "build(...)");
                    return responseEntity;
                }
                socketContext = Companion.socketContext(this.socketServer, sessionId);
                player = Companion.existingPlayer(socketContext, Long.parseLong(guildId));
                if (player.getTrack() == null) {
                    ResponseEntity responseEntity = ResponseEntity.noContent().build();
                    Intrinsics.checkNotNullExpressionValue(responseEntity, "build(...)");
                    return responseEntity;
                }
                lyrics = this.lyricsManager.loadLyrics(player.getTrack(), config.getSkipTrackSource());
                if (lyrics == null || lyrics.getLines() == null) break block8;
                List<AudioLyrics.Line> list = lyrics.getLines();
                Intrinsics.checkNotNull(list);
                if (!list.isEmpty()) break block9;
            }
            socketContext.sendMessage((SerializationStrategy)LyricsNotFoundEvent.Companion.serializer(), (Object)new LyricsNotFoundEvent(guildId));
            ResponseEntity responseEntity = ResponseEntity.noContent().build();
            Intrinsics.checkNotNullExpressionValue(responseEntity, "build(...)");
            return responseEntity;
        }
        socketContext.sendMessage((SerializationStrategy)LyricsFoundEvent.Companion.serializer(), (Object)new LyricsFoundEvent(guildId, UtilKt.toLyrics(lyrics, this.pluginInfoModifiers)));
        AudioTrack audioTrack = player.getTrack();
        if (audioTrack != null) {
            List<AudioLyrics.Line> list = lyrics.getLines();
            Intrinsics.checkNotNull(list);
            long l = list.get(0).getTimestamp().toMillis();
            long l2 = Long.parseLong(guildId);
            AudioTrack audioTrack2 = player.getTrack();
            Intrinsics.checkNotNull(audioTrack2);
            List<AudioLyrics.Line> list2 = lyrics.getLines();
            Intrinsics.checkNotNull(list2);
            audioTrack.addMarker(new TrackMarker(l, (TrackMarkerHandler)new LineHandler(socketContext, this.pluginInfoModifiers, l2, audioTrack2, list2)));
        }
        ResponseEntity responseEntity = ResponseEntity.noContent().build();
        Intrinsics.checkNotNullExpressionValue(responseEntity, "build(...)");
        return responseEntity;
    }

    public static /* synthetic */ ResponseEntity subscribeToLyrics$default(LavaLyricsPlugin lavaLyricsPlugin, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return lavaLyricsPlugin.subscribeToLyrics(string, string2, bl);
    }

    @DeleteMapping(value={"/v4/sessions/{sessionId}/players/{guildId}/lyrics/subscribe"})
    @NotNull
    public final ResponseEntity<Void> unsubscribeFromLyrics(@PathVariable @NotNull String sessionId, @PathVariable @NotNull String guildId) {
        Intrinsics.checkNotNullParameter(sessionId, "sessionId");
        Intrinsics.checkNotNullParameter(guildId, "guildId");
        log.debug("session {} guild {} unsubscribed from lyrics", (Object)sessionId, (Object)guildId);
        Map<Long, LavaLyricsPluginEventHandler.LyricsSubscriptionConfig> map = this.lavaLyricsPluginEventHandler.getSubscribedPlayers().get(sessionId);
        if (map != null) {
            map.remove(Long.parseLong(guildId));
        }
        ResponseEntity responseEntity = ResponseEntity.noContent().build();
        Intrinsics.checkNotNullExpressionValue(responseEntity, "build(...)");
        return responseEntity;
    }

    @GetMapping(value={"/v4/sessions/{sessionId}/players/{guildId}/track/lyrics"})
    @NotNull
    public final ResponseEntity<Lyrics> loadCurrentTrackLyrics(@PathVariable @NotNull String sessionId, @PathVariable @NotNull String guildId, @RequestParam boolean skipTrackSource) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter(sessionId, "sessionId");
        Intrinsics.checkNotNullParameter(guildId, "guildId");
        Object[] objectArray = new Object[]{sessionId, guildId, skipTrackSource};
        log.debug("getCurrentTrackLyrics called with sessionId: {}, guildId: {}, skipTrackSource: {}", objectArray);
        ISocketContext socketContext = Companion.socketContext(this.socketServer, sessionId);
        IPlayer player = Companion.existingPlayer(socketContext, Long.parseLong(guildId));
        if (player.getTrack() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "No track playing");
        }
        AudioLyrics lyrics = this.lyricsManager.loadLyrics(player.getTrack(), skipTrackSource);
        if (lyrics != null) {
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)UtilKt.toLyrics(lyrics, this.pluginInfoModifiers));
            Intrinsics.checkNotNull(responseEntity2);
            responseEntity = responseEntity2;
        } else {
            ResponseEntity responseEntity3 = ResponseEntity.noContent().build();
            responseEntity = responseEntity3;
            Intrinsics.checkNotNullExpressionValue(responseEntity3, "build(...)");
        }
        return responseEntity;
    }

    public static /* synthetic */ ResponseEntity loadCurrentTrackLyrics$default(LavaLyricsPlugin lavaLyricsPlugin, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return lavaLyricsPlugin.loadCurrentTrackLyrics(string, string2, bl);
    }

    @GetMapping(value={"/v4/lyrics"})
    @NotNull
    public final ResponseEntity<Lyrics> loadLyrics(@RequestParam @NotNull String track, @RequestParam boolean skipTrackSource) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter(track, "track");
        log.debug("loadLyrics called with track: {}, skipTrackSource: {}", (Object)track, (Object)skipTrackSource);
        AudioTrack decodedTrack = Companion.decodeTrack(this.audioPlayerManager, track);
        AudioLyrics lyrics = this.lyricsManager.loadLyrics(decodedTrack, skipTrackSource);
        if (lyrics != null) {
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)UtilKt.toLyrics(lyrics, this.pluginInfoModifiers));
            Intrinsics.checkNotNull(responseEntity2);
            responseEntity = responseEntity2;
        } else {
            ResponseEntity responseEntity3 = ResponseEntity.noContent().build();
            responseEntity = responseEntity3;
            Intrinsics.checkNotNullExpressionValue(responseEntity3, "build(...)");
        }
        return responseEntity;
    }

    public static /* synthetic */ ResponseEntity loadLyrics$default(LavaLyricsPlugin lavaLyricsPlugin, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lavaLyricsPlugin.loadLyrics(string, bl);
    }

    static {
        Logger logger = LoggerFactory.getLogger(LavaLyricsPlugin.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/github/topi314/lavalyrics/plugin/LavaLyricsPlugin$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "decodeTrack", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "message", "", "existingPlayer", "Ldev/arbjerg/lavalink/api/IPlayer;", "socketContext", "Ldev/arbjerg/lavalink/api/ISocketContext;", "guildId", "", "socketServer", "Ldev/arbjerg/lavalink/api/ISocketServer;", "sessionId", "lavalyrics-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final ISocketContext socketContext(@NotNull ISocketServer socketServer, @NotNull String sessionId) {
            Intrinsics.checkNotNullParameter(socketServer, "socketServer");
            Intrinsics.checkNotNullParameter(sessionId, "sessionId");
            ISocketContext iSocketContext = (ISocketContext)socketServer.getSessions().get(sessionId);
            if (iSocketContext == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Session not found");
            }
            return iSocketContext;
        }

        @NotNull
        public final IPlayer existingPlayer(@NotNull ISocketContext socketContext, long guildId) {
            Intrinsics.checkNotNullParameter(socketContext, "socketContext");
            IPlayer iPlayer = (IPlayer)socketContext.getPlayers().get(guildId);
            if (iPlayer == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Player not found");
            }
            return iPlayer;
        }

        @NotNull
        public final AudioTrack decodeTrack(@NotNull AudioPlayerManager audioPlayerManager, @NotNull String message) {
            Intrinsics.checkNotNullParameter(audioPlayerManager, "audioPlayerManager");
            Intrinsics.checkNotNullParameter(message, "message");
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(message));
            AudioTrack audioTrack = audioPlayerManager.decodeTrack((MessageInput)new MessageInput((InputStream)((InputStream)bais))).decodedTrack;
            if (audioTrack == null) {
                throw new IllegalStateException("Failed to decode track due to a mismatching version or missing source manager");
            }
            return audioTrack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

