/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavalyrics.plugin;

import com.github.topi314.lavalyrics.LyricsManager;
import com.github.topi314.lavalyrics.api.LyricsPluginInfoModifier;
import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.github.topi314.lavalyrics.plugin.LineHandler;
import com.github.topi314.lavalyrics.plugin.UtilKt;
import com.github.topi314.lavalyrics.protocol.LyricsFoundEvent;
import com.github.topi314.lavalyrics.protocol.LyricsNotFoundEvent;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import dev.arbjerg.lavalink.api.IPlayer;
import dev.arbjerg.lavalink.api.ISocketContext;
import dev.arbjerg.lavalink.api.PluginEventHandler;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/github/topi314/lavalyrics/plugin/LavaLyricsPluginEventHandler;", "Ldev/arbjerg/lavalink/api/PluginEventHandler;", "lyricsManager", "Lcom/github/topi314/lavalyrics/LyricsManager;", "pluginInfoModifiers", "", "Lcom/github/topi314/lavalyrics/api/LyricsPluginInfoModifier;", "(Lcom/github/topi314/lavalyrics/LyricsManager;Ljava/util/List;)V", "subscribedPlayers", "", "", "", "Lcom/github/topi314/lavalyrics/plugin/LavaLyricsPluginEventHandler$LyricsSubscriptionConfig;", "getSubscribedPlayers", "()Ljava/util/Map;", "onDestroyPlayer", "", "context", "Ldev/arbjerg/lavalink/api/ISocketContext;", "player", "Ldev/arbjerg/lavalink/api/IPlayer;", "onNewPlayer", "onSocketContextDestroyed", "onWebSocketOpen", "resumed", "", "LyricsSubscriptionConfig", "PlayerListener", "lavalyrics-plugin"})
public final class LavaLyricsPluginEventHandler
extends PluginEventHandler {
    @NotNull
    private final LyricsManager lyricsManager;
    @NotNull
    private final List<LyricsPluginInfoModifier> pluginInfoModifiers;
    @NotNull
    private final Map<String, Map<Long, LyricsSubscriptionConfig>> subscribedPlayers;

    public LavaLyricsPluginEventHandler(@NotNull LyricsManager lyricsManager, @NotNull List<? extends LyricsPluginInfoModifier> pluginInfoModifiers) {
        Intrinsics.checkNotNullParameter(lyricsManager, "lyricsManager");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, "pluginInfoModifiers");
        this.lyricsManager = lyricsManager;
        this.pluginInfoModifiers = pluginInfoModifiers;
        this.subscribedPlayers = new LinkedHashMap();
    }

    @NotNull
    public final Map<String, Map<Long, LyricsSubscriptionConfig>> getSubscribedPlayers() {
        return this.subscribedPlayers;
    }

    public void onWebSocketOpen(@NotNull ISocketContext context, boolean resumed) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.subscribedPlayers.put(context.getSessionId(), new LinkedHashMap());
    }

    public void onSocketContextDestroyed(@NotNull ISocketContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.subscribedPlayers.remove(context.getSessionId());
    }

    public void onNewPlayer(@NotNull ISocketContext context, @NotNull IPlayer player) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(player, "player");
        player.getAudioPlayer().addListener((AudioEventListener)new PlayerListener(this, context, player.getGuildId()));
    }

    public void onDestroyPlayer(@NotNull ISocketContext context, @NotNull IPlayer player) {
        block0: {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(player, "player");
            Map<Long, LyricsSubscriptionConfig> map = this.subscribedPlayers.get(String.valueOf(player.getGuildId()));
            if (map == null) break block0;
            map.remove(player.getGuildId());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/github/topi314/lavalyrics/plugin/LavaLyricsPluginEventHandler$LyricsSubscriptionConfig;", "", "skipTrackSource", "", "(Z)V", "getSkipTrackSource", "()Z", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "lavalyrics-plugin"})
    public static final class LyricsSubscriptionConfig {
        private final boolean skipTrackSource;

        public LyricsSubscriptionConfig(boolean skipTrackSource) {
            this.skipTrackSource = skipTrackSource;
        }

        public final boolean getSkipTrackSource() {
            return this.skipTrackSource;
        }

        public final boolean component1() {
            return this.skipTrackSource;
        }

        @NotNull
        public final LyricsSubscriptionConfig copy(boolean skipTrackSource) {
            return new LyricsSubscriptionConfig(skipTrackSource);
        }

        public static /* synthetic */ LyricsSubscriptionConfig copy$default(LyricsSubscriptionConfig lyricsSubscriptionConfig, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = lyricsSubscriptionConfig.skipTrackSource;
            }
            return lyricsSubscriptionConfig.copy(bl);
        }

        @NotNull
        public String toString() {
            return "LyricsSubscriptionConfig(skipTrackSource=" + this.skipTrackSource + ")";
        }

        public int hashCode() {
            int n = this.skipTrackSource ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LyricsSubscriptionConfig)) {
                return false;
            }
            LyricsSubscriptionConfig lyricsSubscriptionConfig = (LyricsSubscriptionConfig)other;
            return this.skipTrackSource == lyricsSubscriptionConfig.skipTrackSource;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/topi314/lavalyrics/plugin/LavaLyricsPluginEventHandler$PlayerListener;", "Lcom/sedmelluq/discord/lavaplayer/player/event/AudioEventAdapter;", "plugin", "Lcom/github/topi314/lavalyrics/plugin/LavaLyricsPluginEventHandler;", "socketContext", "Ldev/arbjerg/lavalink/api/ISocketContext;", "guildId", "", "(Lcom/github/topi314/lavalyrics/plugin/LavaLyricsPluginEventHandler;Ldev/arbjerg/lavalink/api/ISocketContext;J)V", "onTrackStart", "", "player", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayer;", "track", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "lavalyrics-plugin"})
    public static final class PlayerListener
    extends AudioEventAdapter {
        @NotNull
        private final LavaLyricsPluginEventHandler plugin;
        @NotNull
        private final ISocketContext socketContext;
        private final long guildId;

        public PlayerListener(@NotNull LavaLyricsPluginEventHandler plugin, @NotNull ISocketContext socketContext, long guildId) {
            Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
            Intrinsics.checkNotNullParameter(socketContext, "socketContext");
            this.plugin = plugin;
            this.socketContext = socketContext;
            this.guildId = guildId;
        }

        public void onTrackStart(@NotNull AudioPlayer player, @NotNull AudioTrack track) {
            AudioLyrics lyrics;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter(player, "player");
                    Intrinsics.checkNotNullParameter(track, "track");
                    Map<Long, LyricsSubscriptionConfig> map = this.plugin.getSubscribedPlayers().get(this.socketContext.getSessionId());
                    if (map == null || (map = map.get(this.guildId)) == null) {
                        return;
                    }
                    Map<Long, LyricsSubscriptionConfig> config = map;
                    lyrics = this.plugin.lyricsManager.loadLyrics(track, ((LyricsSubscriptionConfig)((Object)config)).getSkipTrackSource());
                    if (lyrics == null || lyrics.getLines() == null) break block4;
                    List<AudioLyrics.Line> list = lyrics.getLines();
                    Intrinsics.checkNotNull(list);
                    if (!list.isEmpty()) break block5;
                }
                this.socketContext.sendMessage((SerializationStrategy)LyricsNotFoundEvent.Companion.serializer(), (Object)new LyricsNotFoundEvent(String.valueOf(this.guildId)));
                return;
            }
            this.socketContext.sendMessage((SerializationStrategy)LyricsFoundEvent.Companion.serializer(), (Object)new LyricsFoundEvent(String.valueOf(this.guildId), UtilKt.toLyrics(lyrics, this.plugin.pluginInfoModifiers)));
            List<AudioLyrics.Line> list = lyrics.getLines();
            Intrinsics.checkNotNull(list);
            long l = list.get(0).getTimestamp().toMillis();
            List list2 = this.plugin.pluginInfoModifiers;
            List<AudioLyrics.Line> list3 = lyrics.getLines();
            Intrinsics.checkNotNull(list3);
            track.addMarker(new TrackMarker(l, (TrackMarkerHandler)new LineHandler(this.socketContext, list2, this.guildId, track, list3)));
        }
    }
}

