/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.DateTimePeriodKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.internal.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001a\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\"\u0010\r\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010\r\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u001a\"\u0010\r\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010\r\u001a\u00020\u0013*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\u0014\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\u0015\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0015\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0016\u001a\u00020\u0005*\u00020\u0017\u001a\u001a\u0010\u0018\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010\u0019\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\u001a"}, d2={"DISTANT_FUTURE_SECONDS", "", "DISTANT_PAST_SECONDS", "isDistantFuture", "", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)Z", "isDistantPast", "daysUntil", "", "other", "timeZone", "Lkotlinx/datetime/TimeZone;", "minus", "value", "unit", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "Lkotlinx/datetime/DateTimeUnit;", "period", "Lkotlinx/datetime/DateTimePeriod;", "monthsUntil", "plus", "toInstant", "", "until", "yearsUntil", "kotlinx-datetime"})
public final class InstantKt {
    public static final long DISTANT_PAST_SECONDS = -3217862419201L;
    public static final long DISTANT_FUTURE_SECONDS = 3093527980800L;

    public static final boolean isDistantPast(@NotNull Instant $this$isDistantPast) {
        Intrinsics.checkNotNullParameter($this$isDistantPast, "<this>");
        return $this$isDistantPast.compareTo(Instant.Companion.getDISTANT_PAST()) <= 0;
    }

    public static final boolean isDistantFuture(@NotNull Instant $this$isDistantFuture) {
        Intrinsics.checkNotNullParameter($this$isDistantFuture, "<this>");
        return $this$isDistantFuture.compareTo(Instant.Companion.getDISTANT_FUTURE()) >= 0;
    }

    @NotNull
    public static final Instant toInstant(@NotNull String $this$toInstant) {
        Intrinsics.checkNotNullParameter($this$toInstant, "<this>");
        return Instant.Companion.parse($this$toInstant);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimePeriod period, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(period, "period");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (period.getTotalNanoseconds$kotlinx_datetime() != Long.MIN_VALUE) {
            DateTimePeriod $this$minus_u24lambda_u2d0 = period;
            boolean bl = false;
            DateTimePeriod negatedPeriod = DateTimePeriodKt.buildDateTimePeriod(-$this$minus_u24lambda_u2d0.getTotalMonths$kotlinx_datetime(), -$this$minus_u24lambda_u2d0.getDays(), -$this$minus_u24lambda_u2d0.getTotalNanoseconds$kotlinx_datetime());
            instant = InstantJvmKt.plus($this$minus, negatedPeriod, timeZone);
        } else {
            DateTimePeriod $this$minus_u24lambda_u2d1 = period;
            boolean bl = false;
            DateTimePeriod negatedPeriod = DateTimePeriodKt.buildDateTimePeriod(-$this$minus_u24lambda_u2d1.getTotalMonths$kotlinx_datetime(), -$this$minus_u24lambda_u2d1.getDays(), -($this$minus_u24lambda_u2d1.getTotalNanoseconds$kotlinx_datetime() + 1L));
            instant = InstantKt.plus(InstantJvmKt.plus($this$minus, negatedPeriod, timeZone), DateTimeUnit.Companion.getNANOSECOND());
        }
        return instant;
    }

    public static final long until(@NotNull Instant $this$until, @NotNull Instant other, @NotNull DateTimeUnit.TimeBased unit) {
        long l;
        Intrinsics.checkNotNullParameter($this$until, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        try {
            l = MathKt.multiplyAddAndDivide(other.getEpochSeconds() - $this$until.getEpochSeconds(), 1000000000L, other.getNanosecondsOfSecond() - $this$until.getNanosecondsOfSecond(), unit.getNanoseconds());
        }
        catch (ArithmeticException e) {
            l = $this$until.compareTo(other) < 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l;
    }

    public static final int daysUntil(@NotNull Instant $this$daysUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$daysUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$daysUntil, other, DateTimeUnit.Companion.getDAY(), timeZone));
    }

    public static final int monthsUntil(@NotNull Instant $this$monthsUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$monthsUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$monthsUntil, other, DateTimeUnit.Companion.getMONTH(), timeZone));
    }

    public static final int yearsUntil(@NotNull Instant $this$yearsUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$yearsUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$yearsUntil, other, DateTimeUnit.Companion.getYEAR(), timeZone));
    }

    @NotNull
    public static final DateTimePeriod minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.periodUntil(other, $this$minus, timeZone);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.plus($this$minus, -1, unit, timeZone);
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantJvmKt.plus($this$plus, 1L, unit);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantJvmKt.plus($this$minus, -1L, unit);
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, int value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantJvmKt.plus($this$plus, value, unit);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, int value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantKt.minus($this$minus, (long)value, unit);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, long value, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return value != Long.MIN_VALUE ? InstantJvmKt.plus($this$minus, -value, unit, timeZone) : InstantJvmKt.plus(InstantJvmKt.plus($this$minus, -(value + 1L), unit, timeZone), unit, timeZone);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, long value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return value != Long.MIN_VALUE ? InstantJvmKt.plus($this$minus, -value, unit) : InstantKt.plus(InstantJvmKt.plus($this$minus, -(value + 1L), unit), unit);
    }

    public static final long minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.until(other, $this$minus, unit, timeZone);
    }

    public static final long minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantKt.until(other, $this$minus, unit);
    }
}

