/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasearch.plugin;

import com.github.topi314.lavasearch.SearchManager;
import com.github.topi314.lavasearch.api.SearchPluginInfoModifier;
import com.github.topi314.lavasearch.plugin.UtilKt;
import com.github.topi314.lavasearch.protocol.SearchResult;
import com.github.topi314.lavasearch.result.AudioSearchResult;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.arbjerg.lavalink.api.AudioPluginInfoModifier;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/topi314/lavasearch/plugin/AudioSearchRestHandler;", "", "searchManager", "Lcom/github/topi314/lavasearch/SearchManager;", "playerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "pluginInfoModifiers", "", "Ldev/arbjerg/lavalink/api/AudioPluginInfoModifier;", "searchResultInfoModifiers", "Lcom/github/topi314/lavasearch/api/SearchPluginInfoModifier;", "(Lcom/github/topi314/lavasearch/SearchManager;Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Ljava/util/List;Ljava/util/List;)V", "loadSearch", "Lorg/springframework/http/ResponseEntity;", "Lcom/github/topi314/lavasearch/protocol/SearchResult;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "query", "", "types", "Companion", "lavasearch-plugin"})
@SourceDebugExtension(value={"SMAP\nAudioSearchRestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioSearchRestHandler.kt\ncom/github/topi314/lavasearch/plugin/AudioSearchRestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1603#2,9:43\n1855#2:52\n1856#2:54\n1612#2:55\n1#3:53\n*S KotlinDebug\n*F\n+ 1 AudioSearchRestHandler.kt\ncom/github/topi314/lavasearch/plugin/AudioSearchRestHandler\n*L\n35#1:43,9\n35#1:52\n35#1:54\n35#1:55\n35#1:53\n*E\n"})
public final class AudioSearchRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchManager searchManager;
    @NotNull
    private final AudioPlayerManager playerManager;
    @NotNull
    private final List<AudioPluginInfoModifier> pluginInfoModifiers;
    @NotNull
    private final List<SearchPluginInfoModifier> searchResultInfoModifiers;
    private static final Logger log = LoggerFactory.getLogger(AudioSearchRestHandler.class);

    public AudioSearchRestHandler(@NotNull SearchManager searchManager, @NotNull AudioPlayerManager playerManager, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers, @NotNull List<? extends SearchPluginInfoModifier> searchResultInfoModifiers) {
        Intrinsics.checkNotNullParameter(searchManager, "searchManager");
        Intrinsics.checkNotNullParameter(playerManager, "playerManager");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, "pluginInfoModifiers");
        Intrinsics.checkNotNullParameter(searchResultInfoModifiers, "searchResultInfoModifiers");
        this.searchManager = searchManager;
        this.playerManager = playerManager;
        this.pluginInfoModifiers = pluginInfoModifiers;
        this.searchResultInfoModifiers = searchResultInfoModifiers;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/v4/loadsearch"})
    @NotNull
    public final ResponseEntity<SearchResult> loadSearch(@NotNull HttpServletRequest request, @RequestParam @NotNull String query, @RequestParam(required=false) @Nullable String types) {
        ResponseEntity responseEntity;
        Set<AudioSearchResult.Type> set;
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(query, "query");
        log.debug("loadSearch called with query: {}, types: {}", (Object)query, (Object)types);
        Object object = types;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            set = SetsKt.emptySet();
        } else {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            object = types;
            Regex regex = new Regex(",\\s*");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$mapNotNull = false;
            void var7_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                AudioSearchResult.Type it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (AudioSearchResult.Type.fromName(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            set = CollectionsKt.toSet((List)destination$iv$iv);
        }
        Set<AudioSearchResult.Type> finalTypes = set;
        AudioSearchResult result = this.searchManager.loadSearch(query, finalTypes);
        if (result != null) {
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)UtilKt.toSearchResult(result, this.playerManager, this.pluginInfoModifiers, this.searchResultInfoModifiers));
            Intrinsics.checkNotNull(responseEntity2);
            responseEntity = responseEntity2;
        } else {
            ResponseEntity responseEntity3 = ResponseEntity.noContent().build();
            responseEntity = responseEntity3;
            Intrinsics.checkNotNullExpressionValue(responseEntity3, "build(...)");
        }
        return responseEntity;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/topi314/lavasearch/plugin/AudioSearchRestHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "lavasearch-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

