/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.flowerytts;

import com.github.topi314.lavasrc.flowerytts.FloweryTTSSourceManager;
import com.sedmelluq.discord.lavaplayer.container.adts.AdtsAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.flac.FlacAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.wav.WavAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BaseAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public class FloweryTTSAudioTrack
extends DelegatedAudioTrack {
    private static final Map<String, Class<? extends BaseAudioTrack>> AUDIO_FORMATS = Map.of("mp3", Mp3AudioTrack.class, "ogg_opus", OggAudioTrack.class, "ogg_vorbis", OggAudioTrack.class, "wav", WavAudioTrack.class, "flac", FlacAudioTrack.class, "aac", AdtsAudioTrack.class);
    public static final String API_BASE = "https://api.flowery.pw/v1/tts";
    private final FloweryTTSSourceManager sourceManager;

    public FloweryTTSAudioTrack(AudioTrackInfo trackInfo, FloweryTTSSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    public void process(LocalAudioTrackExecutor executor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            List queryParams = new URIBuilder(this.trackInfo.identifier).getQueryParams();
            URIBuilder apiUri = new URIBuilder(API_BASE);
            String format = "mp3";
            apiUri.addParameter("text", this.trackInfo.title);
            for (Map.Entry<String, String> entry : this.sourceManager.getDefaultConfig().entrySet()) {
                String value = queryParams.stream().filter(p -> ((String)entry.getKey()).equals(p.getName())).map(NameValuePair::getValue).findFirst().orElse(entry.getValue());
                apiUri.addParameter(entry.getKey(), value);
                if (!"audio_format".equals(entry.getKey())) continue;
                format = value;
            }
            System.out.println(apiUri.build());
            try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, apiUri.build(), null);){
                Class<? extends BaseAudioTrack> audioTrackClass = AUDIO_FORMATS.get(format);
                if (audioTrackClass == null) {
                    throw new IllegalArgumentException("Invalid audio format");
                }
                Class streamClass = "aac".equals(format) ? InputStream.class : SeekableInputStream.class;
                this.processDelegate((InternalAudioTrack)audioTrackClass.getConstructor(AudioTrackInfo.class, streamClass).newInstance(this.trackInfo, stream), executor);
            }
        }
    }

    protected AudioTrack makeShallowClone() {
        return new FloweryTTSAudioTrack(this.trackInfo, this.sourceManager);
    }

    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

