/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.applemusic;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.github.topi314.lavasearch.AudioSearchManager;
import com.github.topi314.lavasearch.result.AudioSearchResult;
import com.github.topi314.lavasearch.result.AudioText;
import com.github.topi314.lavasearch.result.BasicAudioSearchResult;
import com.github.topi314.lavasearch.result.BasicAudioText;
import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.ExtendedAudioSourceManager;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.applemusic.AppleMusicAudioPlaylist;
import com.github.topi314.lavasrc.applemusic.AppleMusicAudioTrack;
import com.github.topi314.lavasrc.applemusic.SearchTypeUtil;
import com.github.topi314.lavasrc.mirror.DefaultMirroringAudioTrackResolver;
import com.github.topi314.lavasrc.mirror.MirroringAudioSourceManager;
import com.github.topi314.lavasrc.mirror.MirroringAudioTrackResolver;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppleMusicSourceManager
extends MirroringAudioSourceManager
implements AudioSearchManager {
    public static final Pattern URL_PATTERN = Pattern.compile("(https?://)?(www\\.)?music\\.apple\\.com/((?<countrycode>[a-zA-Z]{2})/)?(?<type>album|playlist|artist|song)(/[a-zA-Z\\p{L}\\d\\-]+)?/(?<identifier>[a-zA-Z\\d\\-.]+)(\\?i=(?<identifier2>\\d+))?");
    public static final String SEARCH_PREFIX = "amsearch:";
    public static final String PREVIEW_PREFIX = "amprev:";
    public static final long PREVIEW_LENGTH = 30000L;
    public static final int MAX_PAGE_ITEMS = 300;
    public static final String API_BASE = "https://api.music.apple.com/v1/";
    public static final Set<AudioSearchResult.Type> SEARCH_TYPES = Set.of(AudioSearchResult.Type.TRACK, AudioSearchResult.Type.ALBUM, AudioSearchResult.Type.PLAYLIST, AudioSearchResult.Type.ARTIST, AudioSearchResult.Type.TEXT);
    public static final Set<AudioSearchResult.Type> TOP_RESULT_SEARCH_TYPES = Set.of(AudioSearchResult.Type.TRACK, AudioSearchResult.Type.ALBUM, AudioSearchResult.Type.PLAYLIST, AudioSearchResult.Type.ARTIST);
    private final String countryCode;
    private int playlistPageLimit;
    private int albumPageLimit;
    private final String token;
    private String origin;
    private Instant tokenExpire;

    public AppleMusicSourceManager(String[] providers, String mediaAPIToken, String countryCode, AudioPlayerManager audioPlayerManager) {
        this(mediaAPIToken, countryCode, (Void unused) -> audioPlayerManager, (MirroringAudioTrackResolver)new DefaultMirroringAudioTrackResolver(providers));
    }

    public AppleMusicSourceManager(String[] providers, String mediaAPIToken, String countryCode, Function<Void, AudioPlayerManager> audioPlayerManager) {
        this(mediaAPIToken, countryCode, audioPlayerManager, (MirroringAudioTrackResolver)new DefaultMirroringAudioTrackResolver(providers));
    }

    public AppleMusicSourceManager(String mediaAPIToken, String countryCode, AudioPlayerManager audioPlayerManager, MirroringAudioTrackResolver mirroringAudioTrackResolver) {
        this(mediaAPIToken, countryCode, (Void unused) -> audioPlayerManager, mirroringAudioTrackResolver);
    }

    public AppleMusicSourceManager(String mediaAPIToken, String countryCode, Function<Void, AudioPlayerManager> audioPlayerManager, MirroringAudioTrackResolver mirroringAudioTrackResolver) {
        super(audioPlayerManager, mirroringAudioTrackResolver);
        if (mediaAPIToken == null || mediaAPIToken.isEmpty()) {
            throw new RuntimeException("Apple Music API token is empty or null");
        }
        this.token = mediaAPIToken;
        try {
            this.parseTokenData();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse Apple Music API token", e);
        }
        this.countryCode = countryCode == null || countryCode.isEmpty() ? "us" : countryCode;
    }

    public void setPlaylistPageLimit(int playlistPageLimit) {
        this.playlistPageLimit = playlistPageLimit;
    }

    public void setAlbumPageLimit(int albumPageLimit) {
        this.albumPageLimit = albumPageLimit;
    }

    @Override
    @NotNull
    public String getSourceName() {
        return "applemusic";
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        ExtendedAudioSourceManager.ExtendedAudioTrackInfo extendedAudioTrackInfo = super.decodeTrack(input);
        return new AppleMusicAudioTrack(trackInfo, extendedAudioTrackInfo.albumName, extendedAudioTrackInfo.albumUrl, extendedAudioTrackInfo.artistUrl, extendedAudioTrackInfo.artistArtworkUrl, extendedAudioTrackInfo.previewUrl, extendedAudioTrackInfo.isPreview, this);
    }

    @Override
    @Nullable
    public AudioSearchResult loadSearch(@NotNull String query, @NotNull Set<AudioSearchResult.Type> types) {
        try {
            if (query.startsWith(SEARCH_PREFIX)) {
                return this.getSearchSuggestions(query.substring(SEARCH_PREFIX.length()), types);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String identifier = reference.identifier;
        boolean preview = reference.identifier.startsWith(PREVIEW_PREFIX);
        return this.loadItem(preview ? identifier.substring(PREVIEW_PREFIX.length()) : identifier, preview);
    }

    public AudioItem loadItem(String identifier, boolean preview) {
        try {
            if (identifier.startsWith(SEARCH_PREFIX)) {
                return this.getSearch(identifier.substring(SEARCH_PREFIX.length()).trim(), preview);
            }
            Matcher matcher = URL_PATTERN.matcher(identifier);
            if (!matcher.find()) {
                return null;
            }
            String countryCode = matcher.group("countrycode");
            String id = matcher.group("identifier");
            switch (matcher.group("type")) {
                case "song": {
                    return this.getSong(id, countryCode, preview);
                }
                case "album": {
                    String id2 = matcher.group("identifier2");
                    if (id2 == null || id2.isEmpty()) {
                        return this.getAlbum(id, countryCode, preview);
                    }
                    return this.getSong(id2, countryCode, preview);
                }
                case "playlist": {
                    return this.getPlaylist(id, countryCode, preview);
                }
                case "artist": {
                    return this.getArtist(id, countryCode, preview);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void parseTokenData() throws IOException {
        JsonBrowser json2 = JsonBrowser.parse((String)new String(Base64.getDecoder().decode(this.token.split("\\.")[1])));
        this.tokenExpire = Instant.ofEpochSecond(json2.get("exp").asLong(0L));
        this.origin = json2.get("root_https_origin").index(0).text();
    }

    public String getToken() throws IOException {
        if (this.tokenExpire.isBefore(Instant.now())) {
            throw new FriendlyException("Apple Music API token is expired", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return this.token;
    }

    public AudioSearchResult getSearchSuggestions(String query, Set<AudioSearchResult.Type> types) throws IOException, URISyntaxException {
        if (types.isEmpty()) {
            types = SEARCH_TYPES;
        }
        URIBuilder urlBuilder = new URIBuilder("https://api.music.apple.com/v1/catalog/" + this.countryCode + "/search/suggestions");
        urlBuilder.setParameter("term", query);
        urlBuilder.setParameter("extend", "artistUrl");
        HashSet<String> kinds = new HashSet<String>();
        if (types.contains((Object)AudioSearchResult.Type.TEXT)) {
            kinds.add("terms");
        }
        for (AudioSearchResult.Type type : types) {
            if (!TOP_RESULT_SEARCH_TYPES.contains((Object)type)) continue;
            kinds.add("topResults");
            break;
        }
        urlBuilder.setParameter("kinds", String.join((CharSequence)",", kinds));
        String typesString = SearchTypeUtil.buildAppleMusicTypes(types);
        if (!typesString.isEmpty()) {
            urlBuilder.setParameter("types", typesString);
        }
        JsonBrowser json2 = this.getJson(urlBuilder.build().toString());
        JsonBrowser allSuggestions = json2.get("results").get("suggestions");
        ArrayList<AudioText> terms = new ArrayList<AudioText>();
        ArrayList<AudioPlaylist> albums = new ArrayList<AudioPlaylist>();
        ArrayList<AudioPlaylist> artists = new ArrayList<AudioPlaylist>();
        ArrayList<AudioPlaylist> playLists = new ArrayList<AudioPlaylist>();
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser term : allSuggestions.values()) {
            String kind = term.get("kind").text();
            if (kind.equals("terms")) {
                terms.add(new BasicAudioText(term.get("searchTerm").text()));
                continue;
            }
            JsonBrowser content = term.get("content");
            String type = content.get("type").text();
            String id = content.get("id").text();
            JsonBrowser attributes = content.get("attributes");
            String url = attributes.get("url").text();
            switch (type) {
                case "albums": {
                    String name = attributes.get("name").text();
                    String artist = attributes.get("artistName").text();
                    String artworkUrl = this.parseArtworkUrl(attributes.get("artwork"));
                    int trackCount = (int)attributes.get("trackCount").asLong(0L);
                    AppleMusicAudioPlaylist album = new AppleMusicAudioPlaylist(name, Collections.emptyList(), ExtendedAudioPlaylist.Type.ALBUM, url, artworkUrl, artist, trackCount);
                    albums.add((AudioPlaylist)album);
                    break;
                }
                case "artists": {
                    String name = attributes.get("name").text();
                    String artworkUrl = this.parseArtworkUrl(attributes.get("artwork"));
                    AppleMusicAudioPlaylist artist = new AppleMusicAudioPlaylist(name + "'s Top Tracks", Collections.emptyList(), ExtendedAudioPlaylist.Type.ARTIST, url, artworkUrl, name, null);
                    artists.add((AudioPlaylist)artist);
                    break;
                }
                case "playlists": {
                    String name = attributes.get("name").text();
                    String artworkUrl = this.parseArtworkUrl(attributes.get("artwork"));
                    int trackCount = (int)attributes.get("trackCount").asLong(0L);
                    String author = attributes.get("data").index(0).get("attributes").get("curatorName").text();
                    AppleMusicAudioPlaylist playlist = new AppleMusicAudioPlaylist(name, Collections.emptyList(), ExtendedAudioPlaylist.Type.PLAYLIST, url, artworkUrl, author, trackCount);
                    playLists.add((AudioPlaylist)playlist);
                    break;
                }
                case "songs": {
                    String name = attributes.get("name").text();
                    String artworkUrl = this.parseArtworkUrl(attributes.get("artwork"));
                    String isrc = attributes.get("isrc").text();
                    String author = attributes.get("artistName").text();
                    long length = attributes.get("durationInMillis").asLong(0L);
                    String albumName = attributes.get("albumName").text();
                    String artistUrl = attributes.get("artistUrl").text();
                    String albumUrl = url.substring(0, url.indexOf(63));
                    String previewUrl = attributes.get("previews").index(0).get("url").text();
                    AudioTrackInfo info = new AudioTrackInfo(name, author, length, id, false, url, artworkUrl, isrc);
                    AppleMusicAudioTrack track = new AppleMusicAudioTrack(info, albumName, albumUrl, artistUrl, null, previewUrl, false, this);
                    tracks.add((AudioTrack)track);
                    break;
                }
            }
        }
        return new BasicAudioSearchResult(tracks, albums, artists, playLists, terms);
    }

    public JsonBrowser getJson(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.addHeader("Authorization", "Bearer " + this.getToken());
        if (this.origin != null && !this.origin.isEmpty()) {
            request.addHeader("Origin", "https://" + this.origin);
        }
        return LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
    }

    public Map<String, String> getArtistCover(List<String> ids) throws IOException {
        if (ids.isEmpty()) {
            return Map.of();
        }
        JsonBrowser json2 = this.getJson("https://api.music.apple.com/v1/catalog/" + this.countryCode + "/artists?ids=" + String.join((CharSequence)",", ids));
        HashMap<String, String> output = new HashMap<String, String>(ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            JsonBrowser artist = json2.get("data").index(i);
            JsonBrowser artwork = artist.get("attributes").get("artwork");
            output.put(artist.get("id").text(), this.parseArtworkUrl(artwork));
        }
        return output;
    }

    public AudioItem getSearch(String query, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.apple.com/v1/catalog/" + this.countryCode + "/search?term=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&limit=25&extend=artistUrl");
        if (json2 == null || json2.get("results").get("songs").get("data").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Apple Music Search: " + query, this.parseTracks(json2.get("results").get("songs"), preview), null, true);
    }

    public AudioItem getAlbum(String id, String countryCode, boolean preview) throws IOException {
        JsonBrowser page;
        JsonBrowser json2 = this.getJson("https://api.music.apple.com/v1/catalog/" + countryCode + "/albums/" + id + "?extend=artistUrl");
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser tracksRaw = JsonBrowser.newList();
        int offset = 0;
        int pages = 0;
        do {
            page = this.getJson("https://api.music.apple.com/v1/catalog/" + countryCode + "/albums/" + id + "/tracks?limit=300&offset=" + offset);
            offset += 300;
            page.get("data").values().forEach(arg_0 -> ((JsonBrowser)tracksRaw).add(arg_0));
        } while (page.get("next").text() != null && ++pages < this.albumPageLimit);
        List<AudioTrack> tracks = this.parseTrackList(tracksRaw, preview);
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String artworkUrl = this.parseArtworkUrl(json2.get("data").index(0).get("attributes").get("artwork"));
        String author = json2.get("data").index(0).get("attributes").get("artistName").text();
        return new AppleMusicAudioPlaylist(json2.get("data").index(0).get("attributes").get("name").text(), tracks, ExtendedAudioPlaylist.Type.ALBUM, json2.get("data").index(0).get("attributes").get("url").text(), artworkUrl, author, (int)json2.get("data").index(0).get("attributes").get("trackCount").asLong(0L));
    }

    public AudioItem getPlaylist(String id, String countryCode, boolean preview) throws IOException {
        JsonBrowser page;
        JsonBrowser json2 = this.getJson("https://api.music.apple.com/v1/catalog/" + countryCode + "/playlists/" + id);
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser tracksRaw = JsonBrowser.newList();
        int offset = 0;
        int pages = 0;
        do {
            page = this.getJson("https://api.music.apple.com/v1/catalog/" + countryCode + "/playlists/" + id + "/tracks?limit=300&offset=" + offset + "&extend=artistUrl");
            offset += 300;
            page.get("data").values().forEach(arg_0 -> ((JsonBrowser)tracksRaw).add(arg_0));
        } while (page.get("next").text() != null && ++pages < this.playlistPageLimit);
        List<AudioTrack> tracks = this.parseTrackList(tracksRaw, preview);
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String artworkUrl = this.parseArtworkUrl(json2.get("data").index(0).get("attributes").get("artwork"));
        String author = json2.get("data").index(0).get("attributes").get("curatorName").text();
        return new AppleMusicAudioPlaylist(json2.get("data").index(0).get("attributes").get("name").text(), tracks, ExtendedAudioPlaylist.Type.PLAYLIST, json2.get("data").index(0).get("attributes").get("url").text(), artworkUrl, author, (int)json2.get("data").index(0).get("attributes").get("trackCount").asLong(0L));
    }

    public AudioItem getArtist(String id, String countryCode, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.apple.com/v1/catalog/" + countryCode + "/artists/" + id + "/view/top-songs");
        if (json2 == null || json2.get("data").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser jsonArtist = this.getJson("https://api.music.apple.com/v1/catalog/" + countryCode + "/artists/" + id);
        String author = jsonArtist.get("data").index(0).get("attributes").get("name").text();
        String artworkUrl = this.parseArtworkUrl(jsonArtist.get("data").index(0).get("attributes").get("artwork"));
        HashMap<String, String> artistArtwork = new HashMap<String, String>();
        if (artworkUrl != null) {
            artistArtwork.put(jsonArtist.get("data").index(0).get("id").text(), artworkUrl);
        }
        List<AudioTrack> tracks = this.parseTracks(json2, preview, artistArtwork);
        return new AppleMusicAudioPlaylist(author + "'s Top Tracks", tracks, ExtendedAudioPlaylist.Type.ARTIST, json2.get("data").index(0).get("attributes").get("url").text(), artworkUrl, author, tracks.size());
    }

    public AudioItem getSong(String id, String countryCode, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.apple.com/v1/catalog/" + countryCode + "/songs/" + id + "?extend=artistUrl");
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        String artistId = this.parseArtistId(json2);
        String artistArtwork = null;
        if (artistId != null) {
            artistArtwork = this.getArtistCover(List.of(artistId)).values().iterator().next();
        }
        return this.parseTrack(json2.get("data").index(0), preview, artistArtwork);
    }

    private List<AudioTrack> parseTracks(JsonBrowser json2, boolean preview, Map<String, String> artistArtwork) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser value : json2.get("data").values()) {
            String artistId = this.parseArtistId(value);
            String artworkUrl = null;
            if (artistId != null) {
                artworkUrl = artistArtwork.get(artistId);
            }
            tracks.add(this.parseTrack(value, preview, artworkUrl));
        }
        return tracks;
    }

    private List<AudioTrack> parseTrackList(JsonBrowser json2, boolean preview) throws IOException {
        JsonBrowser jsonData = JsonBrowser.newMap();
        jsonData.put("data", (Object)json2);
        return this.parseTracks(jsonData, preview);
    }

    private List<AudioTrack> parseTracks(JsonBrowser json2, boolean preview) throws IOException {
        List<String> ids = json2.get("data").values().stream().map(this::parseArtistId).filter(Predicate.not(Objects::isNull)).collect(Collectors.toList());
        return this.parseTracks(json2, preview, this.getArtistCover(ids));
    }

    private AudioTrack parseTrack(JsonBrowser json2, boolean preview, String artistArtwork) {
        JsonBrowser attributes = json2.get("attributes");
        String trackUrl = attributes.get("url").text();
        String artistUrl = json2.get("artistUrl").text();
        if (artistUrl != null && (artistUrl.isEmpty() || artistUrl.startsWith("https://music.apple.com/WebObjects/MZStore.woa/wa/viewCollaboration"))) {
            artistUrl = null;
        }
        return new AppleMusicAudioTrack(new AudioTrackInfo(attributes.get("name").text(), attributes.get("artistName").text(), preview ? 30000L : attributes.get("durationInMillis").asLong(0L), json2.get("id").text(), false, trackUrl, this.parseArtworkUrl(attributes.get("artwork")), attributes.get("isrc").text()), attributes.get("albumName").text(), trackUrl.substring(0, trackUrl.indexOf(63)), artistUrl, artistArtwork, attributes.get("previews").index(0).get("hlsUrl").text(), preview, this);
    }

    private String parseArtworkUrl(JsonBrowser json2) {
        String text = json2.get("url").text();
        if (text == null) {
            return null;
        }
        return text.replace("{w}", json2.get("width").text()).replace("{h}", json2.get("height").text());
    }

    @Nullable
    private String parseArtistId(JsonBrowser json2) {
        String url = json2.get("data").index(0).get("attributes").get("artistUrl").text();
        if (url == null || url.isEmpty()) {
            return null;
        }
        if (url.startsWith("https://music.apple.com/WebObjects/MZStore.woa/wa/viewCollaboration")) {
            return null;
        }
        return url.substring(url.lastIndexOf(47) + 1);
    }

    public static AppleMusicSourceManager fromMusicKitKey(String musicKitKey, String keyId, String teamId, String countryCode, AudioPlayerManager audioPlayerManager, MirroringAudioTrackResolver mirroringAudioTrackResolver) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String base64 = musicKitKey.replaceAll("-----BEGIN PRIVATE KEY-----\n", "").replaceAll("-----END PRIVATE KEY-----", "").replaceAll("\\s", "");
        byte[] keyBytes = Base64.getDecoder().decode(base64);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        ECKey key = (ECKey)((Object)keyFactory.generatePrivate(spec));
        String jwt = JWT.create().withIssuer(teamId).withIssuedAt(Instant.now()).withExpiresAt(Instant.now().plus(Duration.ofSeconds(15777000L))).withKeyId(keyId).sign(Algorithm.ECDSA256((ECKey)key));
        return new AppleMusicSourceManager(jwt, countryCode, audioPlayerManager, mirroringAudioTrackResolver);
    }
}

