/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.deezer;

import com.github.topi314.lavasearch.AudioSearchManager;
import com.github.topi314.lavasearch.result.AudioSearchResult;
import com.github.topi314.lavasearch.result.AudioText;
import com.github.topi314.lavasearch.result.BasicAudioSearchResult;
import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.ExtendedAudioSourceManager;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.deezer.DeezerAudioPlaylist;
import com.github.topi314.lavasrc.deezer.DeezerAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeezerAudioSourceManager
extends ExtendedAudioSourceManager
implements HttpConfigurable,
AudioSearchManager {
    public static final Pattern URL_PATTERN = Pattern.compile("(https?://)?(www\\.)?deezer\\.com/(?<countrycode>[a-zA-Z]{2}/)?(?<type>track|album|playlist|artist)/(?<identifier>[0-9]+)");
    public static final String SEARCH_PREFIX = "dzsearch:";
    public static final String ISRC_PREFIX = "dzisrc:";
    public static final String PREVIEW_PREFIX = "dzprev:";
    public static final long PREVIEW_LENGTH = 30000L;
    public static final String SHARE_URL = "https://deezer.page.link/";
    public static final String PUBLIC_API_BASE = "https://api.deezer.com/2.0";
    public static final String PRIVATE_API_BASE = "https://www.deezer.com/ajax/gw-light.php";
    public static final String MEDIA_BASE = "https://media.deezer.com/v1";
    public static final Set<AudioSearchResult.Type> SEARCH_TYPES = Set.of(AudioSearchResult.Type.TRACK, AudioSearchResult.Type.ALBUM, AudioSearchResult.Type.PLAYLIST, AudioSearchResult.Type.ARTIST);
    private static final Logger log = LoggerFactory.getLogger(DeezerAudioSourceManager.class);
    private final String masterDecryptionKey;
    private final HttpInterfaceManager httpInterfaceManager;

    public DeezerAudioSourceManager(String masterDecryptionKey) {
        if (masterDecryptionKey == null || masterDecryptionKey.isEmpty()) {
            throw new IllegalArgumentException("Deezer master key must be set");
        }
        this.masterDecryptionKey = masterDecryptionKey;
        this.httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    }

    @Override
    @NotNull
    public String getSourceName() {
        return "deezer";
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        ExtendedAudioSourceManager.ExtendedAudioTrackInfo extendedAudioTrackInfo = super.decodeTrack(input);
        return new DeezerAudioTrack(trackInfo, extendedAudioTrackInfo.albumName, extendedAudioTrackInfo.albumUrl, extendedAudioTrackInfo.artistUrl, extendedAudioTrackInfo.artistArtworkUrl, extendedAudioTrackInfo.previewUrl, extendedAudioTrackInfo.isPreview, this);
    }

    @Override
    @Nullable
    public AudioSearchResult loadSearch(@NotNull String query, @NotNull Set<AudioSearchResult.Type> types) {
        try {
            if (query.startsWith(SEARCH_PREFIX)) {
                return this.getAutocomplete(query.substring(SEARCH_PREFIX.length()), types);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String identifier = reference.identifier;
        boolean preview = reference.identifier.startsWith(PREVIEW_PREFIX);
        return this.loadItem(preview ? identifier.substring(PREVIEW_PREFIX.length()) : identifier, preview);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioItem loadItem(String identifier, boolean preview) {
        try {
            if (identifier.startsWith(SEARCH_PREFIX)) {
                return this.getSearch(identifier.substring(SEARCH_PREFIX.length()), preview);
            }
            if (identifier.startsWith(ISRC_PREFIX)) {
                return this.getTrackByISRC(identifier.substring(ISRC_PREFIX.length()), preview);
            }
            if (identifier.startsWith(SHARE_URL)) {
                HttpGet request = new HttpGet(identifier);
                request.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
                try (CloseableHttpResponse response = this.httpInterfaceManager.getInterface().execute((HttpUriRequest)request);){
                    String location;
                    if (response.getStatusLine().getStatusCode() == 302 && (location = response.getFirstHeader("Location").getValue()).startsWith("https://www.deezer.com/")) {
                        AudioItem audioItem = this.loadItem(location, preview);
                        return audioItem;
                    }
                    AudioItem audioItem = null;
                    return audioItem;
                }
            }
            Matcher matcher = URL_PATTERN.matcher(identifier);
            if (!matcher.find()) {
                return null;
            }
            String id = matcher.group("identifier");
            switch (matcher.group("type")) {
                case "album": {
                    return this.getAlbum(id, preview);
                }
                case "track": {
                    return this.getTrack(id, preview);
                }
                case "playlist": {
                    return this.getPlaylist(id, preview);
                }
                case "artist": {
                    return this.getArtist(id, preview);
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonBrowser getJson(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.setHeader("Accept", "application/json");
        return LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
    }

    private List<AudioTrack> parseTracks(JsonBrowser json2, boolean preview) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser track : json2.get("data").values()) {
            if (!track.get("type").text().equals("track")) continue;
            if (!((Boolean)track.get("readable").as(Boolean.class)).booleanValue()) {
                log.warn("Skipping track {} by {} because it is not readable. Available countries: {}", new Object[]{track.get("title").text(), track.get("artist").get("name").text(), track.get("available_countries").text()});
                continue;
            }
            tracks.add(this.parseTrack(track, preview));
        }
        return tracks;
    }

    private AudioTrack parseTrack(JsonBrowser json2, boolean preview) {
        if (!((Boolean)json2.get("readable").as(Boolean.class)).booleanValue()) {
            throw new FriendlyException("This track is not readable. Available countries: " + json2.get("available_countries").text(), FriendlyException.Severity.COMMON, null);
        }
        String id = json2.get("id").text();
        return new DeezerAudioTrack(new AudioTrackInfo(json2.get("title").text(), json2.get("artist").get("name").text(), preview ? 30000L : json2.get("duration").asLong(0L) * 1000L, id, false, "https://deezer.com/track/" + id, json2.get("album").get("cover_xl").text(), json2.get("isrc").text()), json2.get("album").get("title").text(), "https://www.deezer.com/album/" + json2.get("album").get("id").text(), "https://www.deezer.com/artist/" + json2.get("artist").get("id").text(), json2.get("artist").get("picture_xl").text(), json2.get("preview").text(), preview, this);
    }

    private AudioSearchResult getAutocomplete(String query, Set<AudioSearchResult.Type> types) throws IOException {
        JsonBrowser json2;
        if (types.contains((Object)AudioSearchResult.Type.TEXT)) {
            throw new IllegalArgumentException("text is not a valid search type for Deezer");
        }
        if (types.isEmpty()) {
            types = SEARCH_TYPES;
        }
        if ((json2 = this.getJson("https://api.deezer.com/2.0/search/autocomplete?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8))) == null) {
            return AudioSearchResult.EMPTY;
        }
        ArrayList<AudioPlaylist> albums = new ArrayList<AudioPlaylist>();
        if (types.contains((Object)AudioSearchResult.Type.ALBUM)) {
            for (Object album : json2.get("albums").get("data").values()) {
                albums.add((AudioPlaylist)new DeezerAudioPlaylist(album.get("title").text(), Collections.emptyList(), ExtendedAudioPlaylist.Type.ALBUM, album.get("link").text(), album.get("cover_xl").text(), album.get("artist").get("name").text(), (int)album.get("nb_tracks").asLong(0L)));
            }
        }
        ArrayList<AudioPlaylist> artists = new ArrayList<AudioPlaylist>();
        if (types.contains((Object)AudioSearchResult.Type.ARTIST)) {
            for (Object artist : json2.get("artists").get("data").values()) {
                artists.add((AudioPlaylist)new DeezerAudioPlaylist(artist.get("name").text() + "'s Top Tracks", Collections.emptyList(), ExtendedAudioPlaylist.Type.ARTIST, artist.get("link").text(), artist.get("picture_xl").text(), artist.get("name").text(), null));
            }
        }
        ArrayList<AudioPlaylist> playlists = new ArrayList<AudioPlaylist>();
        if (types.contains((Object)AudioSearchResult.Type.PLAYLIST)) {
            for (JsonBrowser playlist : json2.get("playlists").get("data").values()) {
                playlists.add((AudioPlaylist)new DeezerAudioPlaylist(playlist.get("title").text(), Collections.emptyList(), ExtendedAudioPlaylist.Type.PLAYLIST, playlist.get("link").text(), playlist.get("picture_xl").text(), playlist.get("creator").get("name").text(), (int)playlist.get("nb_tracks").asLong(0L)));
            }
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("tracks"), false);
        return new BasicAudioSearchResult(tracks, albums, artists, playlists, new ArrayList<AudioText>());
    }

    private AudioItem getTrackByISRC(String isrc, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/track/isrc:" + URLEncoder.encode(isrc, StandardCharsets.UTF_8));
        if (json2 == null || json2.get("id").isNull()) {
            return AudioReference.NO_TRACK;
        }
        return this.parseTrack(json2, preview);
    }

    private AudioItem getSearch(String query, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/search?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8));
        if (json2 == null || json2.get("data").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Deezer Search: " + query, this.parseTracks(json2, preview), null, true);
    }

    private AudioItem getAlbum(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/album/" + id);
        if (json2 == null || json2.get("tracks").get("data").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String artworkUrl = json2.get("cover_xl").text();
        String author = ((JsonBrowser)json2.get("contributors").values().get(0)).get("name").text();
        for (JsonBrowser track : json2.get("tracks").get("data").values()) {
            track.get("artist").put("picture_xl", (Object)json2.get("artist").get("picture_xl"));
        }
        return new DeezerAudioPlaylist(json2.get("title").text(), this.parseTracks(json2.get("tracks"), preview), ExtendedAudioPlaylist.Type.ALBUM, json2.get("link").text(), artworkUrl, author, (int)json2.get("nb_tracks").asLong(0L));
    }

    private AudioItem getTrack(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/track/" + id);
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        return this.parseTrack(json2, preview);
    }

    private AudioItem getPlaylist(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/playlist/" + id);
        if (json2 == null || json2.get("tracks").get("data").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String artworkUrl = json2.get("picture_xl").text();
        String author = json2.get("creator").get("name").text();
        JsonBrowser tracks = this.getJson("https://api.deezer.com/2.0/playlist/" + id + "/tracks");
        return new DeezerAudioPlaylist(json2.get("title").text(), this.parseTracks(tracks, preview), ExtendedAudioPlaylist.Type.PLAYLIST, json2.get("link").text(), artworkUrl, author, (int)json2.get("nb_tracks").asLong(0L));
    }

    private AudioItem getArtist(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/artist/" + id);
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser tracksJson = this.getJson("https://api.deezer.com/2.0/artist/" + id + "/top?limit=50");
        if (tracksJson == null || tracksJson.get("data").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        for (JsonBrowser track : tracksJson.get("data").values()) {
            track.get("artist").put("picture_xl", (Object)json2.get("picture_xl"));
        }
        String artworkUrl = json2.get("picture_xl").text();
        String author = json2.get("name").text();
        List<AudioTrack> deezerTracks = this.parseTracks(tracksJson, preview);
        return new DeezerAudioPlaylist(author + "'s Top Tracks", deezerTracks, ExtendedAudioPlaylist.Type.ARTIST, json2.get("link").text(), artworkUrl, author, deezerTracks.size());
    }

    @Override
    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            log.error("Failed to close HTTP interface manager", (Throwable)e);
        }
    }

    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    public String getMasterDecryptionKey() {
        return this.masterDecryptionKey;
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }
}

