/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.spotify;

import com.github.topi314.lavasearch.AudioSearchManager;
import com.github.topi314.lavasearch.result.AudioSearchResult;
import com.github.topi314.lavasearch.result.AudioText;
import com.github.topi314.lavasearch.result.BasicAudioSearchResult;
import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.ExtendedAudioSourceManager;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.mirror.DefaultMirroringAudioTrackResolver;
import com.github.topi314.lavasrc.mirror.MirroringAudioSourceManager;
import com.github.topi314.lavasrc.mirror.MirroringAudioTrackResolver;
import com.github.topi314.lavasrc.spotify.SpotifyAudioPlaylist;
import com.github.topi314.lavasrc.spotify.SpotifyAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotifySourceManager
extends MirroringAudioSourceManager
implements HttpConfigurable,
AudioSearchManager {
    public static final Pattern URL_PATTERN = Pattern.compile("(https?://)(www\\.)?open\\.spotify\\.com/((?<region>[a-zA-Z-]+)/)?(user/(?<user>[a-zA-Z0-9-_]+)/)?(?<type>track|album|playlist|artist)/(?<identifier>[a-zA-Z0-9-_]+)");
    public static final String SEARCH_PREFIX = "spsearch:";
    public static final String RECOMMENDATIONS_PREFIX = "sprec:";
    public static final String PREVIEW_PREFIX = "spprev:";
    public static final long PREVIEW_LENGTH = 30000L;
    public static final String SHARE_URL = "https://spotify.link/";
    public static final int PLAYLIST_MAX_PAGE_ITEMS = 100;
    public static final int ALBUM_MAX_PAGE_ITEMS = 50;
    public static final String API_BASE = "https://api.spotify.com/v1/";
    public static final Set<AudioSearchResult.Type> SEARCH_TYPES = Set.of(AudioSearchResult.Type.ALBUM, AudioSearchResult.Type.ARTIST, AudioSearchResult.Type.PLAYLIST, AudioSearchResult.Type.TRACK);
    private static final Logger log = LoggerFactory.getLogger(SpotifySourceManager.class);
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private final String clientId;
    private final String clientSecret;
    private final String countryCode;
    private int playlistPageLimit = 6;
    private int albumPageLimit = 6;
    private String token;
    private Instant tokenExpire;

    public SpotifySourceManager(String[] providers, String clientId, String clientSecret, String countryCode, AudioPlayerManager audioPlayerManager) {
        this(clientId, clientSecret, countryCode, (Void unused) -> audioPlayerManager, (MirroringAudioTrackResolver)new DefaultMirroringAudioTrackResolver(providers));
    }

    public SpotifySourceManager(String[] providers, String clientId, String clientSecret, String countryCode, Function<Void, AudioPlayerManager> audioPlayerManager) {
        this(clientId, clientSecret, countryCode, audioPlayerManager, (MirroringAudioTrackResolver)new DefaultMirroringAudioTrackResolver(providers));
    }

    public SpotifySourceManager(String clientId, String clientSecret, String countryCode, AudioPlayerManager audioPlayerManager, MirroringAudioTrackResolver mirroringAudioTrackResolver) {
        this(clientId, clientSecret, countryCode, (Void unused) -> audioPlayerManager, mirroringAudioTrackResolver);
    }

    public SpotifySourceManager(String clientId, String clientSecret, String countryCode, Function<Void, AudioPlayerManager> audioPlayerManager, MirroringAudioTrackResolver mirroringAudioTrackResolver) {
        super(audioPlayerManager, mirroringAudioTrackResolver);
        if (clientId == null || clientId.isEmpty()) {
            throw new IllegalArgumentException("Spotify client id must be set");
        }
        this.clientId = clientId;
        if (clientSecret == null || clientSecret.isEmpty()) {
            throw new IllegalArgumentException("Spotify secret must be set");
        }
        this.clientSecret = clientSecret;
        if (countryCode == null || countryCode.isEmpty()) {
            countryCode = "US";
        }
        this.countryCode = countryCode;
    }

    public void setPlaylistPageLimit(int playlistPageLimit) {
        this.playlistPageLimit = playlistPageLimit;
    }

    public void setAlbumPageLimit(int albumPageLimit) {
        this.albumPageLimit = albumPageLimit;
    }

    @Override
    public String getSourceName() {
        return "spotify";
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        ExtendedAudioSourceManager.ExtendedAudioTrackInfo extendedAudioTrackInfo = super.decodeTrack(input);
        return new SpotifyAudioTrack(trackInfo, extendedAudioTrackInfo.albumName, extendedAudioTrackInfo.albumUrl, extendedAudioTrackInfo.artistUrl, extendedAudioTrackInfo.artistArtworkUrl, extendedAudioTrackInfo.previewUrl, extendedAudioTrackInfo.isPreview, this);
    }

    @Override
    @Nullable
    public AudioSearchResult loadSearch(@NotNull String query, @NotNull Set<AudioSearchResult.Type> types) {
        try {
            if (query.startsWith(SEARCH_PREFIX)) {
                return this.getAutocomplete(query.substring(SEARCH_PREFIX.length()), types);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String identifier = reference.identifier;
        boolean preview = reference.identifier.startsWith(PREVIEW_PREFIX);
        return this.loadItem(preview ? identifier.substring(PREVIEW_PREFIX.length()) : identifier, preview);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioItem loadItem(String identifier, boolean preview) {
        try {
            if (identifier.startsWith(SEARCH_PREFIX)) {
                return this.getSearch(identifier.substring(SEARCH_PREFIX.length()).trim(), preview);
            }
            if (identifier.startsWith(RECOMMENDATIONS_PREFIX)) {
                return this.getRecommendations(identifier.substring(RECOMMENDATIONS_PREFIX.length()).trim(), preview);
            }
            if (identifier.startsWith(SHARE_URL)) {
                HttpHead request = new HttpHead(identifier);
                request.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
                try (CloseableHttpResponse response = this.httpInterfaceManager.getInterface().execute((HttpUriRequest)request);){
                    String location;
                    if (response.getStatusLine().getStatusCode() == 307 && (location = response.getFirstHeader("Location").getValue()).startsWith("https://open.spotify.com/")) {
                        AudioItem audioItem = this.loadItem(location, preview);
                        return audioItem;
                    }
                    AudioItem audioItem = null;
                    return audioItem;
                }
            }
            Matcher matcher = URL_PATTERN.matcher(identifier);
            if (!matcher.find()) {
                return null;
            }
            String id = matcher.group("identifier");
            switch (matcher.group("type")) {
                case "album": {
                    return this.getAlbum(id, preview);
                }
                case "track": {
                    return this.getTrack(id, preview);
                }
                case "playlist": {
                    return this.getPlaylist(id, preview);
                }
                case "artist": {
                    return this.getArtist(id, preview);
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void requestToken() throws IOException {
        HttpPost request = new HttpPost("https://accounts.spotify.com/api/token");
        request.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes(StandardCharsets.UTF_8)));
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(List.of(new BasicNameValuePair("grant_type", "client_credentials")), StandardCharsets.UTF_8));
        JsonBrowser json2 = LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
        this.token = json2.get("access_token").text();
        this.tokenExpire = Instant.now().plusSeconds(json2.get("expires_in").asLong(0L));
    }

    public String getToken() throws IOException {
        if (this.token == null || this.tokenExpire == null || this.tokenExpire.isBefore(Instant.now())) {
            this.requestToken();
        }
        return this.token;
    }

    public JsonBrowser getJson(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.addHeader("Authorization", "Bearer " + this.getToken());
        return LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
    }

    private AudioSearchResult getAutocomplete(String query, Set<AudioSearchResult.Type> types) throws IOException {
        String url;
        JsonBrowser json2;
        if (types.contains((Object)AudioSearchResult.Type.TEXT)) {
            throw new IllegalArgumentException("text is not a valid search type for Spotify");
        }
        if (types.isEmpty()) {
            types = SEARCH_TYPES;
        }
        if ((json2 = this.getJson(url = "https://api.spotify.com/v1/search?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&type=" + types.stream().map(AudioSearchResult.Type::getName).collect(Collectors.joining(",")))) == null) {
            return AudioSearchResult.EMPTY;
        }
        ArrayList<AudioPlaylist> albums = new ArrayList<AudioPlaylist>();
        for (Object album : json2.get("albums").get("items").values()) {
            albums.add((AudioPlaylist)new SpotifyAudioPlaylist(album.get("name").text(), Collections.emptyList(), ExtendedAudioPlaylist.Type.ALBUM, album.get("external_urls").get("spotify").text(), album.get("images").index(0).get("url").text(), album.get("artists").index(0).get("name").text(), (int)album.get("total_tracks").asLong(0L)));
        }
        ArrayList<AudioPlaylist> artists = new ArrayList<AudioPlaylist>();
        for (Object artist : json2.get("artists").get("items").values()) {
            artists.add((AudioPlaylist)new SpotifyAudioPlaylist(artist.get("name").text() + "'s Top Tracks", Collections.emptyList(), ExtendedAudioPlaylist.Type.ARTIST, artist.get("external_urls").get("spotify").text(), artist.get("images").index(0).get("url").text(), artist.get("name").text(), null));
        }
        ArrayList<AudioPlaylist> playlists = new ArrayList<AudioPlaylist>();
        for (JsonBrowser playlist : json2.get("playlists").get("items").values()) {
            playlists.add((AudioPlaylist)new SpotifyAudioPlaylist(playlist.get("name").text(), Collections.emptyList(), ExtendedAudioPlaylist.Type.PLAYLIST, playlist.get("external_urls").get("spotify").text(), playlist.get("images").index(0).get("url").text(), playlist.get("owner").get("display_name").text(), (int)playlist.get("tracks").get("total").asLong(0L)));
        }
        List<AudioTrack> tracks = this.parseTrackItems(json2.get("tracks"), false);
        return new BasicAudioSearchResult(tracks, albums, artists, playlists, new ArrayList<AudioText>());
    }

    public AudioItem getSearch(String query, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.spotify.com/v1/search?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&type=track");
        if (json2 == null || json2.get("tracks").get("items").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String artistIds = json2.get("tracks").get("items").values().stream().map(track -> track.get("artists").index(0).get("id").text()).collect(Collectors.joining(","));
        JsonBrowser artistJson = this.getJson("https://api.spotify.com/v1/artists?ids=" + artistIds);
        if (artistJson != null) {
            for (JsonBrowser artist : artistJson.get("artists").values()) {
                for (JsonBrowser track2 : json2.get("tracks").get("items").values()) {
                    if (!track2.get("artists").index(0).get("id").text().equals(artist.get("id").text())) continue;
                    track2.get("artists").index(0).put("images", (Object)artist.get("images"));
                }
            }
        }
        return new BasicAudioPlaylist("Search results for: " + query, this.parseTrackItems(json2.get("tracks"), preview), null, true);
    }

    public AudioItem getRecommendations(String query, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.spotify.com/v1/recommendations?" + query);
        if (json2 == null || json2.get("tracks").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new SpotifyAudioPlaylist("Spotify Recommendations:", this.parseTracks(json2, preview), ExtendedAudioPlaylist.Type.RECOMMENDATIONS, null, null, null, null);
    }

    public AudioItem getAlbum(String id, boolean preview) throws IOException {
        JsonBrowser page;
        JsonBrowser json2 = this.getJson("https://api.spotify.com/v1/albums/" + id);
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser artistJson = this.getJson("https://api.spotify.com/v1/artists/" + json2.get("artists").index(0).get("id").text());
        if (artistJson == null) {
            artistJson = JsonBrowser.newMap();
        }
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        int offset = 0;
        int pages = 0;
        do {
            page = this.getJson("https://api.spotify.com/v1/albums/" + id + "/tracks?limit=50&offset=" + offset);
            offset += 50;
            JsonBrowser tracksPage = this.getJson("https://api.spotify.com/v1/tracks/?ids=" + page.get("items").values().stream().map(track -> track.get("id").text()).collect(Collectors.joining(",")));
            for (JsonBrowser track2 : tracksPage.get("tracks").values()) {
                JsonBrowser albumJson = JsonBrowser.newMap();
                albumJson.put("external_urls", (Object)json2.get("external_urls"));
                albumJson.put("name", (Object)json2.get("name"));
                albumJson.put("images", (Object)json2.get("images"));
                track2.put("album", (Object)albumJson);
                track2.get("artists").index(0).put("images", (Object)artistJson.get("images"));
            }
            tracks.addAll(this.parseTracks(tracksPage, preview));
        } while (page.get("next").text() != null && ++pages < this.albumPageLimit);
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new SpotifyAudioPlaylist(json2.get("name").text(), tracks, ExtendedAudioPlaylist.Type.ALBUM, json2.get("external_urls").get("spotify").text(), json2.get("images").index(0).get("url").text(), json2.get("artists").index(0).get("name").text(), (int)json2.get("total_tracks").asLong(0L));
    }

    public AudioItem getPlaylist(String id, boolean preview) throws IOException {
        JsonBrowser page;
        JsonBrowser json2 = this.getJson("https://api.spotify.com/v1/playlists/" + id);
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        int offset = 0;
        int pages = 0;
        do {
            page = this.getJson("https://api.spotify.com/v1/playlists/" + id + "/tracks?limit=100&offset=" + offset);
            offset += 100;
            for (JsonBrowser value : page.get("items").values()) {
                JsonBrowser track = value.get("track");
                if (track.isNull() || track.get("is_local").asBoolean(false)) continue;
                tracks.add(this.parseTrack(track, preview));
            }
        } while (page.get("next").text() != null && ++pages < this.playlistPageLimit);
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new SpotifyAudioPlaylist(json2.get("name").text(), tracks, ExtendedAudioPlaylist.Type.PLAYLIST, json2.get("external_urls").get("spotify").text(), json2.get("images").index(0).get("url").text(), json2.get("owner").get("display_name").text(), (int)json2.get("tracks").get("total").asLong(0L));
    }

    public AudioItem getArtist(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.spotify.com/v1/artists/" + id);
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser tracksJson = this.getJson("https://api.spotify.com/v1/artists/" + id + "/top-tracks?market=" + this.countryCode);
        if (tracksJson == null || tracksJson.get("tracks").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        for (JsonBrowser track : tracksJson.get("tracks").values()) {
            track.get("artists").index(0).put("images", (Object)json2.get("images"));
        }
        return new SpotifyAudioPlaylist(json2.get("name").text() + "'s Top Tracks", this.parseTracks(tracksJson, preview), ExtendedAudioPlaylist.Type.ARTIST, json2.get("external_urls").get("spotify").text(), json2.get("images").index(0).get("url").text(), json2.get("name").text(), (int)tracksJson.get("tracks").get("total").asLong(0L));
    }

    public AudioItem getTrack(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.spotify.com/v1/tracks/" + id);
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser artistJson = this.getJson("https://api.spotify.com/v1/artists/" + json2.get("artists").index(0).get("id").text());
        if (artistJson != null) {
            json2.get("artists").index(0).put("images", (Object)artistJson.get("images"));
        }
        return this.parseTrack(json2, preview);
    }

    private List<AudioTrack> parseTracks(JsonBrowser json2, boolean preview) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser value : json2.get("tracks").values()) {
            tracks.add(this.parseTrack(value, preview));
        }
        return tracks;
    }

    private List<AudioTrack> parseTrackItems(JsonBrowser json2, boolean preview) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser value : json2.get("items").values()) {
            if (value.get("is_local").asBoolean(false)) continue;
            tracks.add(this.parseTrack(value, preview));
        }
        return tracks;
    }

    private AudioTrack parseTrack(JsonBrowser json2, boolean preview) {
        return new SpotifyAudioTrack(new AudioTrackInfo(json2.get("name").text(), json2.get("artists").index(0).get("name").text(), preview ? 30000L : json2.get("duration_ms").asLong(0L), json2.get("id").text(), false, json2.get("external_urls").get("spotify").text(), json2.get("album").get("images").index(0).get("url").text(), json2.get("external_ids").get("isrc").text()), json2.get("album").get("name").text(), json2.get("album").get("external_urls").get("spotify").text(), json2.get("artists").index(0).get("external_urls").get("spotify").text(), json2.get("artists").index(0).get("images").index(0).get("url").text(), json2.get("preview_url").text(), preview, this);
    }

    @Override
    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            log.error("Failed to close HTTP interface manager", (Throwable)e);
        }
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }
}

