/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.yandexmusic;

import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.yandexmusic.YandexMusicAudioPlaylist;
import com.github.topi314.lavasrc.yandexmusic.YandexMusicAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YandexMusicSourceManager
implements AudioSourceManager,
HttpConfigurable {
    public static final Pattern URL_PATTERN = Pattern.compile("(https?://)?music\\.yandex\\.(ru|com)/(?<type1>artist|album)/(?<identifier>[0-9]+)/?((?<type2>track/)(?<identifier2>[0-9]+)/?)?");
    public static final Pattern URL_PLAYLIST_PATTERN = Pattern.compile("(https?://)?music\\.yandex\\.(ru|com)/users/(?<identifier>[0-9A-Za-z@.-]+)/playlists/(?<identifier2>[0-9]+)/?");
    public static final String SEARCH_PREFIX = "ymsearch:";
    public static final String PUBLIC_API_BASE = "https://api.music.yandex.net";
    private static final Logger log = LoggerFactory.getLogger(YandexMusicSourceManager.class);
    private final HttpInterfaceManager httpInterfaceManager;
    private final String accessToken;

    public YandexMusicSourceManager(String accessToken) {
        if (accessToken == null || accessToken.isEmpty()) {
            throw new IllegalArgumentException("Yandex Music accessToken must be set");
        }
        this.accessToken = accessToken;
        this.httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    }

    public String getSourceName() {
        return "yandexmusic";
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        try {
            if (reference.identifier.startsWith(SEARCH_PREFIX)) {
                return this.getSearch(reference.identifier.substring(SEARCH_PREFIX.length()));
            }
            Matcher matcher = URL_PATTERN.matcher(reference.identifier);
            if (matcher.find()) {
                switch (matcher.group("type1")) {
                    case "album": {
                        if (matcher.group("type2") != null) {
                            String trackId = matcher.group("identifier2");
                            return this.getTrack(trackId);
                        }
                        String albumId = matcher.group("identifier");
                        return this.getAlbum(albumId);
                    }
                    case "artist": {
                        String artistId = matcher.group("identifier");
                        return this.getArtist(artistId);
                    }
                }
                return null;
            }
            matcher = URL_PLAYLIST_PATTERN.matcher(reference.identifier);
            if (matcher.find()) {
                String userId = matcher.group("identifier");
                String playlistId = matcher.group("identifier2");
                return this.getPlaylist(userId, playlistId);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private AudioItem getSearch(String query) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/search?text=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&type=track&page=0");
        if (json2.isNull() || json2.get("result").get("tracks").isNull()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("result").get("tracks").get("results"));
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Yandex Music Search: " + query, tracks, null, true);
    }

    private AudioItem getAlbum(String id) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/albums/" + id + "/with-tracks");
        if (json2.isNull() || json2.get("result").isNull()) {
            return AudioReference.NO_TRACK;
        }
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser volume : json2.get("result").get("volumes").values()) {
            for (JsonBrowser track : volume.values()) {
                AudioTrack parsedTrack = this.parseTrack(track);
                if (parsedTrack == null) continue;
                tracks.add(parsedTrack);
            }
        }
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String coverUri = json2.get("result").get("coverUri").text();
        String author = ((JsonBrowser)json2.get("result").get("artists").values().get(0)).get("name").text();
        return new YandexMusicAudioPlaylist(json2.get("result").get("title").text(), tracks, ExtendedAudioPlaylist.Type.ALBUM, json2.get("result").get("url").text(), this.formatCoverUri(coverUri), author);
    }

    private AudioItem getTrack(String id) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/tracks/" + id);
        if (json2.isNull() || ((JsonBrowser)json2.get("result").values().get(0)).get("available").text().equals("false")) {
            return AudioReference.NO_TRACK;
        }
        return this.parseTrack((JsonBrowser)json2.get("result").values().get(0));
    }

    private AudioItem getArtist(String id) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/artists/" + id + "/tracks?page-size=10");
        if (json2.isNull() || json2.get("result").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("result").get("tracks"));
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser artistJson = this.getJson("https://api.music.yandex.net/artists/" + id);
        String coverUri = json2.get("result").get("coverUri").text();
        String author = artistJson.get("result").get("artist").get("name").text();
        return new YandexMusicAudioPlaylist(author + "'s Top Tracks", tracks, ExtendedAudioPlaylist.Type.ARTIST, json2.get("result").get("url").text(), this.formatCoverUri(coverUri), author);
    }

    private AudioItem getPlaylist(String userString, String id) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/users/" + userString + "/playlists/" + id);
        if (json2.isNull() || json2.get("result").isNull() || json2.get("result").get("tracks").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser track : json2.get("result").get("tracks").values()) {
            AudioTrack parsedTrack = this.parseTrack(track.get("track"));
            if (parsedTrack == null) continue;
            tracks.add(parsedTrack);
        }
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String playlistTitle = json2.get("result").get("kind").text().equals("3") ? "Liked songs" : json2.get("result").get("title").text();
        String coverUri = json2.get("result").get("cover").get("uri").text();
        String author = json2.get("result").get("owner").get("name").text();
        return new YandexMusicAudioPlaylist(playlistTitle, tracks, ExtendedAudioPlaylist.Type.PLAYLIST, json2.get("result").get("url").text(), this.formatCoverUri(coverUri), author);
    }

    public JsonBrowser getJson(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.setHeader("Accept", "application/json");
        request.setHeader("Authorization", "OAuth " + this.accessToken);
        return LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
    }

    public String getDownloadStrings(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.setHeader("Accept", "application/json");
        request.setHeader("Authorization", "OAuth " + this.accessToken);
        return HttpClientTools.fetchResponseLines((HttpInterface)this.httpInterfaceManager.getInterface(), (HttpUriRequest)request, (String)"downloadinfo-xml-page")[0];
    }

    private List<AudioTrack> parseTracks(JsonBrowser json2) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser track : json2.values()) {
            AudioTrack parsedTrack = this.parseTrack(track);
            if (parsedTrack == null) continue;
            tracks.add(parsedTrack);
        }
        return tracks;
    }

    private AudioTrack parseTrack(JsonBrowser json2) {
        if (!json2.get("available").asBoolean(false) || json2.get("albums").values().isEmpty()) {
            return null;
        }
        String id = json2.get("id").text();
        String artist = json2.get("major").get("name").text().equals("PODCASTS") ? ((JsonBrowser)json2.get("albums").values().get(0)).get("title").text() : ((JsonBrowser)json2.get("artists").values().get(0)).get("name").text();
        String coverUri = ((JsonBrowser)json2.get("albums").values().get(0)).get("coverUri").text();
        return new YandexMusicAudioTrack(new AudioTrackInfo(json2.get("title").text(), artist, ((Long)json2.get("durationMs").as(Long.class)).longValue(), id, false, "https://music.yandex.ru/album/" + ((JsonBrowser)json2.get("albums").values().get(0)).get("id").text() + "/track/" + id, this.formatCoverUri(coverUri), null), this);
    }

    private String formatCoverUri(String coverUri) {
        return coverUri != null ? "https://" + coverUri.replace("%%", "400x400") : null;
    }

    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new YandexMusicAudioTrack(trackInfo, this);
    }

    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            log.error("Failed to close HTTP interface manager", (Throwable)e);
        }
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }
}

