/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.plugin;

import com.github.topi314.lavalyrics.LyricsManager;
import com.github.topi314.lavalyrics.api.LyricsManagerConfiguration;
import com.github.topi314.lavasearch.SearchManager;
import com.github.topi314.lavasearch.api.SearchManagerConfiguration;
import com.github.topi314.lavasrc.applemusic.AppleMusicSourceManager;
import com.github.topi314.lavasrc.deezer.DeezerAudioSourceManager;
import com.github.topi314.lavasrc.flowerytts.FloweryTTSSourceManager;
import com.github.topi314.lavasrc.mirror.DefaultMirroringAudioTrackResolver;
import com.github.topi314.lavasrc.plugin.AppleMusicConfig;
import com.github.topi314.lavasrc.plugin.DeezerConfig;
import com.github.topi314.lavasrc.plugin.FloweryTTSConfig;
import com.github.topi314.lavasrc.plugin.LavaSrcConfig;
import com.github.topi314.lavasrc.plugin.LyricsSourcesConfig;
import com.github.topi314.lavasrc.plugin.SourcesConfig;
import com.github.topi314.lavasrc.plugin.SpotifyConfig;
import com.github.topi314.lavasrc.plugin.YandexMusicConfig;
import com.github.topi314.lavasrc.plugin.YouTubeConfig;
import com.github.topi314.lavasrc.spotify.SpotifySourceManager;
import com.github.topi314.lavasrc.yandexmusic.YandexMusicSourceManager;
import com.github.topi314.lavasrc.youtube.YoutubeSearchManager;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.arbjerg.lavalink.api.AudioPlayerManagerConfiguration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LavaSrcPlugin
implements AudioPlayerManagerConfiguration,
SearchManagerConfiguration,
LyricsManagerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LavaSrcPlugin.class);
    private final SourcesConfig sourcesConfig;
    private final LyricsSourcesConfig lyricsSourcesConfig;
    private AudioPlayerManager manager;
    private SpotifySourceManager spotify;
    private AppleMusicSourceManager appleMusic;
    private DeezerAudioSourceManager deezer;
    private YandexMusicSourceManager yandexMusic;
    private FloweryTTSSourceManager flowerytts;
    private YoutubeSearchManager youtube;

    public LavaSrcPlugin(LavaSrcConfig pluginConfig, SourcesConfig sourcesConfig, LyricsSourcesConfig lyricsSourcesConfig, SpotifyConfig spotifyConfig, AppleMusicConfig appleMusicConfig, DeezerConfig deezerConfig, YandexMusicConfig yandexMusicConfig, FloweryTTSConfig floweryTTSConfig, YouTubeConfig youTubeConfig) {
        log.info("Loading LavaSrc plugin...");
        this.sourcesConfig = sourcesConfig;
        this.lyricsSourcesConfig = lyricsSourcesConfig;
        if (sourcesConfig.isSpotify() || lyricsSourcesConfig.isSpotify()) {
            this.spotify = new SpotifySourceManager(spotifyConfig.getClientId(), spotifyConfig.getClientSecret(), spotifyConfig.getSpDc(), spotifyConfig.getCountryCode(), unused -> this.manager, new DefaultMirroringAudioTrackResolver(pluginConfig.getProviders()));
            if (spotifyConfig.getPlaylistLoadLimit() > 0) {
                this.spotify.setPlaylistPageLimit(spotifyConfig.getPlaylistLoadLimit());
            }
            if (spotifyConfig.getAlbumLoadLimit() > 0) {
                this.spotify.setAlbumPageLimit(spotifyConfig.getAlbumLoadLimit());
            }
        }
        if (sourcesConfig.isAppleMusic()) {
            this.appleMusic = new AppleMusicSourceManager(pluginConfig.getProviders(), appleMusicConfig.getMediaAPIToken(), appleMusicConfig.getCountryCode(), unused -> this.manager);
            if (appleMusicConfig.getPlaylistLoadLimit() > 0) {
                this.appleMusic.setPlaylistPageLimit(appleMusicConfig.getPlaylistLoadLimit());
            }
            if (appleMusicConfig.getAlbumLoadLimit() > 0) {
                this.appleMusic.setAlbumPageLimit(appleMusicConfig.getAlbumLoadLimit());
            }
        }
        if (sourcesConfig.isDeezer() || lyricsSourcesConfig.isDeezer()) {
            this.deezer = new DeezerAudioSourceManager(deezerConfig.getMasterDecryptionKey());
        }
        if (sourcesConfig.isYandexMusic()) {
            this.yandexMusic = new YandexMusicSourceManager(yandexMusicConfig.getAccessToken());
            if (yandexMusicConfig.getPlaylistLoadLimit() > 0) {
                this.yandexMusic.setPlaylistLoadLimit(yandexMusicConfig.getPlaylistLoadLimit());
            }
            if (yandexMusicConfig.getAlbumLoadLimit() > 0) {
                this.yandexMusic.setAlbumLoadLimit(yandexMusicConfig.getAlbumLoadLimit());
            }
            if (yandexMusicConfig.getArtistLoadLimit() > 0) {
                this.yandexMusic.setArtistLoadLimit(yandexMusicConfig.getArtistLoadLimit());
            }
        }
        if (sourcesConfig.isFloweryTTS()) {
            this.flowerytts = new FloweryTTSSourceManager(floweryTTSConfig.getVoice());
            if (floweryTTSConfig.getTranslate()) {
                this.flowerytts.setTranslate(floweryTTSConfig.getTranslate());
            }
            if (floweryTTSConfig.getSilence() > 0) {
                this.flowerytts.setSilence(floweryTTSConfig.getSilence());
            }
            if (floweryTTSConfig.getSpeed() > 0.0f) {
                this.flowerytts.setSpeed(floweryTTSConfig.getSpeed());
            }
            if (floweryTTSConfig.getAudioFormat() != null) {
                this.flowerytts.setAudioFormat(floweryTTSConfig.getAudioFormat());
            }
        }
        if (sourcesConfig.isYoutube() || lyricsSourcesConfig.isYoutube()) {
            if (this.hasNewYoutubeSource()) {
                log.info("Registering Youtube Source audio source manager...");
                this.youtube = new YoutubeSearchManager(() -> this.manager, youTubeConfig.getCountryCode());
            } else {
                throw new IllegalStateException("Youtube LavaSearch requires either Lavaplayer Youtube or Youtube Source plugin to be enabled.");
            }
        }
    }

    private boolean hasNewYoutubeSource() {
        try {
            Class.forName("dev.lavalink.youtube.YoutubeAudioSourceManager");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    @NotNull
    public AudioPlayerManager configure(@NotNull AudioPlayerManager manager) {
        this.manager = manager;
        if (this.spotify != null && this.sourcesConfig.isSpotify()) {
            log.info("Registering Spotify audio source manager...");
            manager.registerSourceManager((AudioSourceManager)this.spotify);
        }
        if (this.appleMusic != null) {
            log.info("Registering Apple Music audio source manager...");
            manager.registerSourceManager((AudioSourceManager)this.appleMusic);
        }
        if (this.deezer != null && this.sourcesConfig.isDeezer()) {
            log.info("Registering Deezer audio source manager...");
            manager.registerSourceManager((AudioSourceManager)this.deezer);
        }
        if (this.yandexMusic != null) {
            log.info("Registering Yandex Music audio source manager...");
            manager.registerSourceManager((AudioSourceManager)this.yandexMusic);
        }
        if (this.flowerytts != null) {
            log.info("Registering Flowery TTS audio source manager...");
            manager.registerSourceManager((AudioSourceManager)this.flowerytts);
        }
        return manager;
    }

    @Override
    @NotNull
    public SearchManager configure(@NotNull SearchManager manager) {
        if (this.spotify != null && this.sourcesConfig.isSpotify()) {
            log.info("Registering Spotify search manager...");
            manager.registerSearchManager(this.spotify);
        }
        if (this.appleMusic != null && this.sourcesConfig.isAppleMusic()) {
            log.info("Registering Apple Music search manager...");
            manager.registerSearchManager(this.appleMusic);
        }
        if (this.deezer != null && this.sourcesConfig.isDeezer()) {
            log.info("Registering Deezer search manager...");
            manager.registerSearchManager(this.deezer);
        }
        if (this.youtube != null && this.sourcesConfig.isYoutube()) {
            log.info("Registering Youtube search manager...");
            manager.registerSearchManager(this.youtube);
        }
        return manager;
    }

    @Override
    @NotNull
    public LyricsManager configure(@NotNull LyricsManager manager) {
        if (this.spotify != null && this.lyricsSourcesConfig.isSpotify()) {
            log.info("Registering Spotify lyrics manager...");
            manager.registerLyricsManager(this.spotify);
        }
        if (this.deezer != null && this.lyricsSourcesConfig.isDeezer()) {
            log.info("Registering Deezer lyrics manager...");
            manager.registerLyricsManager(this.deezer);
        }
        if (this.youtube != null && this.lyricsSourcesConfig.isYoutube()) {
            log.info("Registering YouTube lyrics manager...");
            manager.registerLyricsManager(this.youtube);
        }
        return manager;
    }
}

