/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.yandexmusic;

import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.ExtendedAudioSourceManager;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.yandexmusic.YandexMusicAudioPlaylist;
import com.github.topi314.lavasrc.yandexmusic.YandexMusicAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YandexMusicSourceManager
extends ExtendedAudioSourceManager
implements HttpConfigurable {
    public static final Pattern URL_PATTERN = Pattern.compile("(https?://)?music\\.yandex\\.(?<domain>ru|com|kz|by)/(?<type1>artist|album|track)/(?<identifier>[0-9]+)(/(?<type2>track)/(?<identifier2>[0-9]+))?/?");
    public static final Pattern URL_PLAYLIST_PATTERN = Pattern.compile("(https?://)?music\\.yandex\\.(?<domain>ru|com|kz|by)/users/(?<identifier>[0-9A-Za-z@.-]+)/playlists/(?<identifier2>[0-9]+)/?");
    public static final String SEARCH_PREFIX = "ymsearch:";
    public static final String RECOMMENDATIONS_PREFIX = "ymrec:";
    public static final String PUBLIC_API_BASE = "https://api.music.yandex.net";
    public static final int ARTIST_MAX_PAGE_ITEMS = 10;
    public static final int PLAYLIST_MAX_PAGE_ITEMS = 100;
    public static final int ALBUM_MAX_PAGE_ITEMS = 50;
    private static final Logger log = LoggerFactory.getLogger(YandexMusicSourceManager.class);
    private final HttpInterfaceManager httpInterfaceManager;
    private final String accessToken;
    private int artistLoadLimit;
    private int albumLoadLimit;
    private int playlistLoadLimit;

    public YandexMusicSourceManager(String accessToken) {
        if (accessToken == null || accessToken.isEmpty()) {
            throw new IllegalArgumentException("Yandex Music accessToken must be set");
        }
        this.accessToken = accessToken;
        this.httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    }

    public void setArtistLoadLimit(int artistLimit) {
        this.artistLoadLimit = artistLimit;
    }

    public void setAlbumLoadLimit(int albumLimit) {
        this.albumLoadLimit = albumLimit;
    }

    public void setPlaylistLoadLimit(int playlistLimit) {
        this.playlistLoadLimit = playlistLimit;
    }

    public String getSourceName() {
        return "yandexmusic";
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        try {
            if (reference.identifier.startsWith(SEARCH_PREFIX)) {
                return this.getSearch(reference.identifier.substring(SEARCH_PREFIX.length()));
            }
            if (reference.identifier.startsWith(RECOMMENDATIONS_PREFIX)) {
                return this.getRecommendations(reference.identifier.substring(RECOMMENDATIONS_PREFIX.length()));
            }
            Matcher matcher = URL_PATTERN.matcher(reference.identifier);
            if (matcher.find()) {
                String domainEnd = matcher.group("domain");
                switch (matcher.group("type1")) {
                    case "album": {
                        if (matcher.group("type2") != null) {
                            String trackId = matcher.group("identifier2");
                            return this.getTrack(trackId, domainEnd);
                        }
                        String albumId = matcher.group("identifier");
                        return this.getAlbum(albumId, domainEnd);
                    }
                    case "artist": {
                        String artistId = matcher.group("identifier");
                        return this.getArtist(artistId, domainEnd);
                    }
                    case "track": {
                        String trackId = matcher.group("identifier");
                        return this.getTrack(trackId, domainEnd);
                    }
                }
                return null;
            }
            matcher = URL_PLAYLIST_PATTERN.matcher(reference.identifier);
            if (matcher.find()) {
                String userId = matcher.group("identifier");
                String playlistId = matcher.group("identifier2");
                return this.getPlaylist(userId, playlistId, matcher.group("domain"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static boolean canBeLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private AudioItem getRecommendations(String identifier) throws IOException {
        if (!YandexMusicSourceManager.canBeLong(identifier)) {
            throw new IllegalArgumentException("The yandex music track identifier must be a number");
        }
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/tracks/" + identifier + "/similar");
        if (json2.isNull() || json2.get("result").isNull() || json2.get("result").get("similarTracks").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("result").get("similarTracks"), "com");
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser trackInfo = json2.get("result").get("track");
        return new YandexMusicAudioPlaylist("Yandex Music Recommendations For Track: " + trackInfo.get("title").text(), tracks, ExtendedAudioPlaylist.Type.RECOMMENDATIONS, null, null, null, tracks.size());
    }

    private AudioItem getSearch(String query) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/search?text=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&type=track&page=0");
        if (json2.isNull() || json2.get("result").get("tracks").isNull()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("result").get("tracks").get("results"), "com");
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Yandex Music Search: " + query, tracks, null, true);
    }

    private AudioItem getAlbum(String id, String domainEnd) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/albums/" + id + "/with-tracks?page-size=" + 50 * this.albumLoadLimit);
        if (json2.isNull() || json2.get("result").isNull()) {
            return AudioReference.NO_TRACK;
        }
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser volume : json2.get("result").get("volumes").values()) {
            for (JsonBrowser track : volume.values()) {
                AudioTrack parsedTrack = this.parseTrack(track, domainEnd);
                if (parsedTrack == null) continue;
                tracks.add(parsedTrack);
            }
        }
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String author = ((JsonBrowser)json2.get("result").get("artists").values().get(0)).get("name").text();
        return new YandexMusicAudioPlaylist(json2.get("result").get("title").text(), tracks, ExtendedAudioPlaylist.Type.ALBUM, "https://music.yandex." + domainEnd + "/album/" + id, this.parseCoverUri(json2.get("result")), author, tracks.size());
    }

    private AudioItem getTrack(String id, String domainEnd) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/tracks/" + id);
        if (json2.isNull() || ((JsonBrowser)json2.get("result").values().get(0)).get("available").text().equals("false")) {
            return AudioReference.NO_TRACK;
        }
        return this.parseTrack((JsonBrowser)json2.get("result").values().get(0), domainEnd);
    }

    private AudioItem getArtist(String id, String domainEnd) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/artists/" + id + "/tracks?page-size=" + 10 * this.artistLoadLimit);
        if (json2.isNull() || json2.get("result").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("result").get("tracks"), domainEnd);
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser artistJsonResponse = this.getJson("https://api.music.yandex.net/artists/" + id);
        JsonBrowser artistJson = artistJsonResponse.get("result").get("artist");
        String author = artistJson.get("name").text();
        return new YandexMusicAudioPlaylist(author + "'s Top Tracks", tracks, ExtendedAudioPlaylist.Type.ARTIST, "https://music.yandex.ru/artist/" + id, this.parseCoverUri(artistJson), author, tracks.size());
    }

    private AudioItem getPlaylist(String userString, String id, String domainEnd) throws IOException {
        Object playlistTitle;
        JsonBrowser json2 = this.getJson("https://api.music.yandex.net/users/" + userString + "/playlists/" + id + "?page-size=" + 100 * this.playlistLoadLimit + "&rich-tracks=true");
        if (json2.isNull() || json2.get("result").isNull() || json2.get("result").get("tracks").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("result").get("tracks"), domainEnd);
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        if (json2.get("result").get("kind").text().equals("3")) {
            JsonBrowser ownerJson = json2.get("result").get("owner");
            String ownerName = ownerJson.get("name").isNull() ? ownerJson.get("login").text() : ownerJson.get("name").text();
            playlistTitle = ownerName + "'s liked songs";
        } else {
            playlistTitle = json2.get("result").get("title").text();
        }
        String author = json2.get("result").get("owner").get("name").text();
        return new YandexMusicAudioPlaylist((String)playlistTitle, tracks, ExtendedAudioPlaylist.Type.PLAYLIST, "https://music.yandex." + domainEnd + "/users/" + userString + "/playlists/" + id, this.parseCoverUri(json2.get("result")), author, tracks.size());
    }

    public JsonBrowser getJson(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.setHeader("Accept", "application/json");
        request.setHeader("Authorization", "OAuth " + this.accessToken);
        return LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
    }

    public String getDownloadStrings(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.setHeader("Accept", "application/json");
        request.setHeader("Authorization", "OAuth " + this.accessToken);
        return HttpClientTools.fetchResponseLines((HttpInterface)this.httpInterfaceManager.getInterface(), (HttpUriRequest)request, (String)"downloadinfo-xml-page")[0];
    }

    private List<AudioTrack> parseTracks(JsonBrowser json2, String domainEnd) {
        List tracksToParse = json2.values();
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser track : tracksToParse) {
            AudioTrack parsedTrack = track.get("track").isNull() ? this.parseTrack(track, domainEnd) : this.parseTrack(track.get("track"), domainEnd);
            if (parsedTrack == null) continue;
            tracks.add(parsedTrack);
        }
        return tracks;
    }

    private AudioTrack parseTrack(JsonBrowser json2, String domainEnd) {
        if (!json2.get("available").asBoolean(false)) {
            return null;
        }
        String id = json2.get("id").text();
        String artist = this.parseArtist(json2);
        String albumName = null;
        String albumUrl = null;
        if (!json2.get("albums").values().isEmpty()) {
            JsonBrowser album = (JsonBrowser)json2.get("albums").values().get(0);
            albumName = album.get("title").text();
            albumUrl = "https://music.yandex." + domainEnd + "/album/" + album.get("id").text();
        }
        String artistUrl = null;
        String artistArtworkUrl = null;
        if (!json2.get("artists").values().isEmpty()) {
            JsonBrowser firstArtist = (JsonBrowser)json2.get("artists").values().get(0);
            artistUrl = "https://music.yandex." + domainEnd + "/artist/" + firstArtist.get("id").text();
            artistArtworkUrl = this.parseCoverUri(firstArtist);
        }
        return new YandexMusicAudioTrack(new AudioTrackInfo(json2.get("title").text(), artist, ((Long)json2.get("durationMs").as(Long.class)).longValue(), id, false, "https://music.yandex." + domainEnd + "/track/" + id, this.parseCoverUri(json2), null), albumName, albumUrl, artistUrl, artistArtworkUrl, this);
    }

    private String parseArtist(JsonBrowser json2) {
        if (!json2.get("major").isNull() && json2.get("major").get("name").text().equals("PODCASTS")) {
            return ((JsonBrowser)json2.get("albums").values().get(0)).get("title").text();
        }
        if (!json2.get("artists").values().isEmpty()) {
            return this.extractArtists(json2.get("artists"));
        }
        if (!json2.get("matchedTrack").isNull()) {
            return this.extractArtists(json2.get("matchedTrack").get("artists"));
        }
        return "Unknown";
    }

    private String extractArtists(JsonBrowser artistNode) {
        return artistNode.values().stream().map(node -> node.get("name").text()).collect(Collectors.joining(", "));
    }

    private String parseCoverUri(JsonBrowser objectJson) {
        if (!objectJson.get("ogImage").isNull()) {
            return this.formatCoverUri(objectJson.get("ogImage").text());
        }
        if (!objectJson.get("coverUri").isNull()) {
            return this.formatCoverUri(objectJson.get("coverUri").text());
        }
        JsonBrowser coverJson = objectJson.get("cover");
        if (!coverJson.isNull()) {
            if (!coverJson.get("uri").isNull()) {
                return this.formatCoverUri(coverJson.get("uri").text());
            }
            if (!coverJson.get("itemsUri").values().isEmpty()) {
                return this.formatCoverUri(((JsonBrowser)coverJson.get("itemsUri").values().get(0)).text());
            }
        }
        return null;
    }

    private String formatCoverUri(String coverUri) {
        return coverUri != null ? "https://" + coverUri.replace("%%", "400x400") : null;
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        ExtendedAudioSourceManager.ExtendedAudioTrackInfo extendedAudioTrackInfo = super.decodeTrack(input);
        return new YandexMusicAudioTrack(trackInfo, extendedAudioTrackInfo.albumName, extendedAudioTrackInfo.albumUrl, extendedAudioTrackInfo.artistUrl, extendedAudioTrackInfo.artistArtworkUrl, this);
    }

    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            log.error("Failed to close HTTP interface manager", (Throwable)e);
        }
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }
}

