/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.deezer;

import com.github.topi314.lavasrc.ExtendedAudioTrack;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.deezer.DeezerAudioSourceManager;
import com.github.topi314.lavasrc.deezer.DeezerPersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class DeezerAudioTrack
extends ExtendedAudioTrack {
    private final DeezerAudioSourceManager sourceManager;

    public DeezerAudioTrack(AudioTrackInfo trackInfo, DeezerAudioSourceManager sourceManager) {
        this(trackInfo, null, null, null, null, null, false, sourceManager);
    }

    public DeezerAudioTrack(AudioTrackInfo trackInfo, String albumName, String albumUrl, String artistUrl, String artistArtworkUrl, String previewUrl, boolean isPreview, DeezerAudioSourceManager sourceManager) {
        super(trackInfo, albumName, albumUrl, artistUrl, artistArtworkUrl, previewUrl, isPreview);
        this.sourceManager = sourceManager;
    }

    private URI getTrackMediaURI() throws IOException, URISyntaxException {
        HttpPost getSessionID = new HttpPost("https://www.deezer.com/ajax/gw-light.php?method=deezer.ping&input=3&api_version=1.0&api_token=");
        JsonBrowser json2 = LavaSrcTools.fetchResponseAsJson(this.sourceManager.getHttpInterface(), (HttpUriRequest)getSessionID);
        this.checkResponse(json2, "Failed to get session ID: ");
        String sessionID = json2.get("results").get("SESSION").text();
        HttpPost getUserToken = new HttpPost("https://www.deezer.com/ajax/gw-light.php?method=deezer.getUserData&input=3&api_version=1.0&api_token=");
        getUserToken.setHeader("Cookie", "sid=" + sessionID);
        json2 = LavaSrcTools.fetchResponseAsJson(this.sourceManager.getHttpInterface(), (HttpUriRequest)getUserToken);
        this.checkResponse(json2, "Failed to get user token: ");
        String userLicenseToken = json2.get("results").get("USER").get("OPTIONS").get("license_token").text();
        String apiToken = json2.get("results").get("checkForm").text();
        HttpPost getTrackToken = new HttpPost("https://www.deezer.com/ajax/gw-light.php?method=song.getData&input=3&api_version=1.0&api_token=" + apiToken);
        getTrackToken.setEntity((HttpEntity)new StringEntity("{\"sng_id\":\"" + this.trackInfo.identifier + "\"}", ContentType.APPLICATION_JSON));
        json2 = LavaSrcTools.fetchResponseAsJson(this.sourceManager.getHttpInterface(), (HttpUriRequest)getTrackToken);
        this.checkResponse(json2, "Failed to get track token: ");
        String trackToken = json2.get("results").get("TRACK_TOKEN").text();
        HttpPost getMediaURL = new HttpPost("https://media.deezer.com/v1/get_url");
        getMediaURL.setEntity((HttpEntity)new StringEntity("{\"license_token\":\"" + userLicenseToken + "\",\"media\": [{\"type\": \"FULL\",\"formats\": [{\"cipher\": \"BF_CBC_STRIPE\", \"format\": \"MP3_128\"}]}],\"track_tokens\": [\"" + trackToken + "\"]}", ContentType.APPLICATION_JSON));
        json2 = LavaSrcTools.fetchResponseAsJson(this.sourceManager.getHttpInterface(), (HttpUriRequest)getMediaURL);
        this.checkResponse(json2, "Failed to get media URL: ");
        return new URI(json2.get("data").index(0).get("media").index(0).get("sources").index(0).get("url").text());
    }

    private void checkResponse(JsonBrowser json2, String message) throws IllegalStateException {
        if (json2 == null) {
            throw new IllegalStateException(message + "No response");
        }
        List errors = json2.get("data").index(0).get("errors").values();
        if (!errors.isEmpty()) {
            String errorsStr = errors.stream().map(error -> error.get("code").text() + ": " + error.get("message").text()).collect(Collectors.joining(", "));
            throw new IllegalStateException(message + errorsStr);
        }
    }

    private byte[] getTrackDecryptionKey() throws NoSuchAlgorithmException {
        char[] md5 = Hex.encodeHex((byte[])MessageDigest.getInstance("MD5").digest(this.trackInfo.identifier.getBytes()), (boolean)true);
        byte[] master_key = this.sourceManager.getMasterDecryptionKey().getBytes();
        byte[] key = new byte[16];
        for (int i = 0; i < 16; ++i) {
            key[i] = (byte)(md5[i] ^ md5[i + 16] ^ master_key[i]);
        }
        return key;
    }

    public void process(LocalAudioTrackExecutor executor) throws Exception {
        block18: {
            try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
                if (this.isPreview) {
                    if (this.previewUrl == null) {
                        throw new FriendlyException("No preview url found", FriendlyException.Severity.COMMON, (Throwable)new IllegalArgumentException());
                    }
                    try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(this.previewUrl), Long.valueOf(this.trackInfo.length));){
                        this.processDelegate((InternalAudioTrack)new Mp3AudioTrack(this.trackInfo, (SeekableInputStream)stream), executor);
                        break block18;
                    }
                }
                try (DeezerPersistentHttpStream stream = new DeezerPersistentHttpStream(httpInterface, this.getTrackMediaURI(), this.trackInfo.length, this.getTrackDecryptionKey());){
                    this.processDelegate((InternalAudioTrack)new Mp3AudioTrack(this.trackInfo, (SeekableInputStream)stream), executor);
                }
            }
        }
    }

    protected AudioTrack makeShallowClone() {
        return new DeezerAudioTrack(this.trackInfo, this.albumName, this.albumUrl, this.artistUrl, this.artistArtworkUrl, this.previewUrl, this.isPreview, this.sourceManager);
    }

    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

