/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.mirror;

import com.github.topi314.lavasrc.mirror.MirroringAudioTrack;
import com.github.topi314.lavasrc.mirror.MirroringAudioTrackResolver;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMirroringAudioTrackResolver
implements MirroringAudioTrackResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultMirroringAudioTrackResolver.class);
    private String[] providers = new String[]{"ytsearch:\"%ISRC%\"", "ytsearch:%QUERY%"};

    public DefaultMirroringAudioTrackResolver(String[] providers) {
        if (providers != null && providers.length > 0) {
            this.providers = providers;
        }
    }

    @Override
    public AudioItem apply(MirroringAudioTrack mirroringAudioTrack) {
        AudioReference track = AudioReference.NO_TRACK;
        for (String provider : this.providers) {
            if (provider.startsWith("spsearch:")) {
                log.warn("Can not use spotify search as search provider!");
                continue;
            }
            if (provider.startsWith("amsearch:")) {
                log.warn("Can not use apple music search as search provider!");
                continue;
            }
            if (provider.contains("%ISRC%")) {
                if (mirroringAudioTrack.getInfo().isrc != null && !mirroringAudioTrack.getInfo().isrc.isEmpty()) {
                    provider = provider.replace("%ISRC%", mirroringAudioTrack.getInfo().isrc);
                } else {
                    log.debug("Ignoring identifier \"{}\" because this track does not have an ISRC!", (Object)provider);
                    continue;
                }
            }
            provider = provider.replace("%QUERY%", this.getTrackTitle(mirroringAudioTrack));
            try {
                track = mirroringAudioTrack.loadItem(provider);
            }
            catch (Exception e) {
                log.error("Failed to load track from provider \"{}\"!", (Object)provider, (Object)e);
            }
            if (track != AudioReference.NO_TRACK) break;
        }
        return track;
    }

    public String getTrackTitle(MirroringAudioTrack mirroringAudioTrack) {
        Object query = mirroringAudioTrack.getInfo().title;
        if (!mirroringAudioTrack.getInfo().author.equals("unknown")) {
            query = (String)query + " " + mirroringAudioTrack.getInfo().author;
        }
        return query;
    }
}

