/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.deezer;

import com.github.topi314.lavalyrics.AudioLyricsManager;
import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.github.topi314.lavalyrics.lyrics.BasicAudioLyrics;
import com.github.topi314.lavasearch.AudioSearchManager;
import com.github.topi314.lavasearch.result.AudioSearchResult;
import com.github.topi314.lavasearch.result.AudioText;
import com.github.topi314.lavasearch.result.BasicAudioSearchResult;
import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.ExtendedAudioSourceManager;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.deezer.DeezerAudioPlaylist;
import com.github.topi314.lavasrc.deezer.DeezerAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeezerAudioSourceManager
extends ExtendedAudioSourceManager
implements HttpConfigurable,
AudioSearchManager,
AudioLyricsManager {
    public static final Pattern URL_PATTERN = Pattern.compile("(https?://)?(www\\.)?deezer\\.com/(?<countrycode>[a-zA-Z]{2}/)?(?<type>track|album|playlist|artist)/(?<identifier>[0-9]+)");
    public static final String SEARCH_PREFIX = "dzsearch:";
    public static final String ISRC_PREFIX = "dzisrc:";
    public static final String PREVIEW_PREFIX = "dzprev:";
    public static final long PREVIEW_LENGTH = 30000L;
    public static final String SHARE_URL = "https://deezer.page.link/";
    public static final String PUBLIC_API_BASE = "https://api.deezer.com/2.0";
    public static final String PRIVATE_API_BASE = "https://www.deezer.com/ajax/gw-light.php";
    public static final String MEDIA_BASE = "https://media.deezer.com/v1";
    public static final Set<AudioSearchResult.Type> SEARCH_TYPES = Set.of(AudioSearchResult.Type.TRACK, AudioSearchResult.Type.ALBUM, AudioSearchResult.Type.PLAYLIST, AudioSearchResult.Type.ARTIST);
    private static final Logger log = LoggerFactory.getLogger(DeezerAudioSourceManager.class);
    private final String masterDecryptionKey;
    private String arl;
    private DeezerAudioTrack.TrackFormat[] formats;
    private final HttpInterfaceManager httpInterfaceManager;
    private Tokens tokens;

    public DeezerAudioSourceManager(String masterDecryptionKey) {
        this(masterDecryptionKey, null);
    }

    public DeezerAudioSourceManager(String masterDecryptionKey, @Nullable String arl) {
        this(masterDecryptionKey, arl, null);
    }

    public DeezerAudioSourceManager(String masterDecryptionKey, @Nullable String arl, @Nullable DeezerAudioTrack.TrackFormat[] formats) {
        if (masterDecryptionKey == null || masterDecryptionKey.isEmpty()) {
            throw new IllegalArgumentException("Deezer master key must be set");
        }
        this.masterDecryptionKey = masterDecryptionKey;
        this.arl = arl != null && arl.isEmpty() ? null : arl;
        this.formats = formats != null && formats.length > 0 ? formats : DeezerAudioTrack.TrackFormat.DEFAULT_FORMATS;
        this.httpInterfaceManager = HttpClientTools.createCookielessThreadLocalManager();
    }

    public void setFormats(DeezerAudioTrack.TrackFormat[] formats) {
        if (formats.length == 0) {
            throw new IllegalArgumentException("Deezer track formats must not be empty");
        }
        this.formats = formats;
    }

    public void setArl(String arl) {
        this.arl = arl;
    }

    static void checkResponse(JsonBrowser json2, String message) throws IllegalStateException {
        if (json2 == null) {
            throw new IllegalStateException(message + "No response");
        }
        List errors = json2.get("data").index(0).get("errors").values();
        if (!errors.isEmpty()) {
            String errorsStr = errors.stream().map(error -> error.get("code").text() + ": " + error.get("message").text()).collect(Collectors.joining(", "));
            throw new IllegalStateException(message + errorsStr);
        }
    }

    private void refreshSession() throws IOException {
        HttpPost getSessionID = new HttpPost("https://www.deezer.com/ajax/gw-light.php?method=deezer.ping&input=3&api_version=1.0&api_token=");
        JsonBrowser json2 = LavaSrcTools.fetchResponseAsJson(this.getHttpInterface(), (HttpUriRequest)getSessionID);
        DeezerAudioSourceManager.checkResponse(json2, "Failed to get session ID: ");
        String sessionID = json2.get("results").get("SESSION").text();
        HttpPost getUserToken = new HttpPost("https://www.deezer.com/ajax/gw-light.php?method=deezer.getUserData&input=3&api_version=1.0&api_token=");
        getUserToken.setHeader("Cookie", "sid=" + sessionID);
        json2 = LavaSrcTools.fetchResponseAsJson(this.getHttpInterface(), (HttpUriRequest)getUserToken);
        DeezerAudioSourceManager.checkResponse(json2, "Failed to get user token: ");
        this.tokens = new Tokens(json2.get("results").get("checkForm").text(), json2.get("results").get("USER").get("OPTIONS").get("license_token").text(), Instant.now().plus(3600L, ChronoUnit.SECONDS));
    }

    public Tokens getTokens() throws IOException {
        if (this.tokens == null || Instant.now().isAfter(this.tokens.expireAt)) {
            this.refreshSession();
        }
        return this.tokens;
    }

    @Override
    @NotNull
    public String getSourceName() {
        return "deezer";
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        ExtendedAudioSourceManager.ExtendedAudioTrackInfo extendedAudioTrackInfo = super.decodeTrack(input);
        return new DeezerAudioTrack(trackInfo, extendedAudioTrackInfo.albumName, extendedAudioTrackInfo.albumUrl, extendedAudioTrackInfo.artistUrl, extendedAudioTrackInfo.artistArtworkUrl, extendedAudioTrackInfo.previewUrl, extendedAudioTrackInfo.isPreview, this);
    }

    @Override
    @Nullable
    public AudioLyrics loadLyrics(@NotNull AudioTrack audioTrack) {
        String deezerTackId = "";
        if (audioTrack instanceof DeezerAudioTrack) {
            deezerTackId = audioTrack.getIdentifier();
        }
        if (deezerTackId.isEmpty()) {
            AudioPlaylist playlist;
            AudioReference item = AudioReference.NO_TRACK;
            try {
                if (audioTrack.getInfo().isrc != null && !audioTrack.getInfo().isrc.isEmpty()) {
                    item = this.getTrackByISRC(audioTrack.getInfo().isrc, false);
                }
                if (item == AudioReference.NO_TRACK) {
                    item = this.getSearch(String.format("%s %s", audioTrack.getInfo().title, audioTrack.getInfo().author), false);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (item == AudioReference.NO_TRACK) {
                return null;
            }
            if (item instanceof AudioTrack) {
                deezerTackId = ((AudioTrack)item).getIdentifier();
            } else if (item instanceof AudioPlaylist && !(playlist = (AudioPlaylist)item).getTracks().isEmpty()) {
                deezerTackId = ((AudioTrack)playlist.getTracks().get(0)).getIdentifier();
            }
        }
        try {
            return this.getLyrics(deezerTackId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AudioLyrics getLyrics(String id) throws IOException {
        JsonBrowser json2 = this.getJson("https://www.deezer.com/ajax/gw-light.php?method=song.getLyrics&api_version=1.0&api_token=" + this.getTokens().api + "&sng_id=" + id);
        if (json2 == null || json2.get("results").values().isEmpty()) {
            return null;
        }
        JsonBrowser results = json2.get("results");
        String lyricsText = results.get("LYRICS_TEXT").text();
        ArrayList<AudioLyrics.Line> lyrics = new ArrayList<AudioLyrics.Line>();
        for (JsonBrowser line : results.get("LYRICS_SYNC_JSON").values()) {
            lyrics.add(new BasicAudioLyrics.BasicLine(Duration.ofMillis(line.get("milliseconds").asLong(0L)), Duration.ofMillis(line.get("duration").asLong(0L)), line.get("line").text()));
        }
        return new BasicAudioLyrics("deezer", "LyricFind", lyricsText, lyrics);
    }

    @Override
    @Nullable
    public AudioSearchResult loadSearch(@NotNull String query, @NotNull Set<AudioSearchResult.Type> types) {
        try {
            if (query.startsWith(SEARCH_PREFIX)) {
                return this.getAutocomplete(query.substring(SEARCH_PREFIX.length()), types);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String identifier = reference.identifier;
        boolean preview = reference.identifier.startsWith(PREVIEW_PREFIX);
        return this.loadItem(preview ? identifier.substring(PREVIEW_PREFIX.length()) : identifier, preview);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioItem loadItem(String identifier, boolean preview) {
        try {
            if (identifier.startsWith(SEARCH_PREFIX)) {
                return this.getSearch(identifier.substring(SEARCH_PREFIX.length()), preview);
            }
            if (identifier.startsWith(ISRC_PREFIX)) {
                return this.getTrackByISRC(identifier.substring(ISRC_PREFIX.length()), preview);
            }
            if (identifier.startsWith(SHARE_URL)) {
                HttpGet request = new HttpGet(identifier);
                request.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
                try (CloseableHttpResponse response = this.httpInterfaceManager.getInterface().execute((HttpUriRequest)request);){
                    String location;
                    if (response.getStatusLine().getStatusCode() == 302 && (location = response.getFirstHeader("Location").getValue()).startsWith("https://www.deezer.com/")) {
                        AudioItem audioItem = this.loadItem(location, preview);
                        return audioItem;
                    }
                    AudioItem audioItem = null;
                    return audioItem;
                }
            }
            Matcher matcher = URL_PATTERN.matcher(identifier);
            if (!matcher.find()) {
                return null;
            }
            String id = matcher.group("identifier");
            switch (matcher.group("type")) {
                case "album": {
                    return this.getAlbum(id, preview);
                }
                case "track": {
                    return this.getTrack(id, preview);
                }
                case "playlist": {
                    return this.getPlaylist(id, preview);
                }
                case "artist": {
                    return this.getArtist(id, preview);
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonBrowser getJson(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.setHeader("Accept", "application/json");
        return LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
    }

    private List<AudioTrack> parseTracks(JsonBrowser json2, boolean preview) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser track : json2.get("data").values()) {
            if (!track.get("type").text().equals("track")) continue;
            if (!((Boolean)track.get("readable").as(Boolean.class)).booleanValue()) {
                log.warn("Skipping track {} by {} because it is not readable. Available countries: {}", new Object[]{track.get("title").text(), track.get("artist").get("name").text(), track.get("available_countries").text()});
                continue;
            }
            tracks.add(this.parseTrack(track, preview));
        }
        return tracks;
    }

    private AudioTrack parseTrack(JsonBrowser json2, boolean preview) {
        if (!((Boolean)json2.get("readable").as(Boolean.class)).booleanValue()) {
            throw new FriendlyException("This track is not readable. Available countries: " + json2.get("available_countries").text(), FriendlyException.Severity.COMMON, null);
        }
        String id = json2.get("id").text();
        return new DeezerAudioTrack(new AudioTrackInfo(json2.get("title").text(), json2.get("artist").get("name").text(), preview ? 30000L : json2.get("duration").asLong(0L) * 1000L, id, false, "https://deezer.com/track/" + id, json2.get("album").get("cover_xl").text(), json2.get("isrc").text()), json2.get("album").get("title").text(), "https://www.deezer.com/album/" + json2.get("album").get("id").text(), "https://www.deezer.com/artist/" + json2.get("artist").get("id").text(), json2.get("artist").get("picture_xl").text(), json2.get("preview").text(), preview, this);
    }

    private AudioSearchResult getAutocomplete(String query, Set<AudioSearchResult.Type> types) throws IOException {
        JsonBrowser json2;
        if (types.isEmpty()) {
            types = SEARCH_TYPES;
        }
        if ((json2 = this.getJson("https://api.deezer.com/2.0/search/autocomplete?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8))) == null) {
            return AudioSearchResult.EMPTY;
        }
        ArrayList<AudioPlaylist> albums = new ArrayList<AudioPlaylist>();
        if (types.contains((Object)AudioSearchResult.Type.ALBUM)) {
            for (Object album : json2.get("albums").get("data").values()) {
                albums.add((AudioPlaylist)new DeezerAudioPlaylist(album.get("title").text(), Collections.emptyList(), ExtendedAudioPlaylist.Type.ALBUM, album.get("link").text(), album.get("cover_xl").text(), album.get("artist").get("name").text(), (int)album.get("nb_tracks").asLong(0L)));
            }
        }
        ArrayList<AudioPlaylist> artists = new ArrayList<AudioPlaylist>();
        if (types.contains((Object)AudioSearchResult.Type.ARTIST)) {
            for (Object artist : json2.get("artists").get("data").values()) {
                artists.add((AudioPlaylist)new DeezerAudioPlaylist(artist.get("name").text() + "'s Top Tracks", Collections.emptyList(), ExtendedAudioPlaylist.Type.ARTIST, artist.get("link").text(), artist.get("picture_xl").text(), artist.get("name").text(), null));
            }
        }
        ArrayList<AudioPlaylist> playlists = new ArrayList<AudioPlaylist>();
        if (types.contains((Object)AudioSearchResult.Type.PLAYLIST)) {
            for (JsonBrowser playlist : json2.get("playlists").get("data").values()) {
                playlists.add((AudioPlaylist)new DeezerAudioPlaylist(playlist.get("title").text(), Collections.emptyList(), ExtendedAudioPlaylist.Type.PLAYLIST, playlist.get("link").text(), playlist.get("picture_xl").text(), playlist.get("creator").get("name").text(), (int)playlist.get("nb_tracks").asLong(0L)));
            }
        }
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        if (types.contains((Object)AudioSearchResult.Type.TRACK)) {
            tracks.addAll(this.parseTracks(json2.get("tracks"), false));
        }
        return new BasicAudioSearchResult(tracks, albums, artists, playlists, new ArrayList<AudioText>());
    }

    private AudioItem getTrackByISRC(String isrc, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/track/isrc:" + URLEncoder.encode(isrc, StandardCharsets.UTF_8));
        if (json2 == null || json2.get("id").isNull()) {
            return AudioReference.NO_TRACK;
        }
        return this.parseTrack(json2, preview);
    }

    private AudioItem getSearch(String query, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/search?q=" + URLEncoder.encode(query, StandardCharsets.UTF_8));
        if (json2 == null || json2.get("data").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Deezer Search: " + query, this.parseTracks(json2, preview), null, true);
    }

    private AudioItem getAlbum(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/album/" + id);
        if (json2 == null || json2.get("tracks").get("data").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String artworkUrl = json2.get("cover_xl").text();
        String author = ((JsonBrowser)json2.get("contributors").values().get(0)).get("name").text();
        JsonBrowser tracks = this.getJson("https://api.deezer.com/2.0/album/" + id + "/tracks?limit=10000");
        for (JsonBrowser track : tracks.get("data").values()) {
            track.get("artist").put("picture_xl", (Object)json2.get("artist").get("picture_xl"));
        }
        return new DeezerAudioPlaylist(json2.get("title").text(), this.parseTracks(tracks, preview), ExtendedAudioPlaylist.Type.ALBUM, json2.get("link").text(), artworkUrl, author, (int)json2.get("nb_tracks").asLong(0L));
    }

    private AudioItem getTrack(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/track/" + id);
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        return this.parseTrack(json2, preview);
    }

    private AudioItem getPlaylist(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/playlist/" + id);
        if (json2 == null || json2.get("tracks").get("data").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String artworkUrl = json2.get("picture_xl").text();
        String author = json2.get("creator").get("name").text();
        JsonBrowser tracks = this.getJson("https://api.deezer.com/2.0/playlist/" + id + "/tracks?limit=10000");
        return new DeezerAudioPlaylist(json2.get("title").text(), this.parseTracks(tracks, preview), ExtendedAudioPlaylist.Type.PLAYLIST, json2.get("link").text(), artworkUrl, author, (int)json2.get("nb_tracks").asLong(0L));
    }

    private AudioItem getArtist(String id, boolean preview) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.deezer.com/2.0/artist/" + id);
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser tracksJson = this.getJson("https://api.deezer.com/2.0/artist/" + id + "/top?limit=50");
        if (tracksJson == null || tracksJson.get("data").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        for (JsonBrowser track : tracksJson.get("data").values()) {
            track.get("artist").put("picture_xl", (Object)json2.get("picture_xl"));
        }
        String artworkUrl = json2.get("picture_xl").text();
        String author = json2.get("name").text();
        List<AudioTrack> deezerTracks = this.parseTracks(tracksJson, preview);
        return new DeezerAudioPlaylist(author + "'s Top Tracks", deezerTracks, ExtendedAudioPlaylist.Type.ARTIST, json2.get("link").text(), artworkUrl, author, deezerTracks.size());
    }

    @Override
    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            log.error("Failed to close HTTP interface manager", (Throwable)e);
        }
    }

    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    public String getMasterDecryptionKey() {
        return this.masterDecryptionKey;
    }

    @Nullable
    public String getArl() {
        return this.arl;
    }

    public DeezerAudioTrack.TrackFormat[] getFormats() {
        return this.formats;
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    public static class Tokens {
        public String api;
        public String license;
        public Instant expireAt;

        public Tokens(String api, String license, Instant expireAt) {
            this.api = api;
            this.license = license;
            this.expireAt = expireAt;
        }
    }
}

