/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.mirror;

import com.github.topi314.lavasrc.ExtendedAudioTrack;
import com.github.topi314.lavasrc.mirror.MirroringAudioSourceManager;
import com.github.topi314.lavasrc.mirror.TrackNotFoundException;
import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MirroringAudioTrack
extends ExtendedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(MirroringAudioTrack.class);
    protected final MirroringAudioSourceManager sourceManager;

    public MirroringAudioTrack(AudioTrackInfo trackInfo, String albumName, String albumUrl, String artistUrl, String artistArtworkUrl, String previewUrl, boolean isPreview, MirroringAudioSourceManager sourceManager) {
        super(trackInfo, albumName, albumUrl, artistUrl, artistArtworkUrl, previewUrl, isPreview);
        this.sourceManager = sourceManager;
    }

    protected abstract InternalAudioTrack createAudioTrack(AudioTrackInfo var1, SeekableInputStream var2);

    public void process(LocalAudioTrackExecutor executor) throws Exception {
        if (this.isPreview) {
            if (this.previewUrl == null) {
                throw new FriendlyException("No preview url found", FriendlyException.Severity.COMMON, (Throwable)new IllegalArgumentException());
            }
            try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();
                 PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(this.previewUrl), Long.valueOf(this.trackInfo.length));){
                this.processDelegate(this.createAudioTrack(this.trackInfo, (SeekableInputStream)stream), executor);
            }
            return;
        }
        AudioItem track = (AudioItem)this.sourceManager.getResolver().apply(this);
        if (track instanceof AudioPlaylist) {
            List tracks = ((AudioPlaylist)track).getTracks();
            if (tracks.isEmpty()) {
                throw new TrackNotFoundException("No tracks found in playlist or search result for track");
            }
            track = (AudioItem)tracks.get(0);
        }
        if (track instanceof InternalAudioTrack) {
            InternalAudioTrack internalTrack = (InternalAudioTrack)track;
            log.debug("Loaded track mirror from {} {}({}) ", new Object[]{internalTrack.getSourceManager().getSourceName(), internalTrack.getInfo().title, internalTrack.getInfo().uri});
            this.processDelegate(internalTrack, executor);
            return;
        }
        throw new TrackNotFoundException("No mirror found for track");
    }

    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    public AudioItem loadItem(final String query) {
        final CompletableFuture cf = new CompletableFuture();
        this.sourceManager.getAudioPlayerManager().loadItem(query, new AudioLoadResultHandler(){

            public void trackLoaded(AudioTrack track) {
                log.debug("Track loaded: " + track.getIdentifier());
                cf.complete(track);
            }

            public void playlistLoaded(AudioPlaylist playlist) {
                log.debug("Playlist loaded: " + playlist.getName());
                cf.complete(playlist);
            }

            public void noMatches() {
                log.debug("No matches found for: " + query);
                cf.complete(AudioReference.NO_TRACK);
            }

            public void loadFailed(FriendlyException exception) {
                log.debug("Failed to load: " + query);
                cf.completeExceptionally((Throwable)exception);
            }
        });
        return (AudioItem)cf.join();
    }
}

