/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavalyrics;

import com.github.topi314.lavalyrics.AudioLyricsManager;
import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class LyricsManager {
    private final List<AudioLyricsManager> lyricsManagers = new ArrayList<AudioLyricsManager>();

    public void registerLyricsManager(AudioLyricsManager lyricsManager) {
        this.lyricsManagers.add(lyricsManager);
    }

    public void sortLyricsManagers(List<String> lyricsManagers) {
        this.lyricsManagers.sort(Comparator.comparing(audioLyricsManager -> lyricsManagers.contains(audioLyricsManager.getSourceName())));
    }

    @Nullable
    public <T extends AudioLyricsManager> T lyrics(Class<T> klass) {
        for (AudioLyricsManager lyricsManager : this.lyricsManagers) {
            if (!klass.isAssignableFrom(lyricsManager.getClass())) continue;
            return (T)((AudioLyricsManager)klass.cast(lyricsManager));
        }
        return null;
    }

    public List<AudioLyricsManager> getLyricsManagers() {
        return Collections.unmodifiableList(this.lyricsManagers);
    }

    public void shutdown() {
        for (AudioLyricsManager lyricsManager : this.lyricsManagers) {
            lyricsManager.shutdown();
        }
    }

    @Nullable
    public AudioLyrics loadLyrics(AudioTrack track) {
        return this.loadLyrics(track, false);
    }

    @Nullable
    public AudioLyrics loadLyrics(AudioTrack track, boolean skipTrackSource) {
        AudioLyrics lyrics;
        AudioSourceManager trackLyricsManager;
        if (this.lyricsManagers.isEmpty()) {
            throw new IllegalStateException("No lyrics managers registered");
        }
        if (!skipTrackSource && (trackLyricsManager = track.getSourceManager()) instanceof AudioLyricsManager && (lyrics = ((AudioLyricsManager)trackLyricsManager).loadLyrics(track)) != null) {
            return lyrics;
        }
        for (AudioLyricsManager lyricsManager : this.lyricsManagers) {
            AudioLyrics lyrics2 = lyricsManager.loadLyrics(track);
            if (lyrics2 == null) continue;
            return lyrics2;
        }
        return null;
    }
}

