/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.spotify;

import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.spotify.SpotifySourceManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotifyTokenTracker {
    private static final Logger log = LoggerFactory.getLogger(SpotifyTokenTracker.class);
    private final SpotifySourceManager sourceManager;
    private final String clientId;
    private final String clientSecret;
    private String accessToken;
    private Instant expires;

    public SpotifyTokenTracker(SpotifySourceManager source, String clientId, String clientSecret) {
        this.sourceManager = source;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        if (!this.hasValidCredentials()) {
            log.info("Missing/invalid credentials, falling back to public token.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken() {
        if (this.accessToken == null || this.expires == null || this.expires.isBefore(Instant.now())) {
            SpotifyTokenTracker spotifyTokenTracker = this;
            synchronized (spotifyTokenTracker) {
                if (this.accessToken == null || this.expires == null || this.expires.isBefore(Instant.now())) {
                    this.refreshAccessToken();
                }
            }
        }
        return this.accessToken;
    }

    private void refreshAccessToken() {
        HttpPost request;
        boolean usePublicToken;
        boolean bl = usePublicToken = !this.hasValidCredentials();
        if (!usePublicToken) {
            request = new HttpPost("https://accounts.spotify.com/api/token");
            request.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes(StandardCharsets.UTF_8)));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(List.of(new BasicNameValuePair("grant_type", "client_credentials")), StandardCharsets.UTF_8));
        } else {
            request = new HttpGet("https://open.spotify.com/get_access_token");
        }
        try {
            JsonBrowser json2 = LavaSrcTools.fetchResponseAsJson(this.sourceManager.getHttpInterface(), (HttpUriRequest)request);
            if (!json2.get("error").isNull()) {
                String error = json2.get("error").text();
                throw new RuntimeException(error);
            }
            if (!usePublicToken) {
                this.accessToken = json2.get("access_token").text();
                this.expires = Instant.now().plusSeconds(json2.get("expires_in").asLong(0L));
            } else {
                this.accessToken = json2.get("accessToken").text();
                this.expires = Instant.ofEpochMilli(json2.get("accessTokenExpirationTimestampMs").asLong(0L));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Access token refreshing failed", e);
        }
    }

    private boolean hasValidCredentials() {
        return this.clientId != null && !this.clientId.isEmpty() && this.clientSecret != null && !this.clientSecret.isEmpty();
    }
}

