/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.vkmusic;

import com.github.topi314.lavalyrics.AudioLyricsManager;
import com.github.topi314.lavalyrics.lyrics.AudioLyrics;
import com.github.topi314.lavalyrics.lyrics.BasicAudioLyrics;
import com.github.topi314.lavasearch.AudioSearchManager;
import com.github.topi314.lavasearch.result.AudioSearchResult;
import com.github.topi314.lavasearch.result.AudioText;
import com.github.topi314.lavasearch.result.BasicAudioSearchResult;
import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.ExtendedAudioSourceManager;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.vkmusic.VkMusicAudioPlaylist;
import com.github.topi314.lavasrc.vkmusic.VkMusicAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VkMusicSourceManager
extends ExtendedAudioSourceManager
implements HttpConfigurable,
AudioLyricsManager,
AudioSearchManager {
    private static final Pattern VK_PLAYLIST_HEADER_REGEX = Pattern.compile("(https?://)?(?:www\\.)?vk\\.(?:com|ru)/audios\\d+\\?q=[^&]+&z=audio_playlist(?<owner>-?[A-Za-z\\d]+)_(?<id>-?[A-Za-z\\d]+)(?<accessKey>_([^/?#]*))?(?:[/?#].*)?");
    private static final Pattern VK_PLAYLIST_TYPE_REGEX = Pattern.compile("(https?://)?(?:www\\.)?vk\\.(?:com|ru)/music/(playlist|album)/(?<owner>-?[A-Za-z\\d]+)_(?<id>-?[A-Za-z\\d]+)(?<accessKey>_([^/?#]*))?(?:[/?#].*)?");
    private static final Pattern VK_TRACK_REGEX = Pattern.compile("(https?://)?(?:www\\.)?vk\\.(?:com|ru)/audio(?<id>-?\\d+)_(?<artistId>-?\\d+)(?<accessKey>_([^/?#]*))?(?:[/?#].*)?");
    private static final Pattern VK_ARTIST_REGEX = Pattern.compile("(https?://)?(?:www\\.)?vk\\.(?:com|ru)/artist/(?<artistId>[^/?#]+)");
    public static final String SEARCH_PREFIX = "vksearch:";
    public static final String RECOMMENDATIONS_PREFIX = "vkrec:";
    public static final String PUBLIC_API_BASE = "https://api.vk.com/method/";
    public static final String API_VERSION = "5.199";
    public static final Set<AudioSearchResult.Type> SEARCH_TYPES = Set.of(AudioSearchResult.Type.TRACK, AudioSearchResult.Type.ALBUM, AudioSearchResult.Type.PLAYLIST, AudioSearchResult.Type.ARTIST);
    private static final Logger log = LoggerFactory.getLogger(VkMusicSourceManager.class);
    private final HttpInterfaceManager httpInterfaceManager;
    private String userToken;
    private int artistLoadLimit;
    private int playlistLoadLimit;
    private int recommendationsLoadLimit;

    public VkMusicSourceManager(String userToken) {
        if (userToken == null || userToken.isEmpty()) {
            throw new IllegalArgumentException("Vk Music user token must be set");
        }
        this.userToken = userToken;
        this.httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    }

    public void setUserToken(String userToken) {
        if (userToken == null || userToken.isEmpty()) {
            throw new IllegalArgumentException("Vk Music user token must be set");
        }
        this.userToken = userToken;
    }

    public void setArtistLoadLimit(int artistLimit) {
        this.artistLoadLimit = artistLimit;
    }

    public void setPlaylistLoadLimit(int playlistLimit) {
        this.playlistLoadLimit = playlistLimit;
    }

    public void setRecommendationsLoadLimit(int recommendationsLimit) {
        this.recommendationsLoadLimit = recommendationsLimit;
    }

    @Override
    @NotNull
    public String getSourceName() {
        return "vkmusic";
    }

    @Override
    @Nullable
    public AudioSearchResult loadSearch(@NotNull String query, @NotNull Set<AudioSearchResult.Type> types) {
        if (types.isEmpty()) {
            types = SEARCH_TYPES;
        }
        if (query.startsWith(SEARCH_PREFIX)) {
            try {
                return this.getSearchResult(query.substring(SEARCH_PREFIX.length()), types);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private AudioSearchResult getSearchResult(@NotNull String query, @NotNull Set<AudioSearchResult.Type> types) throws IOException {
        JsonBrowser artistResponse;
        JsonBrowser playlistResponse;
        ArrayList<AudioPlaylist> albums = new ArrayList<AudioPlaylist>();
        ArrayList<AudioPlaylist> artists = new ArrayList<AudioPlaylist>();
        ArrayList<AudioPlaylist> playlists = new ArrayList<AudioPlaylist>();
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        if (types.contains((Object)AudioSearchResult.Type.ALBUM) && (playlistResponse = this.getJson("audio.searchAlbums", "&q=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&count=20")) != null && !playlistResponse.get("response").isNull() && !playlistResponse.get("response").get("items").values().isEmpty()) {
            albums.addAll(this.parsePlaylistSearch(playlistResponse.get("response").get("items").values(), ExtendedAudioPlaylist.Type.ALBUM));
        }
        if (types.contains((Object)AudioSearchResult.Type.ARTIST) && (artistResponse = this.getJson("audio.searchArtists", "&q=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&count=20")) != null && !artistResponse.get("response").isNull() && !artistResponse.get("response").get("items").values().isEmpty()) {
            for (JsonBrowser artist : artistResponse.get("response").get("items").values()) {
                String artworkUrl = null;
                if (!artist.get("photo").values().isEmpty()) {
                    artworkUrl = artist.get("photo").values().stream().max(Comparator.comparingLong(item -> item.get("width").asLong(0L))).map(item -> item.get("url").text()).orElse(null);
                }
                artists.add((AudioPlaylist)new VkMusicAudioPlaylist(artist.get("name").text() + "'s Top Tracks", Collections.emptyList(), ExtendedAudioPlaylist.Type.ARTIST, "https://vk.com/artist/" + artist.get("domain").text(), artworkUrl, artist.get("name").text(), 0));
            }
        }
        if (types.contains((Object)AudioSearchResult.Type.PLAYLIST) && (playlistResponse = this.getJson("audio.searchPlaylists", "&q=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&count=20")) != null && !playlistResponse.get("response").isNull() && !playlistResponse.get("response").get("items").values().isEmpty()) {
            playlists.addAll(this.parsePlaylistSearch(playlistResponse.get("response").get("items").values(), ExtendedAudioPlaylist.Type.PLAYLIST));
        }
        if (types.contains((Object)AudioSearchResult.Type.TRACK)) {
            tracks.addAll(((BasicAudioPlaylist)this.getSearch(query)).getTracks());
        }
        return new BasicAudioSearchResult(tracks, albums, artists, playlists, new ArrayList<AudioText>());
    }

    private List<VkMusicAudioPlaylist> parsePlaylistSearch(List<JsonBrowser> playlistItems, ExtendedAudioPlaylist.Type type) {
        return playlistItems.stream().map(playlistItem -> new VkMusicAudioPlaylist(playlistItem.get("title").text(), Collections.emptyList(), type, "https://vk.com/music/" + (type == ExtendedAudioPlaylist.Type.PLAYLIST ? "playlist" : "album") + "/" + playlistItem.get("owner_id").text() + "_" + playlistItem.get("id").text() + (String)(playlistItem.get("access_key").isNull() ? "" : "_" + playlistItem.get("access_key").text()), this.parsePlaylistThumbnail((JsonBrowser)playlistItem), this.parseAlbumAuthor((JsonBrowser)playlistItem), (Integer)playlistItem.get("count").as(Integer.class))).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public AudioLyrics loadLyrics(@NotNull AudioTrack track) {
        if (track.getSourceManager() instanceof VkMusicSourceManager) {
            try {
                JsonBrowser json2 = this.getJson("audio.getLyrics", "&audio_id=" + track.getIdentifier());
                if (!json2.get("error").isNull() || !json2.get("response").isNull() && !json2.get("response").get("lyrics").isNull()) {
                    return null;
                }
                if (!json2.get("response").get("lyrics").get("timestamps").values().isEmpty()) {
                    return this.parseTimestampsLyrics(json2.get("response").get("lyrics").get("timestamps").values());
                }
                if (!json2.get("response").get("lyrics").get("text").values().isEmpty()) {
                    return this.parseTextLyrics(json2.get("response").get("lyrics").get("text").values());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private BasicAudioLyrics parseTimestampsLyrics(@NotNull List<JsonBrowser> lines) {
        ArrayList<AudioLyrics.Line> strokes = new ArrayList<AudioLyrics.Line>();
        String text = lines.stream().map(line -> {
            strokes.add(new BasicAudioLyrics.BasicLine(Duration.ofMillis((Long)line.get("begin").as(Long.class)), Duration.ofMillis((Long)line.get("end").as(Long.class) - (Long)line.get("begin").as(Long.class)), line.get("line").text()));
            return line.get("line").text();
        }).collect(Collectors.joining(" "));
        return new BasicAudioLyrics(this.getSourceName(), "LyricFind", text, strokes);
    }

    private BasicAudioLyrics parseTextLyrics(@NotNull List<JsonBrowser> lines) {
        ArrayList<AudioLyrics.Line> strokes = new ArrayList<AudioLyrics.Line>();
        String text = lines.stream().filter(line -> !line.text().isEmpty()).map(line -> {
            strokes.add(new BasicAudioLyrics.BasicLine(Duration.ZERO, Duration.ZERO, line.text()));
            return line.text();
        }).collect(Collectors.joining(" "));
        return new BasicAudioLyrics(this.getSourceName(), "LyricFind", text, strokes);
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        try {
            if (reference.identifier.startsWith(SEARCH_PREFIX)) {
                return this.getSearch(reference.identifier.substring(SEARCH_PREFIX.length()));
            }
            if (reference.identifier.startsWith(RECOMMENDATIONS_PREFIX)) {
                return this.getRecommendations(reference.identifier.substring(RECOMMENDATIONS_PREFIX.length()));
            }
            String uri = reference.identifier;
            Matcher playlistFromHeader = VK_PLAYLIST_HEADER_REGEX.matcher(uri);
            if (playlistFromHeader.find() && playlistFromHeader.group("owner") != null && playlistFromHeader.group("id") != null) {
                return this.getPlaylist(playlistFromHeader.group("owner"), playlistFromHeader.group("id"), playlistFromHeader.group("accessKey"));
            }
            Matcher playlistMatcher = VK_PLAYLIST_TYPE_REGEX.matcher(uri);
            if (playlistMatcher.find() && playlistMatcher.group("owner") != null && playlistMatcher.group("id") != null) {
                return this.getPlaylist(playlistMatcher.group("owner"), playlistMatcher.group("id"), playlistMatcher.group("accessKey"));
            }
            Matcher trackMatcher = VK_TRACK_REGEX.matcher(uri);
            if (trackMatcher.find() && trackMatcher.group("id") != null && trackMatcher.group("artistId") != null) {
                return this.getTrack(trackMatcher.group("id") + "_" + trackMatcher.group("artistId"));
            }
            Matcher artistMatcher = VK_ARTIST_REGEX.matcher(uri);
            if (artistMatcher.find()) {
                return this.getArtist(artistMatcher.group("artistId"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private AudioItem getRecommendations(String audioId) throws IOException {
        JsonBrowser json2 = this.getJson("audio.getRecommendations", "&target_audio=" + audioId + "&count=" + this.recommendationsLoadLimit);
        if (json2.isNull() || json2.get("response").isNull()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("response").get("items"));
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new VkMusicAudioPlaylist("Vk Music Recommendations", tracks, ExtendedAudioPlaylist.Type.RECOMMENDATIONS, null, null, null, tracks.size());
    }

    private AudioItem getSearch(String query) throws IOException {
        JsonBrowser json2 = this.getJson("audio.search", "&q=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&sort=2");
        if (json2.isNull() || json2.get("response").isNull()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("response").get("items"));
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Vk Music Search: " + query, tracks, null, true);
    }

    private AudioItem getPlaylist(String owner_id, String playlist_id, String accessKey) throws IOException {
        JsonBrowser json2;
        String query = "&owner_id=" + owner_id;
        if (accessKey != null) {
            query = query + "&access_key=" + accessKey;
        }
        if ((json2 = this.getJson("audio.get", query + "&album_id=" + playlist_id + "&count=" + this.playlistLoadLimit * 50)).isNull() || json2.get("response").isNull() || json2.get("response").get("items").isNull() || json2.get("response").get("items").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("response").get("items"));
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String coverUri = null;
        String title = null;
        JsonBrowser playlistJson = this.getJson("audio.getPlaylistById", query + "&playlist_id=" + playlist_id).get("response");
        if (!playlistJson.isNull()) {
            coverUri = this.parsePlaylistThumbnail(playlistJson);
            if (!playlistJson.get("title").isNull()) {
                title = playlistJson.get("title").text();
            }
        }
        boolean type = (Long)playlistJson.get("type").as(Long.class) == 1L;
        return new VkMusicAudioPlaylist(title, tracks, type ? ExtendedAudioPlaylist.Type.ALBUM : ExtendedAudioPlaylist.Type.PLAYLIST, "https://vk.com/music/" + (type ? "album" : "playlist") + "/" + owner_id + "_" + playlist_id + (String)(playlistJson.get("access_key").isNull() ? "" : "_" + playlistJson.get("access_key").text()), coverUri, this.parseAlbumAuthor(playlistJson), tracks.size());
    }

    private String parseAlbumAuthor(JsonBrowser json2) {
        if (!json2.get("main_artists").values().isEmpty()) {
            return json2.get("main_artists").values().stream().map(node -> node.get("name").text()).collect(Collectors.joining(", "));
        }
        return null;
    }

    private String parsePlaylistThumbnail(JsonBrowser json2) {
        if (!json2.get("photo").isNull()) {
            return json2.get("photo").get("photo_600").text();
        }
        if (!json2.get("thumbs").isNull()) {
            return ((JsonBrowser)json2.get("thumbs").values().get(0)).get("photo_600").text();
        }
        return null;
    }

    private AudioItem getTrack(String id) throws IOException {
        JsonBrowser json2 = this.getJson("audio.getById", "&audios=" + id);
        if (json2.isNull() || json2.get("response").isNull()) {
            return AudioReference.NO_TRACK;
        }
        return this.parseTrack((JsonBrowser)json2.get("response").values().get(0));
    }

    private AudioItem getArtist(String id) throws IOException {
        JsonBrowser json2 = this.getJson("audio.getAudiosByArtist", "&artist_id=" + id + "&count" + this.artistLoadLimit * 20);
        if (json2.isNull() || json2.get("response").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("response").get("items"));
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser artistJson = this.getJson("audio.getArtistById", "&artist_id=" + id).get("response");
        if (artistJson.isNull()) {
            return AudioReference.NO_TRACK;
        }
        String author = artistJson.get("name").text();
        return new VkMusicAudioPlaylist(author + "'s Top Tracks", tracks, ExtendedAudioPlaylist.Type.ARTIST, "https://vk.com/artist/" + artistJson.get("domain").text(), null, author, tracks.size());
    }

    public JsonBrowser getJson(String method, String headers) throws IOException {
        String uri = PUBLIC_API_BASE + method + "?v=5.199" + headers + "&access_token=" + this.userToken;
        HttpGet request = new HttpGet(uri);
        request.setHeader("Content-Type", "application/json");
        return LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
    }

    private List<AudioTrack> parseTracks(JsonBrowser json2) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser track : json2.values()) {
            AudioTrack trackInfo = this.parseTrack(track);
            if (trackInfo == null) continue;
            tracks.add(trackInfo);
        }
        return tracks;
    }

    private AudioTrack parseTrack(JsonBrowser json2) {
        try {
            if (json2.get("url").isNull()) {
                return null;
            }
            String coverUri = null;
            if (!json2.get("album").isNull() && !json2.get("album").get("thumb").isNull()) {
                coverUri = json2.get("album").get("thumb").get("photo_600").text();
            }
            String albumTitle = null;
            String albumUrl = null;
            if (!json2.get("album").isNull()) {
                albumTitle = json2.get("album").get("title").text();
                albumUrl = "https://vk.com/music/album/" + json2.get("album").get("owner_id").text() + "_" + json2.get("album").get("id").text();
            }
            String artistUrl = null;
            if (!(json2.get("main_artists").isNull() || json2.get("main_artists").values().isEmpty() || ((JsonBrowser)json2.get("main_artists").values().get(0)).get("domain").isNull())) {
                artistUrl = "https://vk.com/artist/" + ((JsonBrowser)json2.get("main_artists").values().get(0)).get("domain").text();
            }
            String audioId = json2.get("owner_id").text() + "_" + json2.get("id").text();
            return new VkMusicAudioTrack(new AudioTrackInfo(json2.get("title").text(), json2.get("artist").text(), (Long)json2.get("duration").as(Long.class) * 1000L, audioId, false, "https://vk.com/audio" + audioId, coverUri, null), albumTitle, albumUrl, artistUrl, null, json2.get("url").text(), this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        ExtendedAudioSourceManager.ExtendedAudioTrackInfo extendedAudioTrackInfo = super.decodeTrack(input);
        return new VkMusicAudioTrack(trackInfo, extendedAudioTrackInfo.albumName, extendedAudioTrackInfo.albumUrl, extendedAudioTrackInfo.artistUrl, extendedAudioTrackInfo.artistArtworkUrl, extendedAudioTrackInfo.previewUrl, this);
    }

    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    @Override
    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            log.error("Failed to close HTTP interface manager", (Throwable)e);
        }
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }
}

