/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.deezer;

import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.deezer.DeezerAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;

public class DeezerTokenTracker {
    private final DeezerAudioSourceManager sourceManager;
    private String arl;
    private Tokens tokens;

    public DeezerTokenTracker(DeezerAudioSourceManager sourceManager, String arl) {
        this.sourceManager = sourceManager;
        if (arl == null || arl.isEmpty()) {
            throw new NullPointerException("Deezer arl must be set");
        }
        this.arl = arl;
    }

    public String getArl() {
        return this.arl;
    }

    public void setArl(String arl) {
        if (arl == null || arl.isEmpty()) {
            throw new NullPointerException("Deezer arl must be set");
        }
        this.arl = arl;
    }

    private void refreshSession() throws IOException {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            BasicCookieStore cookieStore = new BasicCookieStore();
            httpInterface.getContext().setCookieStore((CookieStore)cookieStore);
            httpInterface.getContext().setRequestConfig(RequestConfig.copy((RequestConfig)httpInterface.getContext().getRequestConfig()).setCookieSpec("standard").build());
            HttpPost getUserToken = new HttpPost("https://www.deezer.com/ajax/gw-light.php?method=deezer.getUserData&input=3&api_version=1.0&api_token=");
            JsonBrowser json2 = LavaSrcTools.fetchResponseAsJson(httpInterface, (HttpUriRequest)getUserToken);
            DeezerAudioSourceManager.checkResponse(json2, "Failed to get user token");
            String sessionID = null;
            String dzrUniqId = null;
            for (Cookie cookie : cookieStore.getCookies()) {
                switch (cookie.getName()) {
                    case "sid": {
                        sessionID = cookie.getValue();
                        break;
                    }
                    case "dzr_uniq_id": {
                        dzrUniqId = cookie.getValue();
                    }
                }
            }
            if (sessionID == null) {
                throw new IOException("Failed to find sid cookie");
            }
            if (dzrUniqId == null) {
                throw new IOException("Failed to find dzr uniq id cookie");
            }
            this.tokens = new Tokens(sessionID, dzrUniqId, json2.get("results").get("checkForm").text(), json2.get("results").get("USER").get("OPTIONS").get("license_token").text(), Instant.now().plus(3600L, ChronoUnit.SECONDS));
        }
    }

    public Tokens getTokens() throws IOException {
        if (this.tokens == null || Instant.now().isAfter(this.tokens.expireAt)) {
            this.refreshSession();
        }
        return this.tokens;
    }

    public static class Tokens {
        public String sessionId;
        public String dzrUniqId;
        public String api;
        public String license;
        public Instant expireAt;

        public Tokens(String sessionId, String dzrUniqId, String api, String license, Instant expireAt) {
            this.sessionId = sessionId;
            this.dzrUniqId = dzrUniqId;
            this.api = api;
            this.license = license;
            this.expireAt = expireAt;
        }
    }
}

