/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.qobuz;

import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.ExtendedAudioSourceManager;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.qobuz.QobuzAudioTrack;
import com.github.topi314.lavasrc.qobuz.QobuzTokenTracker;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QobuzAudioSourceManager
extends ExtendedAudioSourceManager
implements HttpConfigurable {
    public static final String SEARCH_PREFIX = "qbsearch:";
    public static final String ISRC_PREFIX = "qbisrc:";
    public static final String RECOMMENDATIONS_PREFIX = "qbrec:";
    private static final Logger log = LoggerFactory.getLogger(QobuzAudioSourceManager.class);
    private static final String API_URL = "https://www.qobuz.com/api.json/0.2/";
    private static final Pattern URL_PATTERN = Pattern.compile("https?://(?:www\\.|play\\.|open\\.)?qobuz\\.com/(?:(?:[a-z]{2}-[a-z]{2}/)?(?<type>album|playlist|track|artist)/(?:.+?/)?(?<id>[a-zA-Z0-9]+)|(?<type2>playlist)/(?<id2>\\d+))");
    private static final int ALBUM_LOAD_LIMIT = 500;
    private static final int PLAYLIST_LOAD_LIMIT = 1000;
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private final QobuzTokenTracker tokenTracker;

    public QobuzAudioSourceManager(String userOauthToken, String appId, String appSecret) {
        this.tokenTracker = new QobuzTokenTracker(this, userOauthToken, appId, appSecret);
    }

    @NotNull
    public String getSourceName() {
        return "qobuz";
    }

    public String getAppSecret() {
        return this.tokenTracker.getAppSecret();
    }

    public void setAppSecret(String appSecret) {
        this.tokenTracker.setAppSecret(appSecret);
    }

    public void setUserOauthToken(String userOauthToken) {
        this.tokenTracker.setUserOauthToken(userOauthToken);
    }

    public void setAppId(String appId) {
        this.tokenTracker.setAppId(appId);
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        ExtendedAudioSourceManager.ExtendedAudioTrackInfo extendedAudioTrackInfo = super.decodeTrack(input);
        return new QobuzAudioTrack(trackInfo, extendedAudioTrackInfo.albumName, extendedAudioTrackInfo.albumUrl, extendedAudioTrackInfo.artistUrl, extendedAudioTrackInfo.artistArtworkUrl, this);
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String identifier = reference.identifier;
        try {
            if (identifier.startsWith(SEARCH_PREFIX)) {
                return this.getSearch(identifier.substring(SEARCH_PREFIX.length()));
            }
            if (identifier.startsWith(ISRC_PREFIX)) {
                return this.getTrackByISRC(identifier.substring(ISRC_PREFIX.length()));
            }
            if (identifier.startsWith(RECOMMENDATIONS_PREFIX)) {
                return this.getRecommendations(identifier.substring(RECOMMENDATIONS_PREFIX.length()));
            }
            Matcher matcher = URL_PATTERN.matcher(identifier);
            if (!matcher.find()) {
                return null;
            }
            String type = matcher.group("type");
            String id = matcher.group("id");
            if (type == null) {
                type = matcher.group("type2");
                id = matcher.group("id2");
            }
            switch (type) {
                case "playlist": {
                    return this.getPlaylist(id);
                }
                case "album": {
                    return this.getAlbum(id);
                }
                case "track": {
                    return this.getTrack(id);
                }
                case "artist": {
                    return this.getArtist(id);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public JsonBrowser getJson(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.setHeader("Accept", "application/json");
        request.setHeader("x-app-id", this.tokenTracker.getAppId());
        request.setHeader("x-user-auth-token", this.tokenTracker.getUserOauthToken());
        return LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
    }

    private List<AudioTrack> parseTracks(JsonBrowser json2) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser track : json2.values()) {
            tracks.add(this.parseTrack(track));
        }
        return tracks;
    }

    private AudioTrack parseTrack(JsonBrowser json2) {
        String artistUrl;
        String author;
        String identifier = json2.get("id").text();
        String title = json2.get("title").text();
        if (!json2.get("artist").isNull() && json2.get("artist").isMap()) {
            author = json2.get("artist").get("name").get("display").text();
            artistUrl = "https://open.qobuz.com/artist/" + json2.get("artist").get("id").text();
        } else {
            author = json2.get("album").get("artist").get("name").text();
            artistUrl = "https://open.qobuz.com/artist/" + json2.get("album").get("artist").get("id").text();
        }
        String artworkUrl = json2.get("album").get("image").get("large").isNull() ? null : json2.get("album").get("image").get("large").text();
        long length = json2.get("duration").asLong(0L) * 1000L;
        String uri = "https://open.qobuz.com/track/" + identifier;
        String albumName = json2.get("album").get("title").isNull() ? null : json2.get("album").get("title").text();
        String albumUrl = json2.get("album").get("id").isNull() ? null : "https://open.qobuz.com/album/" + json2.get("album").get("id").text();
        String artistArtworkUrl = null;
        if (!json2.get("album").get("artist").isNull() && !json2.get("album").get("artist").get("image").isNull()) {
            artistArtworkUrl = json2.get("album").get("artist").get("image").text();
        }
        String isrc = json2.get("isrc").text();
        AudioTrackInfo info = new AudioTrackInfo(title, author, length, identifier, false, uri, artworkUrl, isrc);
        return new QobuzAudioTrack(info, albumName, albumUrl, artistUrl, artistArtworkUrl, this);
    }

    private AudioItem getSearch(String query) throws IOException {
        JsonBrowser json2 = this.getJson("https://www.qobuz.com/api.json/0.2/catalog/search?query=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&limit=15&type=tracks");
        if (json2 == null || json2.get("tracks").isNull() || json2.get("tracks").get("items").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Qobuz Search: " + query, this.parseTracks(json2.get("tracks").get("items")), null, true);
    }

    private AudioItem getAlbum(String id) throws IOException {
        JsonBrowser json2 = this.getJson("https://www.qobuz.com/api.json/0.2/album/get?album_id=" + URLEncoder.encode(id, StandardCharsets.UTF_8) + "&limit=500&offset=0");
        if (json2 == null || json2.get("tracks").isNull() || json2.get("tracks").get("items").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String title = json2.get("title").text();
        String artworkUrl = json2.get("image").get("large").text();
        String author = json2.get("artist").get("name").text();
        String uri = "https://open.qobuz.com/album/" + id;
        JsonBrowser tracks = json2.get("tracks").get("items");
        json2.remove("tracks");
        ArrayList<AudioTrack> m = new ArrayList<AudioTrack>();
        for (JsonBrowser track : tracks.values()) {
            track.put("album", (Object)json2);
            m.add(this.parseTrack(track));
        }
        int trackCount = tracks.values().size();
        return new ExtendedAudioPlaylist(title, m, ExtendedAudioPlaylist.Type.ALBUM, uri, artworkUrl, author, trackCount);
    }

    private AudioItem getTrack(String id) throws IOException {
        JsonBrowser json2 = this.getJson("https://www.qobuz.com/api.json/0.2/track/get?track_id=" + URLEncoder.encode(id, StandardCharsets.UTF_8));
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        return this.parseTrack(json2);
    }

    private AudioItem getRecommendations(String id) throws IOException {
        JsonBrowser json2 = this.getJson("https://www.qobuz.com/api.json/0.2/track/get?track_id=" + URLEncoder.encode(id, StandardCharsets.UTF_8));
        if (json2 == null) {
            return AudioReference.NO_TRACK;
        }
        String artistId = json2.get("performer").get("id").text();
        String jsonPayload = "{\"limit\": 50,\"listened_tracks_ids\": [" + id + "],\"track_to_analysed\": [    {        \"track_id\": " + id + ",        \"artist_id\": " + artistId + "    }]}";
        HttpPost request = new HttpPost("https://www.qobuz.com/api.json/0.2/dynamic/suggest");
        request.setHeader("Accept", "application/json");
        request.setHeader("x-app-id", this.tokenTracker.getAppId());
        request.setHeader("x-user-auth-token", this.tokenTracker.getUserOauthToken());
        request.setEntity((HttpEntity)new StringEntity(jsonPayload, StandardCharsets.UTF_8));
        JsonBrowser recommendations = LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
        if (recommendations == null || recommendations.get("tracks").isNull() || recommendations.get("tracks").get("items").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(recommendations.get("tracks").get("items"));
        return new ExtendedAudioPlaylist("Qobuz Recommendations", tracks, ExtendedAudioPlaylist.Type.RECOMMENDATIONS, null, null, "Qobuz", tracks.size());
    }

    private AudioItem getTrackByISRC(String isrc) throws IOException {
        JsonBrowser json2 = this.getJson("https://www.qobuz.com/api.json/0.2/catalog/search?query=" + URLEncoder.encode(isrc, StandardCharsets.UTF_8) + "&limit=15&type=tracks");
        if (json2 == null || json2.get("tracks").isNull() || json2.get("tracks").get("items").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return this.parseTrack((JsonBrowser)json2.get("tracks").get("items").values().get(0));
    }

    private AudioItem getPlaylist(String id) throws IOException {
        JsonBrowser json2 = this.getJson("https://www.qobuz.com/api.json/0.2/playlist/get?playlist_id=" + URLEncoder.encode(id, StandardCharsets.UTF_8) + "&limit=1000&offset=0&extra=tracks");
        if (json2 == null || json2.get("tracks").isNull() || json2.get("tracks").get("items").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        String artworkUrl = null;
        if (!json2.get("images300").values().isEmpty()) {
            artworkUrl = ((JsonBrowser)json2.get("images300").values().get(0)).text();
        }
        String author = json2.get("owner").get("name").text();
        String title = json2.get("name").text();
        JsonBrowser tracks = json2.get("tracks").get("items");
        String url = json2.get("url").text();
        int trackCount = tracks != null ? tracks.values().size() : 0;
        return new ExtendedAudioPlaylist(title, this.parseTracks(tracks), ExtendedAudioPlaylist.Type.PLAYLIST, url, artworkUrl, author, trackCount);
    }

    private AudioItem getArtist(String id) throws IOException {
        JsonBrowser json2 = this.getJson("https://www.qobuz.com/api.json/0.2/artist/page?artist_id=" + URLEncoder.encode(id, StandardCharsets.UTF_8));
        if (json2 == null || json2.get("top_tracks").values().isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser tracksJson = json2.get("top_tracks");
        if (tracksJson.isNull()) {
            return AudioReference.NO_TRACK;
        }
        int trackCount = tracksJson.values().size();
        String artworkUrl = null;
        if (!json2.get("images").get("potrait").isNull() && !json2.get("images").get("potrait").get("hash").text().isEmpty()) {
            artworkUrl = "https://static.qobuz.com/images/artists/covers/large/" + json2.get("images").get("potrait").get("hash").text() + ".jpg";
        }
        String uri = "https://open.qobuz.com/artist/" + id;
        String author = json2.get("name").get("display").text();
        return new ExtendedAudioPlaylist(author + "'s Top Tracks", this.parseTracks(tracksJson), ExtendedAudioPlaylist.Type.ARTIST, uri, artworkUrl, author, trackCount);
    }

    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            log.error("Failed to close HTTP interface manager", (Throwable)e);
        }
    }

    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }
}

