/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.vkmusic;

import com.github.topi314.lavasrc.ExtendedAudioTrack;
import com.github.topi314.lavasrc.vkmusic.VkMusicSourceManager;
import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class VkMusicAudioTrack
extends ExtendedAudioTrack {
    private final VkMusicSourceManager sourceManager;

    public VkMusicAudioTrack(AudioTrackInfo trackInfo, VkMusicSourceManager sourceManager) {
        this(trackInfo, null, null, null, null, null, sourceManager);
    }

    public VkMusicAudioTrack(AudioTrackInfo trackInfo, String albumName, String albumUrl, String artistUrl, String artistArtworkUrl, String previewUrl, VkMusicSourceManager sourceManager) {
        super(trackInfo, albumName, albumUrl, artistUrl, artistArtworkUrl, previewUrl, false);
        this.sourceManager = sourceManager;
    }

    public void process(LocalAudioTrackExecutor executor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();
             PersistentHttpStream stream = new PersistentHttpStream(httpInterface, this.getMp3TrackUri(), Long.valueOf(this.trackInfo.length));){
            this.processDelegate((InternalAudioTrack)new Mp3AudioTrack(this.trackInfo, (SeekableInputStream)stream), executor);
        }
    }

    public URI getMp3TrackUri() throws URISyntaxException, IOException {
        String id = this.trackInfo.identifier;
        JsonBrowser json2 = this.sourceManager.getJson("audio.getById", "&audios=" + id).get("response");
        if (json2.isNull() || json2.values().isEmpty() || ((JsonBrowser)json2.values().get(0)).get("url").isNull()) {
            throw new IllegalStateException("No download url found for track " + id);
        }
        return new URI(((JsonBrowser)json2.values().get(0)).get("url").text());
    }

    protected AudioTrack makeShallowClone() {
        return new VkMusicAudioTrack(this.trackInfo, this.sourceManager);
    }

    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

