/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.qobuz;

import com.github.topi314.lavasrc.qobuz.QobuzAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QobuzTokenTracker {
    private static final Logger log = LoggerFactory.getLogger(QobuzTokenTracker.class);
    private static final Pattern BUNDLE_PATTERN = Pattern.compile("<script src=\"(?<bundleJS>/resources/\\d+\\.\\d+\\.\\d+-[a-z]\\d{3}/bundle\\.js)\"");
    private static final Pattern APP_ID_PATTERN = Pattern.compile("production:\\{api:\\{appId:\"(?<appID>.*?)\",appSecret:");
    private static final Pattern SEED_PATTERN = Pattern.compile("\\):[a-z]\\.initialSeed\\(\"(?<seed>.*?)\",window\\.utimezone\\.(?<timezone>[a-z]+)\\)");
    private static final String WEB_PLAYER_BASE_URL = "https://play.qobuz.com";
    private final QobuzAudioSourceManager sourceManager;
    private String appId;
    private String appSecret;
    private String userOauthToken;

    public QobuzTokenTracker(QobuzAudioSourceManager sourceManager, String userOauthToken, String appId, String appSecret) {
        this.sourceManager = sourceManager;
        if (userOauthToken == null || userOauthToken.isEmpty()) {
            throw new IllegalArgumentException("User Oauth token cannot be null or empty.");
        }
        this.userOauthToken = userOauthToken;
        if (appId == null || appId.isEmpty() || appSecret == null || appSecret.isEmpty()) {
            this.fetchAppInfo();
        } else {
            this.appId = appId;
            this.appSecret = appSecret;
        }
    }

    private static String capitalize(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1).toLowerCase();
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getUserOauthToken() {
        return this.userOauthToken;
    }

    public void setUserOauthToken(String userOauthToken) {
        this.userOauthToken = userOauthToken;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String fetchBundleString() throws IOException {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            String string;
            block20: {
                String bundleUrl;
                HttpGet request = new HttpGet("https://play.qobuz.com/login");
                try (CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)request);){
                    Matcher bundleMatcher = BUNDLE_PATTERN.matcher(EntityUtils.toString((HttpEntity)response.getEntity()));
                    if (!bundleMatcher.find()) {
                        throw new IllegalStateException("Failed to extract bundle.js URL");
                    }
                    bundleUrl = WEB_PLAYER_BASE_URL + bundleMatcher.group("bundleJS");
                }
                HttpGet bundleRequest = new HttpGet(bundleUrl);
                CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)bundleRequest);
                try {
                    string = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (response == null) break block20;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    public String getWebPlayerAppId(String bundleJsContent) {
        Matcher appIdMatcher = APP_ID_PATTERN.matcher(bundleJsContent);
        if (!appIdMatcher.find()) {
            throw new IllegalStateException("Failed to extract app_id from bundle.js");
        }
        return appIdMatcher.group("appID");
    }

    public String getWebPlayerAppSecret(String bundleJsContent) {
        Matcher seedMatcher = SEED_PATTERN.matcher(bundleJsContent);
        if (!seedMatcher.find()) {
            throw new IllegalStateException("Failed to extract seed and timezone from bundle.js");
        }
        String seed = seedMatcher.group("seed");
        String productionTimezone = QobuzTokenTracker.capitalize(seedMatcher.group("timezone"));
        Pattern infoExtrasRegex = Pattern.compile("timezones:\\[.*?name:.*?/" + productionTimezone + "\",info:\"(?<info>.*?)\",extras:\"(?<extras>.*?)\"");
        Matcher infoExtrasMatcher = infoExtrasRegex.matcher(bundleJsContent);
        if (!infoExtrasMatcher.find()) {
            throw new IllegalStateException("Failed to extract info and extras for timezone " + productionTimezone + " from bundle.js");
        }
        Object base64EncodedAppSecret = seed + infoExtrasMatcher.group("info") + infoExtrasMatcher.group("extras");
        base64EncodedAppSecret = ((String)base64EncodedAppSecret).substring(0, ((String)base64EncodedAppSecret).length() - 44);
        return new String(Base64.getDecoder().decode((String)base64EncodedAppSecret));
    }

    private void fetchAppInfo() {
        try {
            String bundleJsContent = this.fetchBundleString();
            this.appId = this.getWebPlayerAppId(bundleJsContent);
            this.appSecret = this.getWebPlayerAppSecret(bundleJsContent);
            log.info("Fetched Qobuz App ID :{} and App Secret :{}", (Object)this.appId, (Object)this.appSecret);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to extract app_id from bundle.js", e);
        }
    }
}

