/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.spotify;

import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.spotify.SpotifySourceManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotifyTokenTracker {
    private static final Logger log = LoggerFactory.getLogger(SpotifyTokenTracker.class);
    private static final Pattern SECRET_PATTERN = Pattern.compile("\\(\\[(\\d+(?:,\\d+)+)]\\)");
    private final SpotifySourceManager sourceManager;
    private String clientId;
    private String clientSecret;
    private String accessToken;
    private Instant expires;
    private String anonymousAccessToken;
    private Instant anonymousExpires;
    private String spDc;
    private String accountToken;
    private Instant accountTokenExpire;

    public SpotifyTokenTracker(SpotifySourceManager source, String clientId, String clientSecret, String spDc) {
        this.sourceManager = source;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        if (!this.hasValidCredentials()) {
            log.debug("Missing/invalid credentials, falling back to public token.");
        }
        this.spDc = spDc;
        if (!this.hasValidAccountCredentials()) {
            log.debug("Missing/invalid account credentials");
        }
    }

    public void setClientIDS(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.accessToken = null;
        this.expires = null;
    }

    private boolean hasValidCredentials() {
        return this.clientId != null && !this.clientId.isEmpty() && this.clientSecret != null && !this.clientSecret.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken(boolean preferAnonymousToken) throws IOException {
        if (preferAnonymousToken || !this.hasValidCredentials()) {
            return this.getAnonymousAccessToken();
        }
        if (this.accessToken == null || this.expires == null || this.expires.isBefore(Instant.now())) {
            SpotifyTokenTracker spotifyTokenTracker = this;
            synchronized (spotifyTokenTracker) {
                if (this.accessToken == null || this.expires == null || this.expires.isBefore(Instant.now())) {
                    log.debug("Access token is invalid or expired, refreshing token...");
                    this.refreshAccessToken();
                }
            }
        }
        return this.accessToken;
    }

    private void refreshAccessToken() throws IOException {
        HttpPost request = new HttpPost("https://accounts.spotify.com/api/token");
        request.addHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes(StandardCharsets.UTF_8)));
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(List.of(new BasicNameValuePair("grant_type", "client_credentials")), StandardCharsets.UTF_8));
        JsonBrowser json2 = LavaSrcTools.fetchResponseAsJson(this.sourceManager.getHttpInterface(), (HttpUriRequest)request);
        if (json2 == null) {
            throw new RuntimeException("No response from Spotify API");
        }
        if (!json2.get("error").isNull()) {
            String error = json2.get("error").text();
            throw new RuntimeException("Error while fetching access token: " + error);
        }
        this.accessToken = json2.get("access_token").text();
        this.expires = Instant.now().plusSeconds(json2.get("expires_in").asLong(0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnonymousAccessToken() throws IOException {
        if (this.anonymousAccessToken == null || this.anonymousExpires == null || this.anonymousExpires.isBefore(Instant.now())) {
            SpotifyTokenTracker spotifyTokenTracker = this;
            synchronized (spotifyTokenTracker) {
                if (this.anonymousAccessToken == null || this.anonymousExpires == null || this.anonymousExpires.isBefore(Instant.now())) {
                    log.debug("Anonymous access token is invalid or expired, refreshing token...");
                    this.refreshAnonymousAccessToken();
                }
            }
        }
        return this.anonymousAccessToken;
    }

    private void refreshAnonymousAccessToken() throws IOException {
        HttpGet request = new HttpGet(SpotifyTokenTracker.generateGetAccessTokenURL());
        JsonBrowser json2 = LavaSrcTools.fetchResponseAsJson(this.sourceManager.getHttpInterface(), (HttpUriRequest)request);
        if (json2 == null) {
            throw new RuntimeException("No response from Spotify API");
        }
        if (!json2.get("error").isNull()) {
            String error = json2.get("error").text();
            throw new RuntimeException("Error while fetching access token: " + error);
        }
        this.anonymousAccessToken = json2.get("accessToken").text();
        this.anonymousExpires = Instant.ofEpochMilli(json2.get("accessTokenExpirationTimestampMs").asLong(0L));
    }

    public void setSpDc(String spDc) {
        this.spDc = spDc;
        this.accountToken = null;
        this.accountTokenExpire = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccountToken() throws IOException {
        if (this.accountToken == null || this.accountTokenExpire == null || this.accountTokenExpire.isBefore(Instant.now())) {
            SpotifyTokenTracker spotifyTokenTracker = this;
            synchronized (spotifyTokenTracker) {
                if (this.accountToken == null || this.accountTokenExpire == null || this.accountTokenExpire.isBefore(Instant.now())) {
                    log.debug("Account token is invalid or expired, refreshing token...");
                    this.refreshAccountToken();
                }
            }
        }
        return this.accountToken;
    }

    public void refreshAccountToken() throws IOException {
        HttpGet request = new HttpGet(SpotifyTokenTracker.generateGetAccessTokenURL());
        request.addHeader("App-Platform", "WebPlayer");
        request.addHeader("Cookie", "sp_dc=" + this.spDc);
        try {
            JsonBrowser json2 = LavaSrcTools.fetchResponseAsJson(this.sourceManager.getHttpInterface(), (HttpUriRequest)request);
            if (!json2.get("error").isNull()) {
                String error = json2.get("error").text();
                log.error("Error while fetching account token: {}", (Object)error);
                throw new RuntimeException("Error while fetching account token: " + error);
            }
            this.accountToken = json2.get("accessToken").text();
            this.accountTokenExpire = Instant.ofEpochMilli(json2.get("accessTokenExpirationTimestampMs").asLong(0L));
        }
        catch (IOException e) {
            log.error("Account token refreshing failed.", (Throwable)e);
            throw new RuntimeException("Account token refreshing failed", e);
        }
    }

    public boolean hasValidAccountCredentials() {
        return this.spDc != null && !this.spDc.isEmpty();
    }

    public static String generateTOTP(String secret, int period, int digits) {
        long time = System.currentTimeMillis() / 1000L / (long)period;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(time);
        byte[] timeBytes = buffer.array();
        try {
            SecretKeySpec keySpec = new SecretKeySpec(SpotifyTokenTracker.hexStringToByteArray(secret), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(keySpec);
            byte[] hash = mac.doFinal(timeBytes);
            int offset = hash[hash.length - 1] & 0xF;
            int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
            int otp = binary % (int)Math.pow(10.0, digits);
            return String.format("%0" + digits + "d", otp);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Error generating TOTP", e);
        }
    }

    public static byte[] extractSecret(CloseableHttpClient client, String scriptUrl) throws IOException {
        HttpGet scriptRequest = new HttpGet(scriptUrl);
        try (CloseableHttpResponse scriptResponse = client.execute((HttpUriRequest)scriptRequest);){
            String scriptContent = EntityUtils.toString((HttpEntity)scriptResponse.getEntity());
            Matcher matcher = SECRET_PATTERN.matcher(scriptContent);
            if (matcher.find()) {
                String secretArrayString = matcher.group(1);
                String[] secretArray = secretArrayString.split(",");
                byte[] secretByteArray = new byte[secretArray.length];
                for (int i = 0; i < secretArray.length; ++i) {
                    secretByteArray[i] = (byte)Integer.parseInt(secretArray[i].trim());
                }
                byte[] byArray = secretByteArray;
                return byArray;
            }
            log.error("No secret array found in script: {}", (Object)scriptUrl);
            byte[] byArray = null;
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] requestSecret() throws IOException {
        String homepageUrl = "https://open.spotify.com/";
        String scriptPattern = "mobile-web-player";
        log.debug("Requesting secret from Spotify homepage: {}", (Object)homepageUrl);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpGet request = new HttpGet(homepageUrl);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                String html = EntityUtils.toString((HttpEntity)response.getEntity());
                Document doc = Jsoup.parse((String)html);
                Elements scriptElements = doc.select("script[src]");
                ArrayList<String> scriptUrls = new ArrayList<String>();
                log.debug("Found {} script elements in the HTML", (Object)scriptElements.size());
                for (Element script : scriptElements) {
                    String scriptUrl = script.attr("src");
                    if (!scriptUrl.contains(scriptPattern) || scriptUrl.contains("vendor")) continue;
                    scriptUrls.add(scriptUrl);
                    log.debug("Found relevant script URL: {}", (Object)scriptUrl);
                }
                if (scriptUrls.isEmpty()) {
                    log.debug("No relevant script URLs found.");
                    Iterator iterator2 = null;
                    return iterator2;
                }
                for (String scriptUrl : scriptUrls) {
                    log.debug("Attempting to extract secret from script URL: {}", (Object)scriptUrl);
                    byte[] secret = SpotifyTokenTracker.extractSecret(client, scriptUrl);
                    if (secret == null) continue;
                    log.debug("Successfully extracted secret.");
                    byte[] byArray = secret;
                    return byArray;
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to request or parse the secret", (Throwable)e);
            throw new IOException("Failed to request or parse the secret", e);
        }
        log.error("No secret found.");
        return null;
    }

    public static String generateGetAccessTokenURL() throws IOException {
        byte[] secret = SpotifyTokenTracker.requestSecret();
        if (secret == null) {
            throw new IOException("Failed to retrieve secret from Spotify.");
        }
        byte[] transformedSecret = SpotifyTokenTracker.convertArrayToTransformedByteArray(secret);
        String hexSecret = SpotifyTokenTracker.toHexString(transformedSecret);
        String totp = SpotifyTokenTracker.generateTOTP(hexSecret, 30, 6);
        long ts = System.currentTimeMillis();
        return "https://open.spotify.com/api/token?reason=init&productType=web-player&totp=" + totp + "&totpVer=5&ts=" + ts;
    }

    public static byte[] convertArrayToTransformedByteArray(byte[] array) {
        byte[] transformed = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            transformed[i] = (byte)(array[i] ^ i % 33 + 9);
        }
        return transformed;
    }

    public static String toHexString(byte[] transformed) {
        StringBuilder joinedString = new StringBuilder();
        for (byte b : transformed) {
            joinedString.append(b);
        }
        byte[] utf8Bytes = joinedString.toString().getBytes(StandardCharsets.UTF_8);
        StringBuilder hexString = new StringBuilder();
        for (byte b : utf8Bytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

