/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.applemusic;

import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class AppleMusicTokenManager {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("ey[\\w-]+\\.[\\w-]+\\.[\\w-]+");
    private Token token;

    public AppleMusicTokenManager(String mediaAPIToken) throws IOException {
        if (mediaAPIToken == null || mediaAPIToken.isEmpty()) {
            this.fetchNewToken();
        } else {
            this.parseTokenData(mediaAPIToken);
        }
    }

    public Token getToken() throws IOException {
        if (this.token.isExpired()) {
            this.fetchNewToken();
        }
        return this.token;
    }

    public void setToken(String mediaAPIToken) throws IOException {
        this.parseTokenData(mediaAPIToken);
    }

    private void parseTokenData(String mediaAPIToken) throws IOException {
        if (mediaAPIToken == null || mediaAPIToken.isEmpty()) {
            throw new IllegalArgumentException("Invalid token provided.");
        }
        String[] parts = mediaAPIToken.split("\\.");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Invalid token provided must have 3 parts separated by '.'");
        }
        String payload = new String(Base64.getDecoder().decode(parts[1]), StandardCharsets.UTF_8);
        JsonBrowser json2 = JsonBrowser.parse((String)payload);
        this.token = new Token(mediaAPIToken, json2.get("root_https_origin").index(0).text(), Instant.ofEpochSecond(json2.get("exp").asLong(0L)));
    }

    private void fetchNewToken() throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String mainPageHtml = this.fetchHtml(httpClient, "https://music.apple.com");
            String tokenScriptUrl = this.extractTokenScriptUrl(mainPageHtml);
            if (tokenScriptUrl == null) {
                throw new IllegalStateException("Failed to locate token script URL.");
            }
            String tokenScriptContent = this.fetchHtml(httpClient, tokenScriptUrl);
            Matcher tokenMatcher = TOKEN_PATTERN.matcher(tokenScriptContent);
            if (!tokenMatcher.find()) {
                throw new IllegalStateException("Failed to extract token from script content.");
            }
            this.parseTokenData(tokenMatcher.group());
        }
    }

    private String fetchHtml(CloseableHttpClient httpClient, String url) throws IOException {
        HttpGet request = new HttpGet(url);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed to fetch URL: " + url + ". Status code: " + response.getStatusLine().getStatusCode());
            }
            String string = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private String extractTokenScriptUrl(String html) {
        Document document = Jsoup.parse((String)html, (String)"https://music.apple.com");
        return document.select("script[type=module][src~=/assets/index.*.js]").stream().findFirst().map(element -> "https://music.apple.com" + element.attr("src")).orElseThrow(() -> new IllegalStateException("Failed to find token script URL in the provided HTML."));
    }

    public static class Token {
        public final String apiToken;
        public final String origin;
        public final Instant expire;

        public Token(String apiToken, String origin2, Instant expire) {
            this.apiToken = apiToken;
            this.origin = origin2;
            this.expire = expire;
        }

        private boolean isExpired() {
            if (this.apiToken == null || this.expire == null) {
                return true;
            }
            return this.expire.minusSeconds(5L).isBefore(Instant.now());
        }
    }
}

