/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.tidal;

import com.github.topi314.lavasrc.ExtendedAudioPlaylist;
import com.github.topi314.lavasrc.ExtendedAudioSourceManager;
import com.github.topi314.lavasrc.LavaSrcTools;
import com.github.topi314.lavasrc.mirror.DefaultMirroringAudioTrackResolver;
import com.github.topi314.lavasrc.mirror.MirroringAudioSourceManager;
import com.github.topi314.lavasrc.mirror.MirroringAudioTrackResolver;
import com.github.topi314.lavasrc.tidal.TidalAudioPlaylist;
import com.github.topi314.lavasrc.tidal.TidalAudioTrack;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TidalSourceManager
extends MirroringAudioSourceManager
implements HttpConfigurable {
    public static final Pattern URL_PATTERN = Pattern.compile("https?://(?:(?:listen|www)\\.)?tidal\\.com/(?:browse/)?(?<type>album|track|playlist|mix)/(?<id>[a-zA-Z0-9\\-]+)(?:\\?.*)?");
    public static final String SEARCH_PREFIX = "tdsearch:";
    public static final String RECOMMENDATIONS_PREFIX = "tdrec:";
    public static final String PUBLIC_API_BASE = "https://api.tidal.com/v1/";
    public static final int PLAYLIST_MAX_PAGE_ITEMS = 750;
    public static final int ALBUM_MAX_PAGE_ITEMS = 120;
    private static final String USER_AGENT = "TIDAL/3704 CFNetwork/1220.1 Darwin/20.3.0";
    private static final Logger log = LoggerFactory.getLogger(TidalSourceManager.class);
    private final String tidalToken;
    private final HttpInterfaceManager httpInterfaceManager;
    private final String countryCode;
    private int searchLimit = 6;

    public TidalSourceManager(String[] providers, String countryCode, Function<Void, AudioPlayerManager> audioPlayerManager, String tidalToken) {
        this(countryCode, audioPlayerManager, new DefaultMirroringAudioTrackResolver(providers), tidalToken);
    }

    public TidalSourceManager(String countryCode, Function<Void, AudioPlayerManager> audioPlayerManager, MirroringAudioTrackResolver mirroringAudioTrackResolver, String tidalToken) {
        super(audioPlayerManager, mirroringAudioTrackResolver);
        String string = this.countryCode = countryCode == null || countryCode.isEmpty() ? "US" : countryCode;
        if (tidalToken == null || tidalToken.isEmpty()) {
            throw new IllegalArgumentException("Tidal token must be provided");
        }
        this.tidalToken = tidalToken;
        this.httpInterfaceManager = HttpClientTools.createCookielessThreadLocalManager();
    }

    public void setSearchLimit(int searchLimit) {
        this.searchLimit = searchLimit;
    }

    public String getSourceName() {
        return "tidal";
    }

    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        ExtendedAudioSourceManager.ExtendedAudioTrackInfo extendedAudioTrackInfo = super.decodeTrack(input);
        return new TidalAudioTrack(trackInfo, extendedAudioTrackInfo.albumName, extendedAudioTrackInfo.albumUrl, extendedAudioTrackInfo.artistUrl, extendedAudioTrackInfo.previewUrl, this);
    }

    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        try {
            Matcher matcher = URL_PATTERN.matcher(reference.identifier);
            if (matcher.matches()) {
                String type = matcher.group("type");
                String id = matcher.group("id");
                switch (type) {
                    case "album": {
                        return this.getAlbumOrPlaylist(id, "album", 120);
                    }
                    case "mix": {
                        return this.getMix(id);
                    }
                    case "track": {
                        return this.getTrack(id);
                    }
                    case "playlist": {
                        return this.getAlbumOrPlaylist(id, "playlist", 750);
                    }
                }
                return null;
            }
            if (reference.identifier.startsWith(SEARCH_PREFIX)) {
                String query = reference.identifier.substring(SEARCH_PREFIX.length());
                if (query.isEmpty()) {
                    throw new IllegalArgumentException("No query provided for search");
                }
                return this.getSearch(query);
            }
            if (reference.identifier.startsWith(RECOMMENDATIONS_PREFIX)) {
                String trackId = reference.identifier.substring(RECOMMENDATIONS_PREFIX.length());
                if (trackId.isEmpty()) {
                    throw new IllegalArgumentException("No track ID provided for recommendations");
                }
                return this.getRecommendations(trackId);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private JsonBrowser getJson(String uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        request.setHeader("user-agent", USER_AGENT);
        request.setHeader("x-tidal-token", this.tidalToken);
        return LavaSrcTools.fetchResponseAsJson(this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
    }

    private List<AudioTrack> parseTracks(JsonBrowser json2) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser audio : json2.values()) {
            AudioTrack parsedTrack = this.parseTrack(audio);
            if (parsedTrack == null) continue;
            tracks.add(parsedTrack);
        }
        return tracks;
    }

    private AudioItem getSearch(String query) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.tidal.com/v1/search?query=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&offset=0&limit=" + this.searchLimit + "&countryCode=" + this.countryCode);
        if (json2.get("tracks").get("items").isNull()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> tracks = this.parseTracks(json2.get("tracks").get("items"));
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Tidal Search: " + query, tracks, null, true);
    }

    private AudioItem getRecommendations(String trackId) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.tidal.com/v1/tracks/" + trackId + "?countryCode=" + this.countryCode);
        if (json2.isNull()) {
            return AudioReference.NO_TRACK;
        }
        String mixId = json2.get("mixes").get("TRACK_MIX").text();
        if (mixId == null) {
            return AudioReference.NO_TRACK;
        }
        return this.getMix(mixId);
    }

    private AudioTrack parseTrack(JsonBrowser audio) {
        String id = audio.get("id").text();
        long duration = audio.get("duration").asLong(0L) * 1000L;
        if (duration == 0L) {
            return null;
        }
        String title = audio.get("title").text();
        String originalUrl = audio.get("url").text();
        String artistName = audio.get("artists").values().stream().map(artist -> artist.get("name").text()).collect(Collectors.joining(", "));
        String coverIdentifier = audio.get("album").get("cover").text();
        Object artworkUrl = coverIdentifier == null ? "https://tidal.com/_nuxt/img/logos.d8ce10b.jpg" : "https://resources.tidal.com/images/" + coverIdentifier.replaceAll("-", "/") + "/1280x1280.jpg";
        String isrc = audio.get("isrc").text();
        return new TidalAudioTrack(new AudioTrackInfo(title, artistName, duration, id, false, originalUrl, (String)artworkUrl, isrc), this);
    }

    private AudioItem getAlbumOrPlaylist(String itemId, String type, int maxPageItems) throws IOException {
        long totalTracks;
        String artistName;
        String coverUrl;
        String url;
        String title;
        JsonBrowser json2 = this.getJson(PUBLIC_API_BASE + type + "s/" + itemId + "/tracks?countryCode=" + this.countryCode + "&limit=" + maxPageItems);
        if (json2 == null || json2.get("items").isNull()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> items = this.parseTrackItem(json2);
        if (items.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        ExtendedAudioPlaylist.Type trackType = type.equalsIgnoreCase("playlist") ? ExtendedAudioPlaylist.Type.PLAYLIST : ExtendedAudioPlaylist.Type.ALBUM;
        String itemInfoUrl = trackType == ExtendedAudioPlaylist.Type.PLAYLIST ? "https://api.tidal.com/v1/playlists/" + itemId + "?countryCode=" + this.countryCode : "https://api.tidal.com/v1/albums/" + itemId + "?countryCode=" + this.countryCode;
        JsonBrowser itemInfoJson = this.getJson(itemInfoUrl);
        if (itemInfoJson == null) {
            return AudioReference.NO_TRACK;
        }
        if (trackType == ExtendedAudioPlaylist.Type.PLAYLIST) {
            title = itemInfoJson.get("title").text();
            url = itemInfoJson.get("url").text();
            coverUrl = itemInfoJson.get("squareImage").text();
            artistName = itemInfoJson.get("promotedArtists").index(0).get("name").text();
            totalTracks = itemInfoJson.get("numberOfTracks").asLong(0L);
        } else {
            title = itemInfoJson.get("title").text();
            url = itemInfoJson.get("url").text();
            coverUrl = itemInfoJson.get("cover").text();
            artistName = itemInfoJson.get("artists").index(0).get("name").text();
            totalTracks = itemInfoJson.get("numberOfTracks").asLong(0L);
        }
        if (title == null || url == null) {
            return AudioReference.NO_TRACK;
        }
        String artworkUrl = "https://resources.tidal.com/images/" + coverUrl.replaceAll("-", "/") + "/1080x1080.jpg";
        return new TidalAudioPlaylist(title, items, type.equalsIgnoreCase("playlist") ? ExtendedAudioPlaylist.Type.PLAYLIST : ExtendedAudioPlaylist.Type.ALBUM, url, artworkUrl, artistName, (int)totalTracks);
    }

    public AudioItem getTrack(String trackId) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.tidal.com/v1/tracks/" + trackId + "?countryCode=" + this.countryCode);
        if (json2 == null || json2.isNull()) {
            return AudioReference.NO_TRACK;
        }
        AudioTrack track = this.parseTrack(json2);
        if (track == null) {
            return AudioReference.NO_TRACK;
        }
        return track;
    }

    public AudioItem getMix(String mixId) throws IOException {
        JsonBrowser json2 = this.getJson("https://api.tidal.com/v1/mixes/" + mixId + "/items?countryCode=" + this.countryCode);
        if (json2 == null || json2.get("items").isNull()) {
            return AudioReference.NO_TRACK;
        }
        List<AudioTrack> items = this.parseTrackItem(json2);
        if (items.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Mix: " + mixId, items, null, false);
    }

    private List<AudioTrack> parseTrackItem(JsonBrowser json2) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser audio : json2.get("items").values()) {
            AudioTrack parsedTrack = this.parseTrack(audio.get("item").isNull() ? audio : audio.get("item"));
            if (parsedTrack == null) continue;
            tracks.add(parsedTrack);
        }
        return tracks;
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    @Override
    public void shutdown() {
        try {
            this.httpInterfaceManager.close();
        }
        catch (IOException e) {
            log.error("Failed to close HTTP interface manager", (Throwable)e);
        }
    }

    @Override
    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }
}

