/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.youtube.innertube;

import com.github.topi314.lavasrc.youtube.innertube.InnerTubeContext;
import java.net.URI;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\f\u0010\b\u001a\u00020\u0007*\u00020\u0007H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"youtubeMusic", "Ljava/net/URI;", "getYoutubeMusic", "()Ljava/net/URI;", "musicContext", "Lcom/github/topi314/lavasrc/youtube/innertube/InnerTubeContext;", "locale", "Ljava/util/Locale;", "convertToISO", "lavasrc"})
public final class RequestsKt {
    @NotNull
    private static final URI youtubeMusic = new URI("https://music.youtube.com");

    @NotNull
    public static final URI getYoutubeMusic() {
        return youtubeMusic;
    }

    @NotNull
    public static final InnerTubeContext musicContext(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        Locale safeLocale = RequestsKt.convertToISO(locale);
        String string = safeLocale.getLanguage();
        Intrinsics.checkNotNullExpressionValue(string, "getLanguage(...)");
        String string2 = safeLocale.getCountry();
        Intrinsics.checkNotNullExpressionValue(string2, "getCountry(...)");
        return new InnerTubeContext(new InnerTubeContext.Client("WEB_REMIX", "1.20230102.01.00", string, string2));
    }

    private static final Locale convertToISO(Locale $this$convertToISO) {
        Locale locale;
        CharSequence charSequence = $this$convertToISO.getCountry();
        if (!(charSequence == null || StringsKt.isBlank(charSequence))) {
            locale = $this$convertToISO;
        } else if (Intrinsics.areEqual($this$convertToISO.getLanguage(), "cs")) {
            locale = new Locale($this$convertToISO.getLanguage(), "CZ");
        } else if (Intrinsics.areEqual($this$convertToISO.getLanguage(), "da")) {
            locale = new Locale($this$convertToISO.getLanguage(), "DK");
        } else if (Intrinsics.areEqual($this$convertToISO.getLanguage(), "el")) {
            locale = new Locale($this$convertToISO.getLanguage(), "GR");
        } else if (Intrinsics.areEqual($this$convertToISO.getLanguage(), "hi")) {
            locale = new Locale($this$convertToISO.getLanguage(), "IN");
        } else if (Intrinsics.areEqual($this$convertToISO.getLanguage(), "ja")) {
            locale = new Locale($this$convertToISO.getLanguage(), "JP");
        } else if (Intrinsics.areEqual($this$convertToISO.getLanguage(), "uk")) {
            locale = new Locale($this$convertToISO.getLanguage(), "UA");
        } else if (Intrinsics.areEqual($this$convertToISO.getLanguage(), "vi")) {
            locale = new Locale($this$convertToISO.getLanguage(), "VN");
        } else {
            String string = $this$convertToISO.getLanguage();
            String string2 = $this$convertToISO.getLanguage();
            Intrinsics.checkNotNullExpressionValue(string2, "getLanguage(...)");
            charSequence = string2;
            Locale locale2 = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue(locale2, "ENGLISH");
            String string3 = ((String)charSequence).toUpperCase(locale2);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toUpperCase(locale)");
            locale = new Locale(string, string3);
        }
        return locale;
    }
}

