/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.lavasrc.ytdlp;

import com.github.topi314.lavasrc.ExtendedAudioTrack;
import com.github.topi314.lavasrc.ytdlp.YoutubeMpegStreamAudioTrack;
import com.github.topi314.lavasrc.ytdlp.YoutubePersistentHttpStream;
import com.github.topi314.lavasrc.ytdlp.YtdlpAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YtdlpAudioTrack
extends ExtendedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(YtdlpAudioTrack.class);
    private final YtdlpAudioSourceManager sourceManager;

    public YtdlpAudioTrack(AudioTrackInfo trackInfo, YtdlpAudioSourceManager sourceManager) {
        this(trackInfo, null, null, null, null, null, false, sourceManager);
    }

    public YtdlpAudioTrack(AudioTrackInfo trackInfo, String albumName, String albumUrl, String artistUrl, String artistArtworkUrl, String previewUrl, boolean isPreview, YtdlpAudioSourceManager sourceManager) {
        super(trackInfo, albumName, albumUrl, artistUrl, artistArtworkUrl, previewUrl, isPreview);
        this.sourceManager = sourceManager;
    }

    private JsonBrowser getStreamUrl(String url) throws IOException {
        ArrayList<String> args2 = new ArrayList<String>(List.of(this.sourceManager.getCustomPlaybackArgs()));
        args2.add(url);
        Process process = this.sourceManager.getProcess(args2);
        return this.sourceManager.getProcessJsonOutput(process);
    }

    public void process(LocalAudioTrackExecutor executor) throws Exception {
        JsonBrowser streamJson = this.getStreamUrl(this.trackInfo.uri);
        URI streamUrl = new URI(streamJson.get("url").text());
        String format = streamJson.get("ext").text();
        long contentLength = streamJson.get("filesize").asLong(Long.MAX_VALUE);
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            if (this.trackInfo.isStream) {
                if (format.equals("webm")) {
                    throw new FriendlyException("YouTube WebM streams are currently not supported.", FriendlyException.Severity.COMMON, null);
                }
                this.processDelegate((InternalAudioTrack)new YoutubeMpegStreamAudioTrack(this.trackInfo, httpInterface, streamUrl), executor);
                return;
            }
            try (YoutubePersistentHttpStream stream = new YoutubePersistentHttpStream(httpInterface, streamUrl, contentLength);){
                if (format.equals("webm")) {
                    this.processDelegate((InternalAudioTrack)new MatroskaAudioTrack(this.trackInfo, (SeekableInputStream)stream), executor);
                } else {
                    this.processDelegate((InternalAudioTrack)new MpegAudioTrack(this.trackInfo, (SeekableInputStream)stream), executor);
                }
            }
        }
    }

    protected AudioTrack makeShallowClone() {
        return new YtdlpAudioTrack(this.trackInfo, this.albumName, this.albumUrl, this.artistUrl, this.artistArtworkUrl, this.previewUrl, this.isPreview, this.sourceManager);
    }

    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

