/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.sponsorblock.plugin;

import com.github.topi314.sponsorblock.plugin.protocol.Chapter;
import com.github.topi314.sponsorblock.plugin.protocol.ChapterStarted;
import com.github.topi314.sponsorblock.plugin.protocol.EventsKt;
import com.github.topi314.sponsorblock.plugin.protocol.Segment;
import com.github.topi314.sponsorblock.plugin.protocol.SegmentSkipped;
import com.github.topi314.sponsorblock.plugin.protocol.TrackMarkable;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import dev.arbjerg.lavalink.api.ISocketContext;
import java.util.List;

public class SegmentHandler
implements TrackMarkerHandler {
    private final ISocketContext context;
    private final long guildId;
    private final AudioTrack track;
    private final List<? extends TrackMarkable> segments;
    private int currentSegment;

    public SegmentHandler(ISocketContext context, long guildId, AudioTrack track, List<? extends TrackMarkable> segments) {
        this.context = context;
        this.guildId = guildId;
        this.track = track;
        this.segments = segments;
    }

    public void handle(TrackMarkerHandler.MarkerState state) {
        if (state != TrackMarkerHandler.MarkerState.REACHED && state != TrackMarkerHandler.MarkerState.LATE && state != TrackMarkerHandler.MarkerState.BYPASSED) {
            return;
        }
        TrackMarkable markable = this.segments.get(this.currentSegment);
        if (markable instanceof Chapter) {
            Chapter chapter = (Chapter)markable;
            this.context.sendMessage(EventsKt.eventSerializer(), (Object)new ChapterStarted("event", String.valueOf(this.guildId), chapter));
        } else if (markable instanceof Segment) {
            Segment segment = (Segment)markable;
            this.track.setPosition(segment.getEnd().longValue());
            this.context.sendMessage(EventsKt.eventSerializer(), (Object)new SegmentSkipped("event", String.valueOf(this.guildId), segment));
        }
        ++this.currentSegment;
        if (this.currentSegment < this.segments.size()) {
            this.track.setMarker(new TrackMarker(this.segments.get(this.currentSegment).getStart(), (TrackMarkerHandler)this));
        }
    }
}

