/*
 * Decompiled with CFR 0.152.
 */
package com.github.topi314.sponsorblock.plugin;

import com.github.topi314.sponsorblock.plugin.SegmentHandler;
import com.github.topi314.sponsorblock.plugin.inntertube.InnerTubeClient;
import com.github.topi314.sponsorblock.plugin.protocol.Chapter;
import com.github.topi314.sponsorblock.plugin.protocol.ChaptersLoaded;
import com.github.topi314.sponsorblock.plugin.protocol.EventsKt;
import com.github.topi314.sponsorblock.plugin.protocol.Segment;
import com.github.topi314.sponsorblock.plugin.protocol.SegmentsLoaded;
import com.github.topi314.sponsorblock.plugin.protocol.TrackMarkable;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import dev.arbjerg.lavalink.api.IPlayer;
import dev.arbjerg.lavalink.api.ISocketContext;
import dev.arbjerg.lavalink.api.PluginEventHandler;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Service
@RestController
public class SponsorBlockPlugin
extends PluginEventHandler {
    private static final Logger log = LoggerFactory.getLogger(SponsorBlockPlugin.class);
    private static final String SPONSORBLOCK_URL = "https://sponsor.ajay.app/api/skipSegments?videoID=%s&categories=%s";
    private final HttpInterfaceManager httpInterfaceManager;
    private final Map<String, Map<Long, Set<String>>> categoriesToSkip;

    public SponsorBlockPlugin() {
        log.info("Loading SponsorBlock Plugin...");
        this.httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
        this.categoriesToSkip = new ConcurrentHashMap<String, Map<Long, Set<String>>>();
    }

    public Map<Long, Set<String>> getCategoriesToSkip(String sessionId) {
        return this.categoriesToSkip.get(sessionId);
    }

    @GetMapping(value={"/v4/sessions/{sessionId}/players/{guildId}/sponsorblock/categories"})
    public Set<String> getCategoriesToSkip(@PathVariable String sessionId, @PathVariable long guildId) {
        Map<Long, Set<String>> guildCategoriesToSkip = this.categoriesToSkip.get(sessionId);
        if (guildCategoriesToSkip == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Session not found");
        }
        Set<String> categoriesToSkip = guildCategoriesToSkip.get(guildId);
        if (categoriesToSkip == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Guild not found");
        }
        return categoriesToSkip;
    }

    @PutMapping(value={"/v4/sessions/{sessionId}/players/{guildId}/sponsorblock/categories"})
    public void setCategoriesToSkip(@PathVariable String sessionId, @PathVariable Long guildId, @RequestBody Set<String> categories) {
        Map<Long, Set<String>> guildCategoriesToSkip = this.categoriesToSkip.get(sessionId);
        if (guildCategoriesToSkip == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Session not found");
        }
        guildCategoriesToSkip.put(guildId, categories);
    }

    @DeleteMapping(value={"/v4/sessions/{sessionId}/players/{guildId}/sponsorblock/categories"})
    public void removeCategoriesToSkip(@PathVariable String sessionId, @PathVariable Long guildId) {
        Map<Long, Set<String>> guildCategoriesToSkip = this.categoriesToSkip.get(sessionId);
        if (guildCategoriesToSkip == null) {
            return;
        }
        guildCategoriesToSkip.remove(guildId);
    }

    public void onWebSocketOpen(ISocketContext context, boolean resumed) {
        this.categoriesToSkip.put(context.getSessionId(), new ConcurrentHashMap());
    }

    public void onSocketContextDestroyed(ISocketContext context) {
        this.categoriesToSkip.remove(context.getSessionId());
    }

    public void onNewPlayer(@NotNull ISocketContext context, IPlayer iPlayer) {
        iPlayer.getAudioPlayer().addListener((AudioEventListener)new PlayerListener(this, context, iPlayer.getGuildId()));
    }

    public void onDestroyPlayer(ISocketContext context, @NotNull IPlayer player) {
        Map<Long, Set<String>> guildCategoriesToSkip = this.categoriesToSkip.get(context.getSessionId());
        if (guildCategoriesToSkip != null) {
            guildCategoriesToSkip.remove(player.getGuildId());
        }
    }

    public List<Segment> retrieveVideoSegments(String videoId, Set<String> categories) throws IOException {
        String queryParam = URLEncoder.encode("[" + categories.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")) + "]", StandardCharsets.UTF_8);
        HttpGet request = new HttpGet(String.format(SPONSORBLOCK_URL, videoId, queryParam));
        JsonBrowser json2 = HttpClientTools.fetchResponseAsJson((HttpInterface)this.httpInterfaceManager.getInterface(), (HttpUriRequest)request);
        if (json2 == null) {
            return List.of();
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (JsonBrowser segment : json2.values()) {
            JsonBrowser segmentTimes = segment.get("segment");
            segments.add(new Segment(segment.get("category").text(), (long)(((Float)segmentTimes.index(0).as(Float.class)).floatValue() * 1000.0f), (long)(((Float)segmentTimes.index(1).as(Float.class)).floatValue() * 1000.0f)));
        }
        return segments;
    }

    public static class PlayerListener
    extends AudioEventAdapter {
        private final SponsorBlockPlugin plugin;
        private final ISocketContext context;
        private final long guildId;

        public PlayerListener(SponsorBlockPlugin plugin, ISocketContext socketContext, long guildId) {
            this.plugin = plugin;
            this.context = socketContext;
            this.guildId = guildId;
        }

        public void onTrackStart(AudioPlayer player, AudioTrack track) {
            ArrayList<Segment> markables;
            if (track.getSourceManager() == null || !track.getSourceManager().getSourceName().equals("youtube")) {
                return;
            }
            Map<Long, Set<String>> guildCategoriesToSkip = this.plugin.getCategoriesToSkip(this.context.getSessionId());
            if (guildCategoriesToSkip == null) {
                return;
            }
            Set<String> categories = guildCategoriesToSkip.get(this.guildId);
            if (categories == null) {
                return;
            }
            try (HttpInterface httpInterface = this.plugin.httpInterfaceManager.getInterface();){
                List<Chapter> chapters;
                List<Segment> segments = this.plugin.retrieveVideoSegments(track.getIdentifier(), categories);
                if (!segments.isEmpty()) {
                    this.context.sendMessage(EventsKt.eventSerializer(), (Object)new SegmentsLoaded("event", String.valueOf(this.guildId), segments));
                }
                if (!(chapters = InnerTubeClient.requestVideoChaptersById(httpInterface, track.getIdentifier(), track.getDuration())).isEmpty()) {
                    this.context.sendMessage(EventsKt.eventSerializer(), (Object)new ChaptersLoaded("event", String.valueOf(this.guildId), chapters));
                }
                ArrayList<Segment> output = new ArrayList<Segment>(segments);
                output.addAll(chapters);
                markables = output;
                output.sort(Comparator.comparing(TrackMarkable::getStart));
            }
            catch (IOException e) {
                log.error("Failed to retrieve video segments", (Throwable)e);
                return;
            }
            log.info("Categories are: {}", markables);
            if (!markables.isEmpty()) {
                track.setMarker(new TrackMarker(((TrackMarkable)markables.get(0)).getStart(), (TrackMarkerHandler)new SegmentHandler(this.context, this.guildId, track, markables)));
            }
        }
    }
}

