/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.udpqueue.natives;

import com.sedmelluq.discord.lavaplayer.udpqueue.natives.UdpQueueManagerLibrary;
import com.sedmelluq.lava.common.natives.NativeResourceHolder;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class UdpQueueManager
extends NativeResourceHolder {
    private final int bufferCapacity;
    private final ByteBuffer packetBuffer;
    private final UdpQueueManagerLibrary library;
    private final long instance;
    private boolean released;

    public UdpQueueManager(int bufferCapacity, long packetInterval, int maximumPacketSize) {
        this.bufferCapacity = bufferCapacity;
        this.packetBuffer = ByteBuffer.allocateDirect(maximumPacketSize);
        this.library = UdpQueueManagerLibrary.getInstance();
        this.instance = this.library.create(bufferCapacity, packetInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemainingCapacity(long key) {
        UdpQueueManagerLibrary udpQueueManagerLibrary = this.library;
        synchronized (udpQueueManagerLibrary) {
            if (this.released) {
                return 0;
            }
            return this.library.getRemainingCapacity(this.instance, key);
        }
    }

    public int getCapacity() {
        return this.bufferCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queuePacket(long key, ByteBuffer packet, InetSocketAddress address) {
        UdpQueueManagerLibrary udpQueueManagerLibrary = this.library;
        synchronized (udpQueueManagerLibrary) {
            if (this.released) {
                return false;
            }
            int length = packet.remaining();
            this.packetBuffer.clear();
            this.packetBuffer.put(packet);
            int port = address.getPort();
            String hostAddress = address.getAddress().getHostAddress();
            return this.library.queuePacket(this.instance, key, hostAddress, port, this.packetBuffer, length);
        }
    }

    public void process() {
        this.library.process(this.instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeResources() {
        UdpQueueManagerLibrary udpQueueManagerLibrary = this.library;
        synchronized (udpQueueManagerLibrary) {
            this.released = true;
            this.library.destroy(this.instance);
        }
    }

    public static void pauseDemo(int length) {
        UdpQueueManagerLibrary.getInstance();
        UdpQueueManagerLibrary.pauseDemo(length);
    }
}

