/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.client;

import dev.arbjerg.lavalink.client.ClientEvent;
import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.Link;
import dev.arbjerg.lavalink.client.LinkState;
import dev.arbjerg.lavalink.client.loadbalancing.ILoadBalancer;
import dev.arbjerg.lavalink.client.loadbalancing.IRegionFilter;
import dev.arbjerg.lavalink.client.loadbalancing.VoiceRegion;
import dev.arbjerg.lavalink.client.loadbalancing.builtin.DefaultLoadBalancer;
import dev.arbjerg.lavalink.internal.ReconnectTask;
import dev.arbjerg.lavalink.protocol.v4.Message;
import java.io.Closeable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J,\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H\u0007J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\u001c\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00042\n\b\u0002\u00104\u001a\u0004\u0018\u000105H\u0007J\u0010\u00106\u001a\u0004\u0018\u00010\u00122\u0006\u00103\u001a\u00020\u0004J\u0010\u00107\u001a\u0002002\u0006\u00108\u001a\u00020\u000fH\u0002J\u001f\u00109\u001a\b\u0012\u0004\u0012\u0002H:0\t\"\u000e\b\u0000\u0010:\u0018\u0001*\u0006\u0012\u0002\b\u00030\nH\u0086\bJ(\u00109\u001a\b\u0012\u0004\u0012\u0002H:0\t\"\f\b\u0000\u0010:*\u0006\u0012\u0002\b\u00030\n2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H:0<J\u0015\u0010=\u001a\u0002002\u0006\u00108\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b>R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006?"}, d2={"Ldev/arbjerg/lavalink/client/LavalinkClient;", "Ljava/io/Closeable;", "Lreactor/core/Disposable;", "userId", "", "(J)V", "clientOpen", "", "flux", "Lreactor/core/publisher/Flux;", "Ldev/arbjerg/lavalink/client/ClientEvent;", "getFlux", "()Lreactor/core/publisher/Flux;", "internalNodes", "", "Ldev/arbjerg/lavalink/client/LavalinkNode;", "links", "", "Ldev/arbjerg/lavalink/client/Link;", "loadBalancer", "Ldev/arbjerg/lavalink/client/loadbalancing/ILoadBalancer;", "getLoadBalancer$annotations", "()V", "getLoadBalancer", "()Ldev/arbjerg/lavalink/client/loadbalancing/ILoadBalancer;", "setLoadBalancer", "(Ldev/arbjerg/lavalink/client/loadbalancing/ILoadBalancer;)V", "nodes", "", "getNodes", "()Ljava/util/List;", "reconnectService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "reference", "sink", "Lreactor/core/publisher/Sinks$Many;", "getUserId", "()J", "addNode", "name", "", "address", "Ljava/net/URI;", "password", "regionFilter", "Ldev/arbjerg/lavalink/client/loadbalancing/IRegionFilter;", "close", "", "dispose", "getLink", "guildId", "region", "Ldev/arbjerg/lavalink/client/loadbalancing/VoiceRegion;", "getLinkIfCached", "listenForNodeEvent", "node", "on", "T", "type", "Ljava/lang/Class;", "onNodeDisconnected", "onNodeDisconnected$lavalink_client", "lavalink-client"})
@SourceDebugExtension(value={"SMAP\nLavalinkClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LavalinkClient.kt\ndev/arbjerg/lavalink/client/LavalinkClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 LavalinkNode.kt\ndev/arbjerg/lavalink/client/LavalinkNode\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1747#2,3:147\n1855#2,2:154\n215#3,2:150\n215#3,2:152\n83#4:156\n1#5:157\n*S KotlinDebug\n*F\n+ 1 LavalinkClient.kt\ndev/arbjerg/lavalink/client/LavalinkClient\n*L\n60#1:147,3\n127#1:154,2\n101#1:150,2\n107#1:152,2\n136#1:156\n*E\n"})
public final class LavalinkClient
implements Closeable,
Disposable {
    private final long userId;
    @NotNull
    private final List<LavalinkNode> internalNodes;
    @NotNull
    private final Map<Long, Link> links;
    private boolean clientOpen;
    @NotNull
    private final List<LavalinkNode> nodes;
    @NotNull
    private final Sinks.Many<ClientEvent<?>> sink;
    @NotNull
    private final Flux<ClientEvent<?>> flux;
    @NotNull
    private final Disposable reference;
    @NotNull
    private ILoadBalancer loadBalancer;
    private final ScheduledExecutorService reconnectService;

    public LavalinkClient(long userId) {
        this.userId = userId;
        this.internalNodes = new ArrayList();
        this.links = new LinkedHashMap();
        this.clientOpen = true;
        this.nodes = this.internalNodes;
        Sinks.Many many = Sinks.many().multicast().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)many, (String)"onBackpressureBuffer(...)");
        this.sink = many;
        Flux flux = this.sink.asFlux();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"asFlux(...)");
        this.flux = flux;
        Disposable disposable = this.flux.subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.reference = disposable;
        this.loadBalancer = new DefaultLoadBalancer(this);
        this.reconnectService = Executors.newSingleThreadScheduledExecutor(LavalinkClient::reconnectService$lambda$1);
        this.reconnectService.scheduleWithFixedDelay(new ReconnectTask(this), 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public final long getUserId() {
        return this.userId;
    }

    @NotNull
    public final List<LavalinkNode> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final Flux<ClientEvent<?>> getFlux() {
        return this.flux;
    }

    @NotNull
    public final ILoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public final void setLoadBalancer(@NotNull ILoadBalancer iLoadBalancer) {
        Intrinsics.checkNotNullParameter((Object)iLoadBalancer, (String)"<set-?>");
        this.loadBalancer = iLoadBalancer;
    }

    public static /* synthetic */ void getLoadBalancer$annotations() {
    }

    @JvmOverloads
    @NotNull
    public final LavalinkNode addNode(@NotNull String name, @NotNull URI address, @NotNull String password, @Nullable IRegionFilter regionFilter) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Iterable $this$any$iv = this.nodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LavalinkNode it = (LavalinkNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalStateException("Node with name '" + name + "' already exists");
        }
        LavalinkNode node = new LavalinkNode(name, address, password, regionFilter, this);
        this.internalNodes.add(node);
        this.listenForNodeEvent(node);
        return node;
    }

    public static /* synthetic */ LavalinkNode addNode$default(LavalinkClient lavalinkClient, String string, URI uRI, String string2, IRegionFilter iRegionFilter, int n, Object object) {
        if ((n & 8) != 0) {
            iRegionFilter = null;
        }
        return lavalinkClient.addNode(string, uRI, string2, iRegionFilter);
    }

    @JvmOverloads
    @NotNull
    public final Link getLink(long guildId, @Nullable VoiceRegion region) {
        Long l = guildId;
        if (!this.links.containsKey(l)) {
            LavalinkNode bestNode = this.loadBalancer.selectNode(region);
            Long l2 = guildId;
            this.links.put(l2, new Link(guildId, bestNode));
        }
        Link link = this.links.get(guildId);
        Intrinsics.checkNotNull((Object)link);
        return link;
    }

    public static /* synthetic */ Link getLink$default(LavalinkClient lavalinkClient, long l, VoiceRegion voiceRegion, int n, Object object) {
        if ((n & 2) != 0) {
            voiceRegion = null;
        }
        return lavalinkClient.getLink(l, voiceRegion);
    }

    @Nullable
    public final Link getLinkIfCached(long guildId) {
        return this.links.get(guildId);
    }

    public final void onNodeDisconnected$lavalink_client(@NotNull LavalinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!this.clientOpen) {
            return;
        }
        if (this.nodes.size() == 1) {
            Map<Long, Link> $this$forEach$iv = this.links;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Long, Link>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, Link> element$iv;
                Map.Entry<Long, Link> entry = element$iv = iterator.next();
                boolean bl = false;
                Link link = entry.getValue();
                link.setState$lavalink_client(LinkState.DISCONNECTED);
            }
            return;
        }
        Map<Long, Link> $this$forEach$iv = this.links;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, Link>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Link> element$iv;
            Map.Entry<Long, Link> entry = element$iv = iterator.next();
            boolean bl = false;
            Link link = entry.getValue();
            if (!Intrinsics.areEqual((Object)link.getNode(), (Object)node)) continue;
            link.transferNode$lavalink_client(this.loadBalancer.selectNode(null));
        }
    }

    @NotNull
    public final <T extends ClientEvent<?>> Flux<T> on(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Flux flux = this.flux.ofType(type);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"ofType(...)");
        return flux;
    }

    public final /* synthetic */ <T extends ClientEvent<?>> Flux<T> on() {
        boolean $i$f$on = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.on(ClientEvent.class);
    }

    @Override
    public void close() {
        this.clientOpen = false;
        this.reconnectService.shutdownNow();
        Iterable $this$forEach$iv = this.nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LavalinkNode it = (LavalinkNode)element$iv;
            boolean bl = false;
            it.close();
        }
        this.reference.dispose();
    }

    public void dispose() {
        this.close();
    }

    private final void listenForNodeEvent(LavalinkNode node) {
        LavalinkNode this_$iv = node;
        boolean $i$f$on = false;
        this_$iv.on(ClientEvent.class).subscribe(arg_0 -> LavalinkClient.listenForNodeEvent$lambda$6((Function1)new Function1<ClientEvent<Message>, Unit>(this){
            final /* synthetic */ LavalinkClient this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ClientEvent<Message> it) {
                try {
                    LavalinkClient.access$getSink$p(this.this$0).tryEmitNext(it);
                }
                catch (Exception e) {
                    LavalinkClient.access$getSink$p(this.this$0).tryEmitError((Throwable)e);
                }
            }
        }, arg_0));
    }

    @JvmOverloads
    @NotNull
    public final LavalinkNode addNode(@NotNull String name, @NotNull URI address, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return LavalinkClient.addNode$default(this, name, address, password, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Link getLink(long guildId) {
        return LavalinkClient.getLink$default(this, guildId, null, 2, null);
    }

    private static final Thread reconnectService$lambda$1(Runnable it) {
        Thread thread;
        Thread $this$reconnectService_u24lambda_u241_u24lambda_u240 = thread = new Thread(it, "lavalink-reconnect-thread");
        boolean bl = false;
        $this$reconnectService_u24lambda_u241_u24lambda_u240.setDaemon(true);
        return thread;
    }

    private static final void listenForNodeEvent$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Sinks.Many access$getSink$p(LavalinkClient $this) {
        return $this.sink;
    }
}

