/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.client;

import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.LavalinkPlayer;
import dev.arbjerg.lavalink.client.LinkState;
import dev.arbjerg.lavalink.client.PlayerUpdateBuilder;
import dev.arbjerg.lavalink.protocol.v4.LoadResult;
import dev.arbjerg.lavalink.protocol.v4.VoiceState;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0015J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00152\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$J\u0015\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b'J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00152\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00130*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Ldev/arbjerg/lavalink/client/Link;", "", "guildId", "", "node", "Ldev/arbjerg/lavalink/client/LavalinkNode;", "(JLdev/arbjerg/lavalink/client/LavalinkNode;)V", "getGuildId", "()J", "<set-?>", "getNode", "()Ldev/arbjerg/lavalink/client/LavalinkNode;", "Ldev/arbjerg/lavalink/client/LinkState;", "state", "getState", "()Ldev/arbjerg/lavalink/client/LinkState;", "setState$lavalink_client", "(Ldev/arbjerg/lavalink/client/LinkState;)V", "createOrUpdatePlayer", "Ldev/arbjerg/lavalink/client/PlayerUpdateBuilder;", "destroyPlayer", "Lreactor/core/publisher/Mono;", "", "equals", "", "other", "getPlayer", "Ldev/arbjerg/lavalink/client/LavalinkPlayer;", "hashCode", "", "loadItem", "Ldev/arbjerg/lavalink/protocol/v4/LoadResult;", "identifier", "", "onVoiceServerUpdate", "newVoiceState", "Ldev/arbjerg/lavalink/protocol/v4/VoiceState;", "transferNode", "newNode", "transferNode$lavalink_client", "updatePlayer", "updateConsumer", "Ljava/util/function/Consumer;", "lavalink-client"})
public final class Link {
    private final long guildId;
    @NotNull
    private LavalinkNode node;
    @NotNull
    private LinkState state;

    public Link(long guildId, @NotNull LavalinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.guildId = guildId;
        this.node = node;
        this.state = LinkState.DISCONNECTED;
    }

    public final long getGuildId() {
        return this.guildId;
    }

    @NotNull
    public final LavalinkNode getNode() {
        return this.node;
    }

    @NotNull
    public final LinkState getState() {
        return this.state;
    }

    public final void setState$lavalink_client(@NotNull LinkState linkState) {
        Intrinsics.checkNotNullParameter((Object)((Object)linkState), (String)"<set-?>");
        this.state = linkState;
    }

    @NotNull
    public final Mono<LavalinkPlayer> getPlayer() {
        return this.node.getPlayer(this.guildId);
    }

    @NotNull
    public final Mono<Unit> destroyPlayer() {
        return this.node.destroyPlayer(this.guildId);
    }

    @NotNull
    public final Mono<LavalinkPlayer> updatePlayer(@NotNull Consumer<PlayerUpdateBuilder> updateConsumer) {
        Intrinsics.checkNotNullParameter(updateConsumer, (String)"updateConsumer");
        return this.node.updatePlayer(this.guildId, updateConsumer);
    }

    @NotNull
    public final PlayerUpdateBuilder createOrUpdatePlayer() {
        return this.node.createOrUpdatePlayer(this.guildId);
    }

    @NotNull
    public final Mono<LoadResult> loadItem(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.node.loadItem(identifier);
    }

    public final void transferNode$lavalink_client(@NotNull LavalinkNode newNode) {
        Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
        LavalinkPlayer player = this.node.getCachedPlayer$lavalink_client(this.guildId);
        if (player != null) {
            this.node.removeCachedPlayer$lavalink_client(this.guildId);
            newNode.createOrUpdatePlayer(this.guildId).applyBuilder$lavalink_client(player.stateToBuilder$lavalink_client()).asMono().block();
        }
        this.node = newNode;
    }

    public final void onVoiceServerUpdate(@NotNull VoiceState newVoiceState) {
        Intrinsics.checkNotNullParameter((Object)newVoiceState, (String)"newVoiceState");
        if (this.node.getAvailable()) {
            this.node.createOrUpdatePlayer(this.guildId).setVoiceState(newVoiceState).asMono().subscribe();
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.client.Link");
        Link cfr_ignored_0 = (Link)other;
        return this.guildId == ((Link)other).guildId;
    }

    public int hashCode() {
        return Long.hashCode(this.guildId);
    }
}

