/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.internal;

import dev.arbjerg.lavalink.client.EventsKt;
import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.LavalinkPlayer;
import dev.arbjerg.lavalink.client.Link;
import dev.arbjerg.lavalink.client.LinkState;
import dev.arbjerg.lavalink.internal.loadbalancing.Penalties;
import dev.arbjerg.lavalink.protocol.v4.Mapper;
import dev.arbjerg.lavalink.protocol.v4.Message;
import dev.arbjerg.lavalink.protocol.v4.Stats;
import java.io.Closeable;
import java.io.EOFException;
import java.net.ConnectException;
import java.net.SocketException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020$H\u0002J \u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0016J \u0010,\u001a\u00020$2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0016J\"\u0010-\u001a\u00020$2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0018\u00102\u001a\u00020$2\u0006\u0010(\u001a\u00020\u001e2\u0006\u00103\u001a\u00020+H\u0016J\u0018\u00104\u001a\u00020$2\u0006\u0010(\u001a\u00020\u001e2\u0006\u00100\u001a\u000201H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00065"}, d2={"Ldev/arbjerg/lavalink/internal/LavalinkSocket;", "Lokhttp3/WebSocketListener;", "Ljava/io/Closeable;", "node", "Ldev/arbjerg/lavalink/client/LavalinkNode;", "(Ldev/arbjerg/lavalink/client/LavalinkNode;)V", "lastReconnectAttempt", "", "getLastReconnectAttempt", "()J", "setLastReconnectAttempt", "(J)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mayReconnect", "", "getMayReconnect", "()Z", "setMayReconnect", "(Z)V", "<set-?>", "open", "getOpen", "reconnectInterval", "", "getReconnectInterval", "()I", "reconnectsAttempted", "socket", "Lokhttp3/WebSocket;", "getSocket$lavalink_client", "()Lokhttp3/WebSocket;", "setSocket$lavalink_client", "(Lokhttp3/WebSocket;)V", "attemptReconnect", "", "close", "connect", "onClosed", "webSocket", "code", "reason", "", "onClosing", "onFailure", "t", "", "response", "Lokhttp3/Response;", "onMessage", "text", "onOpen", "lavalink-client"})
@SourceDebugExtension(value={"SMAP\nLavalinkSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LavalinkSocket.kt\ndev/arbjerg/lavalink/internal/LavalinkSocket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,189:1\n1855#2,2:190\n96#3:192\n*S KotlinDebug\n*F\n+ 1 LavalinkSocket.kt\ndev/arbjerg/lavalink/internal/LavalinkSocket\n*L\n42#1:190,2\n51#1:192\n*E\n"})
public final class LavalinkSocket
extends WebSocketListener
implements Closeable {
    @NotNull
    private final LavalinkNode node;
    private final Logger logger;
    @Nullable
    private WebSocket socket;
    private boolean mayReconnect;
    private long lastReconnectAttempt;
    private int reconnectsAttempted;
    private boolean open;

    public LavalinkSocket(@NotNull LavalinkNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
        this.logger = LoggerFactory.getLogger(LavalinkSocket.class);
        this.mayReconnect = true;
        this.connect();
    }

    @Nullable
    public final WebSocket getSocket$lavalink_client() {
        return this.socket;
    }

    public final void setSocket$lavalink_client(@Nullable WebSocket webSocket) {
        this.socket = webSocket;
    }

    public final boolean getMayReconnect() {
        return this.mayReconnect;
    }

    public final void setMayReconnect(boolean bl) {
        this.mayReconnect = bl;
    }

    public final long getLastReconnectAttempt() {
        return this.lastReconnectAttempt;
    }

    public final void setLastReconnectAttempt(long l) {
        this.lastReconnectAttempt = l;
    }

    public final int getReconnectInterval() {
        return this.reconnectsAttempted * 2000 - 2000;
    }

    public final boolean getOpen() {
        return this.open;
    }

    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.logger.info(this.node.getName() + " has been connected!");
        this.node.setAvailable$lavalink_client(true);
        this.open = true;
        this.reconnectsAttempted = 0;
        Iterable $this$forEach$iv = this.node.getPlayerCache$lavalink_client().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LavalinkPlayer player = (LavalinkPlayer)element$iv;
            boolean bl = false;
            player.stateToBuilder$lavalink_client().setNoReplace(false).asMono().subscribe();
        }
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Json this_$iv = Mapper.getJson();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        Message event = (Message)this_$iv.decodeFromString((DeserializationStrategy)Message.Serializer.serializer(), text);
        switch (WhenMappings.$EnumSwitchMapping$0[event.getOp().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.protocol.v4.Message.ReadyEvent");
                String sessionId = ((Message.ReadyEvent)event).getSessionId();
                this.node.setSessionId$lavalink_client(sessionId);
                this.logger.info(this.node.getName() + " is ready with session id " + sessionId);
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.protocol.v4.Message.StatsEvent");
                this.node.setStats$lavalink_client((Stats)((Message.StatsEvent)event));
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.protocol.v4.Message.PlayerUpdateEvent");
                Message.PlayerUpdateEvent update = (Message.PlayerUpdateEvent)event;
                long idLong = Long.parseLong(update.getGuildId());
                Long l = idLong;
                if (!this.node.getPlayerCache$lavalink_client().containsKey(l)) break;
                LavalinkPlayer lavalinkPlayer = this.node.getPlayerCache$lavalink_client().get(idLong);
                Intrinsics.checkNotNull((Object)lavalinkPlayer);
                lavalinkPlayer.setState$lavalink_client(update.getState());
                Link link = this.node.getLavalink().getLinkIfCached(idLong);
                if (link == null) break;
                link.setState$lavalink_client(update.getState().getConnected() ? LinkState.CONNECTED : LinkState.DISCONNECTED);
                break;
            }
            case 4: {
                Penalties penalties = this.node.getPenalties();
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.protocol.v4.Message.EmittedEvent");
                penalties.handleTrackEvent((Message.EmittedEvent)event);
                break;
            }
            default: {
                this.logger.error("Unknown WS message on " + this.node.getName() + ", please report the following information to the devs: '" + text + "'");
            }
        }
        try {
            this.node.getSink$lavalink_client().tryEmitNext(EventsKt.toClientEvent(event, this.node));
        }
        catch (Exception e) {
            this.node.getSink$lavalink_client().tryEmitError((Throwable)e);
        }
    }

    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (this.mayReconnect) {
            this.logger.info(this.node.getName() + " disconnected, reconnecting in " + this.getReconnectInterval() / 1000 + " seconds");
            this.node.setAvailable$lavalink_client(false);
            this.open = false;
        }
    }

    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.node.getLavalink().onNodeDisconnected$lavalink_client(this.node);
        Throwable throwable = t;
        if (throwable instanceof EOFException) {
            this.logger.debug("Got disconnected from " + this.node.getName() + ", trying to reconnect", t);
            this.node.setAvailable$lavalink_client(false);
            this.open = false;
        } else if (throwable instanceof ConnectException) {
            this.logger.error("Failed to connect to WS of " + this.node.getName() + " (" + this.node.getBaseUri() + "), retrying in " + this.getReconnectInterval() / 1000 + " seconds", t);
        } else if (throwable instanceof SocketException) {
            if (!this.open) {
                this.logger.debug("Got a socket exception on " + this.node.getName() + ", but the socket is closed. Ignoring it", t);
                return;
            }
            this.logger.error("Socket error on " + this.node.getName() + ", reconnecting in " + this.getReconnectInterval() / 1000 + " seconds", t);
            this.node.setAvailable$lavalink_client(false);
            this.open = false;
        } else {
            this.logger.error("Unknown error on " + this.node.getName(), t);
        }
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.node.setAvailable$lavalink_client(false);
        this.node.getLavalink().onNodeDisconnected$lavalink_client(this.node);
        if (code == 1000) {
            this.mayReconnect = false;
            Object[] objectArray = new Object[]{this.node.getName(), webSocket.request().url(), reason};
            this.logger.info("Connection to {}({}) closed normally with reason {} (closed by server = true)", objectArray);
        } else {
            Object[] objectArray = new Object[]{this.node.getName(), webSocket.request().url(), code, reason};
            this.logger.info("Connection to {}({}) closed abnormally with reason {}:{} (closed by server = true)", objectArray);
        }
    }

    public final void attemptReconnect() {
        this.lastReconnectAttempt = System.currentTimeMillis();
        int n = this.reconnectsAttempted;
        this.reconnectsAttempted = n + 1;
        this.connect();
    }

    private final void connect() {
        Request.Builder builder;
        Request.Builder $this$connect_u24lambda_u241 = builder = new Request.Builder().url(this.node.getBaseUri() + "/v4/websocket").addHeader("Authorization", this.node.getPassword()).addHeader("Client-Name", "Lavalink-Client/@VERSION@").addHeader("User-Id", String.valueOf(this.node.getLavalink().getUserId()));
        boolean bl = false;
        if (this.node.getSessionId() != null) {
            String string = this.node.getSessionId();
            Intrinsics.checkNotNull((Object)string);
            $this$connect_u24lambda_u241.addHeader("Session-Id", string);
        }
        Request request = builder.build();
        this.socket = this.node.getHttpClient$lavalink_client().newWebSocket(request, (WebSocketListener)this);
    }

    @Override
    public void close() {
        block1: {
            this.mayReconnect = false;
            this.open = false;
            WebSocket webSocket = this.socket;
            if (webSocket != null) {
                webSocket.close(1000, "Client shutdown");
            }
            WebSocket webSocket2 = this.socket;
            if (webSocket2 == null) break block1;
            webSocket2.cancel();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Message.Op.values().length];
            try {
                nArray[Message.Op.Ready.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Op.Stats.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Op.PlayerUpdate.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.Op.Event.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

