/*
 * Decompiled with CFR 0.152.
 */
package dev.arbjerg.lavalink.client;

import dev.arbjerg.lavalink.client.ClientEvent;
import dev.arbjerg.lavalink.client.LavalinkClient;
import dev.arbjerg.lavalink.client.LavalinkNode;
import dev.arbjerg.lavalink.client.LavalinkPlayer;
import dev.arbjerg.lavalink.client.PlayerUpdateBuilder;
import dev.arbjerg.lavalink.client.http.HttpBuilder;
import dev.arbjerg.lavalink.client.loadbalancing.IRegionFilter;
import dev.arbjerg.lavalink.client.protocol.LavalinkLoadResult;
import dev.arbjerg.lavalink.client.protocol.Track;
import dev.arbjerg.lavalink.internal.HelpersKt;
import dev.arbjerg.lavalink.internal.JsonParserKt;
import dev.arbjerg.lavalink.internal.LavalinkRestClient;
import dev.arbjerg.lavalink.internal.LavalinkSocket;
import dev.arbjerg.lavalink.internal.loadbalancing.Penalties;
import dev.arbjerg.lavalink.protocol.v4.Error;
import dev.arbjerg.lavalink.protocol.v4.Info;
import dev.arbjerg.lavalink.protocol.v4.Mapper;
import dev.arbjerg.lavalink.protocol.v4.Player;
import dev.arbjerg.lavalink.protocol.v4.Players;
import dev.arbjerg.lavalink.protocol.v4.Stats;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Sinks;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010G\u001a\u00020HH\u0016J\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020*J.\u0010L\u001a\b\u0012\u0004\u0012\u0002HN0M\"\u0004\b\u0000\u0010N2\f\u0010O\u001a\b\u0012\u0004\u0012\u0002HN0P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RJ%\u0010L\u001a\b\u0012\u0004\u0012\u0002HN0M\"\u0006\b\u0000\u0010N\u0018\u00012\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RH\u0086\bJ.\u0010L\u001a\b\u0012\u0004\u0012\u0002HN0M\"\u0004\b\u0000\u0010N2\f\u0010T\u001a\b\u0012\u0004\u0012\u0002HN0U2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RJ\u001a\u0010V\u001a\b\u0012\u0004\u0012\u00020W0M2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RJ\u0014\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0M2\u0006\u0010Z\u001a\u00020\u0004J \u0010[\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020Y0\\0M2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00040\\J\u0014\u0010]\u001a\b\u0012\u0004\u0012\u00020H0M2\u0006\u0010K\u001a\u00020*J\b\u0010^\u001a\u00020HH\u0016J\u0013\u0010_\u001a\u00020\u000e2\b\u0010`\u001a\u0004\u0018\u00010aH\u0096\u0002J\u0017\u0010b\u001a\u0004\u0018\u00010+2\u0006\u0010K\u001a\u00020*H\u0000\u00a2\u0006\u0002\bcJ\f\u0010d\u001a\b\u0012\u0004\u0012\u00020e0MJ\u0014\u0010f\u001a\b\u0012\u0004\u0012\u00020+0M2\u0006\u0010K\u001a\u00020*J\u0012\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\\0MJ\b\u0010h\u001a\u00020iH\u0016J\u0014\u0010j\u001a\b\u0012\u0004\u0012\u00020k0M2\u0006\u0010l\u001a\u00020\u0004J\u001f\u0010m\u001a\b\u0012\u0004\u0012\u0002HN0\u0018\"\u000e\b\u0000\u0010N\u0018\u0001*\u0006\u0012\u0002\b\u00030\u0019H\u0086\bJ(\u0010m\u001a\b\u0012\u0004\u0012\u0002HN0\u0018\"\f\b\u0000\u0010N*\u0006\u0012\u0002\b\u00030\u00192\f\u0010n\u001a\b\u0012\u0004\u0012\u0002HN0PJ\u0015\u0010o\u001a\u00020H2\u0006\u0010K\u001a\u00020*H\u0000\u00a2\u0006\u0002\bpJ\"\u0010q\u001a\b\u0012\u0004\u0012\u00020+0M2\u0006\u0010K\u001a\u00020*2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020J0sR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0016R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R \u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u000202X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R(\u00105\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0016\"\u0004\b7\u00108R\u001e\u00109\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190:X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R(\u0010>\u001a\u0004\u0018\u00010=2\b\u0010\r\u001a\u0004\u0018\u00010=@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010F\u00a8\u0006t"}, d2={"Ldev/arbjerg/lavalink/client/LavalinkNode;", "Lreactor/core/Disposable;", "Ljava/io/Closeable;", "name", "", "serverUri", "Ljava/net/URI;", "password", "regionFilter", "Ldev/arbjerg/lavalink/client/loadbalancing/IRegionFilter;", "lavalink", "Ldev/arbjerg/lavalink/client/LavalinkClient;", "(Ljava/lang/String;Ljava/net/URI;Ljava/lang/String;Ldev/arbjerg/lavalink/client/loadbalancing/IRegionFilter;Ldev/arbjerg/lavalink/client/LavalinkClient;)V", "<set-?>", "", "available", "getAvailable", "()Z", "setAvailable$lavalink_client", "(Z)V", "baseUri", "getBaseUri", "()Ljava/lang/String;", "flux", "Lreactor/core/publisher/Flux;", "Ldev/arbjerg/lavalink/client/ClientEvent;", "getFlux", "()Lreactor/core/publisher/Flux;", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient$lavalink_client", "()Lokhttp3/OkHttpClient;", "getLavalink", "()Ldev/arbjerg/lavalink/client/LavalinkClient;", "getName", "getPassword", "penalties", "Ldev/arbjerg/lavalink/internal/loadbalancing/Penalties;", "getPenalties", "()Ldev/arbjerg/lavalink/internal/loadbalancing/Penalties;", "playerCache", "", "", "Ldev/arbjerg/lavalink/client/LavalinkPlayer;", "getPlayerCache$lavalink_client", "()Ljava/util/Map;", "reference", "getRegionFilter", "()Ldev/arbjerg/lavalink/client/loadbalancing/IRegionFilter;", "rest", "Ldev/arbjerg/lavalink/internal/LavalinkRestClient;", "getRest$lavalink_client", "()Ldev/arbjerg/lavalink/internal/LavalinkRestClient;", "sessionId", "getSessionId", "setSessionId$lavalink_client", "(Ljava/lang/String;)V", "sink", "Lreactor/core/publisher/Sinks$Many;", "getSink$lavalink_client", "()Lreactor/core/publisher/Sinks$Many;", "Ldev/arbjerg/lavalink/protocol/v4/Stats;", "stats", "getStats", "()Ldev/arbjerg/lavalink/protocol/v4/Stats;", "setStats$lavalink_client", "(Ldev/arbjerg/lavalink/protocol/v4/Stats;)V", "ws", "Ldev/arbjerg/lavalink/internal/LavalinkSocket;", "getWs", "()Ldev/arbjerg/lavalink/internal/LavalinkSocket;", "close", "", "createOrUpdatePlayer", "Ldev/arbjerg/lavalink/client/PlayerUpdateBuilder;", "guildId", "customJsonRequest", "Lreactor/core/publisher/Mono;", "T", "decodeTo", "Ljava/lang/Class;", "builderFn", "Ljava/util/function/UnaryOperator;", "Ldev/arbjerg/lavalink/client/http/HttpBuilder;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "customRequest", "Lokhttp3/Response;", "decodeTrack", "Ldev/arbjerg/lavalink/client/protocol/Track;", "encoded", "decodeTracks", "", "destroyPlayer", "dispose", "equals", "other", "", "getCachedPlayer", "getCachedPlayer$lavalink_client", "getNodeInfo", "Ldev/arbjerg/lavalink/protocol/v4/Info;", "getPlayer", "getPlayers", "hashCode", "", "loadItem", "Ldev/arbjerg/lavalink/client/protocol/LavalinkLoadResult;", "identifier", "on", "type", "removeCachedPlayer", "removeCachedPlayer$lavalink_client", "updatePlayer", "updateConsumer", "Ljava/util/function/Consumer;", "lavalink-client"})
public final class LavalinkNode
implements Disposable,
Closeable {
    @NotNull
    private final String name;
    @NotNull
    private final String password;
    @Nullable
    private final IRegionFilter regionFilter;
    @NotNull
    private final LavalinkClient lavalink;
    @NotNull
    private final String baseUri;
    @Nullable
    private String sessionId;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final Sinks.Many<ClientEvent<?>> sink;
    @NotNull
    private final Flux<ClientEvent<?>> flux;
    @NotNull
    private final Disposable reference;
    @NotNull
    private final LavalinkRestClient rest;
    @NotNull
    private final LavalinkSocket ws;
    @NotNull
    private final Penalties penalties;
    @Nullable
    private Stats stats;
    private boolean available;
    @NotNull
    private final Map<Long, LavalinkPlayer> playerCache;

    public LavalinkNode(@NotNull String name, @NotNull URI serverUri, @NotNull String password, @Nullable IRegionFilter regionFilter, @NotNull LavalinkClient lavalink) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)lavalink, (String)"lavalink");
        this.name = name;
        this.password = password;
        this.regionFilter = regionFilter;
        this.lavalink = lavalink;
        this.baseUri = serverUri.getScheme() + "://" + serverUri.getHost() + ":" + serverUri.getPort();
        this.httpClient = new OkHttpClient();
        Sinks.Many many = Sinks.many().multicast().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)many, (String)"onBackpressureBuffer(...)");
        this.sink = many;
        Flux flux = this.sink.asFlux();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"asFlux(...)");
        this.flux = flux;
        Disposable disposable = this.flux.subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.reference = disposable;
        this.rest = new LavalinkRestClient(this);
        this.ws = new LavalinkSocket(this);
        this.penalties = new Penalties(this);
        this.playerCache = new LinkedHashMap();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    @Nullable
    public final IRegionFilter getRegionFilter() {
        return this.regionFilter;
    }

    @NotNull
    public final LavalinkClient getLavalink() {
        return this.lavalink;
    }

    @NotNull
    public final String getBaseUri() {
        return this.baseUri;
    }

    @Nullable
    public final String getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId$lavalink_client(@Nullable String string) {
        this.sessionId = string;
    }

    @NotNull
    public final OkHttpClient getHttpClient$lavalink_client() {
        return this.httpClient;
    }

    @NotNull
    public final Sinks.Many<ClientEvent<?>> getSink$lavalink_client() {
        return this.sink;
    }

    @NotNull
    public final Flux<ClientEvent<?>> getFlux() {
        return this.flux;
    }

    @NotNull
    public final LavalinkRestClient getRest$lavalink_client() {
        return this.rest;
    }

    @NotNull
    public final LavalinkSocket getWs() {
        return this.ws;
    }

    @NotNull
    public final Penalties getPenalties() {
        return this.penalties;
    }

    @Nullable
    public final Stats getStats() {
        return this.stats;
    }

    public final void setStats$lavalink_client(@Nullable Stats stats) {
        this.stats = stats;
    }

    public final boolean getAvailable() {
        return this.available;
    }

    public final void setAvailable$lavalink_client(boolean bl) {
        this.available = bl;
    }

    @NotNull
    public final Map<Long, LavalinkPlayer> getPlayerCache$lavalink_client() {
        return this.playerCache;
    }

    public void dispose() {
        this.close();
    }

    @Override
    public void close() {
        this.available = false;
        this.ws.close();
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
        Cache cache = this.httpClient.cache();
        if (cache != null) {
            cache.close();
        }
        this.reference.dispose();
    }

    @NotNull
    public final <T extends ClientEvent<?>> Flux<T> on(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Flux flux = this.flux.ofType(type);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"ofType(...)");
        return flux;
    }

    public final /* synthetic */ <T extends ClientEvent<?>> Flux<T> on() {
        boolean $i$f$on = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.on(ClientEvent.class);
    }

    @NotNull
    public final Mono<List<LavalinkPlayer>> getPlayers() {
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = this.rest.getPlayers().map(arg_0 -> LavalinkNode.getPlayers$lambda$0((Function1)new Function1<Players, List<? extends LavalinkPlayer>>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<LavalinkPlayer> invoke-k96aCsM(List<? extends Player> it) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List<? extends Player> list = it;
                Intrinsics.checkNotNull((Object)(list != null ? Players.box-impl(list) : null));
                Iterable iterable = it;
                LavalinkNode lavalinkNode = this.this$0;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void pl;
                    Player player = (Player)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(HelpersKt.toLavalinkPlayer((Player)pl, lavalinkNode));
                }
                return (List)destination$iv$iv;
            }
        }, arg_0)).doOnNext(arg_0 -> LavalinkNode.getPlayers$lambda$1((Function1)new Function1<List<? extends LavalinkPlayer>, Unit>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(List<LavalinkPlayer> it) {
                void $this$forEach$iv;
                Intrinsics.checkNotNull(it);
                Iterable iterable = it;
                LavalinkNode lavalinkNode = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    LavalinkPlayer player = (LavalinkPlayer)element$iv;
                    boolean bl = false;
                    lavalinkNode.getPlayerCache$lavalink_client().put(player.getGuildId(), player);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnNext(...)");
        return mono;
    }

    @NotNull
    public final Mono<LavalinkPlayer> getPlayer(long guildId) {
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Long l = guildId;
        if (this.playerCache.containsKey(l)) {
            return MonoExtensionsKt.toMono((Object)this.playerCache.get(guildId));
        }
        Mono mono = this.rest.getPlayer(guildId).map(arg_0 -> LavalinkNode.getPlayer$lambda$2((Function1)new Function1<Player, LavalinkPlayer>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final LavalinkPlayer invoke(Player it) {
                Intrinsics.checkNotNull((Object)it);
                return HelpersKt.toLavalinkPlayer(it, this.this$0);
            }
        }, arg_0)).onErrorResume(arg_0 -> LavalinkNode.getPlayer$lambda$3((Function1)new Function1<Throwable, Mono<? extends LavalinkPlayer>>(this, guildId){
            final /* synthetic */ LavalinkNode this$0;
            final /* synthetic */ long $guildId;
            {
                this.this$0 = $receiver;
                this.$guildId = $guildId;
                super(1);
            }

            public final Mono<? extends LavalinkPlayer> invoke(Throwable it) {
                return this.this$0.createOrUpdatePlayer(this.$guildId).asMono();
            }
        }, arg_0)).doOnNext(arg_0 -> LavalinkNode.getPlayer$lambda$4((Function1)new Function1<LavalinkPlayer, Unit>(this){
            final /* synthetic */ LavalinkNode this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(LavalinkPlayer it) {
                Map<Long, LavalinkPlayer> map = this.this$0.getPlayerCache$lavalink_client();
                Long l = it.getGuildId();
                Intrinsics.checkNotNull((Object)it);
                map.put(l, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnNext(...)");
        return mono;
    }

    @NotNull
    public final Mono<LavalinkPlayer> updatePlayer(long guildId, @NotNull Consumer<PlayerUpdateBuilder> updateConsumer) {
        Intrinsics.checkNotNullParameter(updateConsumer, (String)"updateConsumer");
        PlayerUpdateBuilder update = this.createOrUpdatePlayer(guildId);
        updateConsumer.accept(update);
        return update.asMono();
    }

    @NotNull
    public final PlayerUpdateBuilder createOrUpdatePlayer(long guildId) {
        return new PlayerUpdateBuilder(this, guildId);
    }

    @NotNull
    public final Mono<Unit> destroyPlayer(long guildId) {
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = this.rest.destroyPlayer(guildId).doOnNext(arg_0 -> LavalinkNode.destroyPlayer$lambda$5((Function1)new Function1<Unit, Unit>(this, guildId){
            final /* synthetic */ LavalinkNode this$0;
            final /* synthetic */ long $guildId;
            {
                this.this$0 = $receiver;
                this.$guildId = $guildId;
                super(1);
            }

            public final void invoke(Unit it) {
                this.this$0.getPlayerCache$lavalink_client().remove(this.$guildId);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnNext(...)");
        return mono;
    }

    public final void removeCachedPlayer$lavalink_client(long guildId) {
        this.playerCache.remove(guildId);
    }

    @NotNull
    public final Mono<LavalinkLoadResult> loadItem(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = this.rest.loadItem(identifier).map(arg_0 -> LavalinkNode.loadItem$lambda$6(loadItem.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public final Mono<Track> decodeTrack(@NotNull String encoded) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = this.rest.decodeTrack(encoded).map(arg_0 -> LavalinkNode.decodeTrack$lambda$7(decodeTrack.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public final Mono<List<Track>> decodeTracks(@NotNull List<String> encoded) {
        Intrinsics.checkNotNullParameter(encoded, (String)"encoded");
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = this.rest.decodeTracks(encoded).map(arg_0 -> LavalinkNode.decodeTracks$lambda$8(decodeTracks.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public final Mono<Info> getNodeInfo() {
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        return this.rest.getNodeInfo();
    }

    @NotNull
    public final Mono<Response> customRequest(@NotNull UnaryOperator<HttpBuilder> builderFn) {
        Intrinsics.checkNotNullParameter(builderFn, (String)"builderFn");
        if (!this.available) {
            Mono mono = Mono.error((Throwable)new IllegalStateException("Node is not available"));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Call call2 = this.rest.newRequest$lavalink_client((Function1<? super HttpBuilder, HttpBuilder>)((Function1)new Function1<HttpBuilder, HttpBuilder>(builderFn){
            final /* synthetic */ UnaryOperator<HttpBuilder> $builderFn;
            {
                this.$builderFn = $builderFn;
                super(1);
            }

            @NotNull
            public final HttpBuilder invoke(@NotNull HttpBuilder $this$newRequest) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$newRequest), (String)"$this$newRequest");
                R r = this.$builderFn.apply($this$newRequest);
                Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
                return (HttpBuilder)((Object)r);
            }
        }));
        Mono mono = Mono.create(arg_0 -> LavalinkNode.customRequest$lambda$10(call2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"create(...)");
        return mono;
    }

    public final /* synthetic */ <T> Mono<T> customJsonRequest(UnaryOperator<HttpBuilder> builderFn) {
        Intrinsics.checkNotNullParameter(builderFn, (String)"builderFn");
        boolean $i$f$customJsonRequest = false;
        SerializersModule serializersModule = Mapper.getJson().getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return this.customJsonRequest((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), builderFn);
    }

    @NotNull
    public final <T> Mono<T> customJsonRequest(@NotNull DeserializationStrategy<? extends T> deserializer, @NotNull UnaryOperator<HttpBuilder> builderFn) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter(builderFn, (String)"builderFn");
        Mono mono = this.customRequest(builderFn).flatMap(arg_0 -> LavalinkNode.customJsonRequest$lambda$11((Function1)new Function1<Response, Mono<? extends T>>(deserializer){
            final /* synthetic */ DeserializationStrategy<T> $deserializer;
            {
                this.$deserializer = $deserializer;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Mono<? extends T> invoke(Response response) {
                Closeable closeable = (Closeable)response;
                DeserializationStrategy<T> deserializationStrategy = this.$deserializer;
                Throwable throwable = null;
                try {
                    Response it = (Response)closeable;
                    boolean bl = false;
                    if (!response.isSuccessful()) {
                        ResponseBody responseBody = response.body();
                        Intrinsics.checkNotNull((Object)responseBody);
                        String body = responseBody.string();
                        if (((CharSequence)body).length() == 0) {
                            Mono mono = Mono.error((Throwable)new IllegalStateException("Request failed with code " + response.code()));
                            return mono;
                        }
                        Json this_$iv = Mapper.getJson();
                        boolean $i$f$decodeFromString = false;
                        this_$iv.getSerializersModule();
                        Error error = (Error)this_$iv.decodeFromString((DeserializationStrategy)Error.Companion.serializer(), body);
                        boolean bl2 = false;
                        Mono mono = Mono.error((Throwable)new IllegalStateException("Request failed with code " + response.code() + " and message " + error.getMessage()));
                        return mono;
                    }
                    if (response.code() == 204) {
                        Mono mono = Mono.empty();
                        return mono;
                    }
                    Json json = Mapper.getJson();
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    Object object = JvmStreamsKt.decodeFromStream((Json)json, deserializationStrategy, (InputStream)responseBody.byteStream());
                    Intrinsics.checkNotNull((Object)object);
                    Mono mono = MonoExtensionsKt.toMono((Object)object);
                    return mono;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @NotNull
    public final <T> Mono<T> customJsonRequest(@NotNull Class<T> decodeTo, @NotNull UnaryOperator<HttpBuilder> builderFn) {
        Intrinsics.checkNotNullParameter(decodeTo, (String)"decodeTo");
        Intrinsics.checkNotNullParameter(builderFn, (String)"builderFn");
        Mono mono = this.customRequest(builderFn).flatMap(arg_0 -> LavalinkNode.customJsonRequest$lambda$12((Function1)new Function1<Response, Mono<? extends T>>(decodeTo){
            final /* synthetic */ Class<T> $decodeTo;
            {
                this.$decodeTo = $decodeTo;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Mono<? extends T> invoke(Response response) {
                Closeable closeable = (Closeable)response;
                Class<T> clazz = this.$decodeTo;
                Throwable throwable = null;
                try {
                    Response it = (Response)closeable;
                    boolean bl = false;
                    if (!response.isSuccessful()) {
                        ResponseBody responseBody = response.body();
                        Intrinsics.checkNotNull((Object)responseBody);
                        String body = responseBody.string();
                        if (((CharSequence)body).length() == 0) {
                            Mono mono = Mono.error((Throwable)new IllegalStateException("Request failed with code " + response.code()));
                            return mono;
                        }
                        Json this_$iv = Mapper.getJson();
                        boolean $i$f$decodeFromString = false;
                        this_$iv.getSerializersModule();
                        Error error = (Error)this_$iv.decodeFromString((DeserializationStrategy)Error.Companion.serializer(), body);
                        boolean bl2 = false;
                        Mono mono = Mono.error((Throwable)new IllegalStateException("Request failed with code " + response.code() + " and message " + error.getMessage()));
                        return mono;
                    }
                    if (response.code() == 204) {
                        Mono mono = Mono.empty();
                        return mono;
                    }
                    ResponseBody responseBody = response.body();
                    Intrinsics.checkNotNull((Object)responseBody);
                    T t = JsonParserKt.fromRawJson(responseBody.byteStream(), clazz);
                    Intrinsics.checkNotNull(t);
                    Mono mono = MonoExtensionsKt.toMono(t);
                    return mono;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @Nullable
    public final LavalinkPlayer getCachedPlayer$lavalink_client(long guildId) {
        Long l = guildId;
        if (this.playerCache.containsKey(l)) {
            return this.playerCache.get(guildId);
        }
        return null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.client.LavalinkNode");
        LavalinkNode cfr_ignored_0 = (LavalinkNode)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((LavalinkNode)other).name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.password, (Object)((LavalinkNode)other).password)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.regionFilter, (Object)((LavalinkNode)other).regionFilter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.baseUri, (Object)((LavalinkNode)other).baseUri)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sessionId, (Object)((LavalinkNode)other).sessionId)) {
            return false;
        }
        return this.available == ((LavalinkNode)other).available;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.password.hashCode();
        IRegionFilter iRegionFilter = this.regionFilter;
        result = 31 * result + (iRegionFilter != null ? iRegionFilter.hashCode() : 0);
        result = 31 * result + this.baseUri.hashCode();
        String string = this.sessionId;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        result = 31 * result + Boolean.hashCode(this.available);
        return result;
    }

    private static final List getPlayers$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final void getPlayers$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final LavalinkPlayer getPlayer$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LavalinkPlayer)$tmp0.invoke(p0);
    }

    private static final Mono getPlayer$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void getPlayer$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void destroyPlayer$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final LavalinkLoadResult loadItem$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LavalinkLoadResult)$tmp0.invoke(p0);
    }

    private static final Track decodeTrack$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Track)$tmp0.invoke(p0);
    }

    private static final List decodeTracks$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final void customRequest$lambda$10$lambda$9(Call $call) {
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        $call.cancel();
    }

    private static final void customRequest$lambda$10(Call $call, MonoSink sink) {
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        sink.onCancel(() -> LavalinkNode.customRequest$lambda$10$lambda$9($call));
        $call.enqueue(new Callback((MonoSink<Response>)sink){
            final /* synthetic */ MonoSink<Response> $sink;
            {
                this.$sink = $sink;
            }

            public void onFailure(@NotNull Call call2, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$sink.error((Throwable)e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call2, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Closeable closeable = (Closeable)response;
                MonoSink<Response> monoSink = this.$sink;
                Throwable throwable = null;
                try {
                    Response res = (Response)closeable;
                    boolean bl = false;
                    monoSink.success((Object)res);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
    }

    private static final Mono customJsonRequest$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono customJsonRequest$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }
}

